/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.compress;

import com.google.common.primitives.Ints;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ThreadLocalRandom;
import java.util.zip.Checksum;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.compress.CorruptBlockException;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.io.util.ICompressedFile;
import org.apache.cassandra.io.util.MmappedRegions;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.utils.memory.BufferPool;

public class CompressedRandomAccessReader
extends RandomAccessReader {
    private final CompressionMetadata metadata;
    private ByteBuffer compressed;
    private final Checksum checksum;
    private ByteBuffer checksumBytes;

    protected CompressedRandomAccessReader(Builder builder) {
        super(builder.initializeBuffers(false));
        this.metadata = builder.metadata;
        this.checksum = this.metadata.checksumType.newInstance();
        this.initializeBuffer();
    }

    @Override
    protected int getBufferSize(RandomAccessReader.Builder builder) {
        return builder.bufferSize;
    }

    @Override
    protected void initializeBuffer() {
        this.buffer = this.allocateBuffer(this.bufferSize);
        this.buffer.limit(0);
        if (this.regions == null) {
            this.compressed = this.allocateBuffer(this.metadata.compressor().initialCompressedBufferLength(this.metadata.chunkLength()));
            this.checksumBytes = ByteBuffer.wrap(new byte[4]);
        }
    }

    @Override
    protected void releaseBuffer() {
        try {
            if (this.buffer != null) {
                BufferPool.put(this.buffer);
                this.buffer = null;
            }
        }
        finally {
            if (this.compressed != null) {
                BufferPool.put(this.compressed);
                this.compressed = null;
            }
        }
    }

    @Override
    protected void reBufferStandard() {
        try {
            long position = this.current();
            assert (position < this.metadata.dataLength);
            CompressionMetadata.Chunk chunk = this.metadata.chunkFor(position);
            if (this.compressed.capacity() < chunk.length) {
                BufferPool.put(this.compressed);
                this.compressed = this.allocateBuffer(chunk.length);
            } else {
                this.compressed.clear();
            }
            this.compressed.limit(chunk.length);
            if (this.channel.read(this.compressed, chunk.offset) != chunk.length) {
                throw new CorruptBlockException(this.getPath(), chunk);
            }
            this.compressed.flip();
            this.buffer.clear();
            try {
                this.metadata.compressor().uncompress(this.compressed, this.buffer);
            }
            catch (IOException e) {
                throw new CorruptBlockException(this.getPath(), chunk);
            }
            finally {
                this.buffer.flip();
            }
            if (this.metadata.parameters.getCrcCheckChance() > ThreadLocalRandom.current().nextDouble()) {
                this.compressed.rewind();
                this.metadata.checksumType.update(this.checksum, this.compressed);
                if (this.checksum(chunk) != (int)this.checksum.getValue()) {
                    throw new CorruptBlockException(this.getPath(), chunk);
                }
                this.checksum.reset();
            }
            this.bufferOffset = position & (long)(~(this.buffer.capacity() - 1));
            this.buffer.position((int)(position - this.bufferOffset));
            if (this.bufferOffset + (long)this.buffer.limit() > this.length()) {
                this.buffer.limit((int)(this.length() - this.bufferOffset));
            }
        }
        catch (CorruptBlockException e) {
            throw new CorruptSSTableException((Exception)e, this.getPath());
        }
        catch (IOException e) {
            throw new FSReadError((Throwable)e, this.getPath());
        }
    }

    @Override
    protected void reBufferMmap() {
        try {
            long position = this.current();
            assert (position < this.metadata.dataLength);
            CompressionMetadata.Chunk chunk = this.metadata.chunkFor(position);
            MmappedRegions.Region region = this.regions.floor(chunk.offset);
            long segmentOffset = region.bottom();
            int chunkOffset = Ints.checkedCast((long)(chunk.offset - segmentOffset));
            ByteBuffer compressedChunk = region.buffer.duplicate();
            compressedChunk.position(chunkOffset).limit(chunkOffset + chunk.length);
            this.buffer.clear();
            try {
                this.metadata.compressor().uncompress(compressedChunk, this.buffer);
            }
            catch (IOException e) {
                throw new CorruptBlockException(this.getPath(), chunk);
            }
            finally {
                this.buffer.flip();
            }
            if (this.metadata.parameters.getCrcCheckChance() > ThreadLocalRandom.current().nextDouble()) {
                compressedChunk.position(chunkOffset).limit(chunkOffset + chunk.length);
                this.metadata.checksumType.update(this.checksum, compressedChunk);
                compressedChunk.limit(compressedChunk.capacity());
                if (compressedChunk.getInt() != (int)this.checksum.getValue()) {
                    throw new CorruptBlockException(this.getPath(), chunk);
                }
                this.checksum.reset();
            }
            this.bufferOffset = position & (long)(~(this.buffer.capacity() - 1));
            this.buffer.position((int)(position - this.bufferOffset));
            if (this.bufferOffset + (long)this.buffer.limit() > this.length()) {
                this.buffer.limit((int)(this.length() - this.bufferOffset));
            }
        }
        catch (CorruptBlockException e) {
            throw new CorruptSSTableException((Exception)e, this.getPath());
        }
    }

    private int checksum(CompressionMetadata.Chunk chunk) throws IOException {
        long position = chunk.offset + (long)chunk.length;
        this.checksumBytes.clear();
        if (this.channel.read(this.checksumBytes, position) != this.checksumBytes.capacity()) {
            throw new CorruptBlockException(this.getPath(), chunk);
        }
        return this.checksumBytes.getInt(0);
    }

    @Override
    public long length() {
        return this.metadata.dataLength;
    }

    @Override
    public String toString() {
        return String.format("%s - chunk length %d, data length %d.", this.getPath(), this.metadata.chunkLength(), this.metadata.dataLength);
    }

    public static final class Builder
    extends RandomAccessReader.Builder {
        private final CompressionMetadata metadata;

        public Builder(ICompressedFile file) {
            super(file.channel());
            this.metadata = this.applyMetadata(file.getMetadata());
            this.regions = file.regions();
        }

        public Builder(ChannelProxy channel, CompressionMetadata metadata) {
            super(channel);
            this.metadata = this.applyMetadata(metadata);
        }

        private CompressionMetadata applyMetadata(CompressionMetadata metadata) {
            this.overrideLength = metadata.compressedFileLength;
            this.bufferSize = metadata.chunkLength();
            this.bufferType = metadata.compressor().preferredBufferType();
            assert (Integer.bitCount(this.bufferSize) == 1);
            return metadata;
        }

        @Override
        public RandomAccessReader build() {
            return new CompressedRandomAccessReader(this);
        }
    }
}

