/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.view;

import com.google.common.collect.Iterables;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.MaterializedViewDefinition;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.statements.CFProperties;
import org.apache.cassandra.db.AbstractReadCommandBuilder;
import org.apache.cassandra.db.CBuilder;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.LivenessInfo;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.ReadOrderGroup;
import org.apache.cassandra.db.ReadQuery;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.partitions.AbstractBTreePartition;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.rows.BTreeRow;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.ColumnData;
import org.apache.cassandra.db.rows.ComplexColumnData;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.view.MaterializedViewBuilder;
import org.apache.cassandra.db.view.TemporalRow;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.service.pager.QueryPager;

public class MaterializedView {
    public final String name;
    private final ColumnFamilyStore baseCfs;
    private ColumnFamilyStore _viewCfs = null;
    private MVColumns columns;
    private final boolean viewHasAllPrimaryKeys;
    private final boolean includeAll;
    private MaterializedViewBuilder builder;

    public MaterializedView(MaterializedViewDefinition definition, ColumnFamilyStore baseCfs) {
        this.baseCfs = baseCfs;
        this.name = definition.viewName;
        this.includeAll = definition.includeAll;
        this.viewHasAllPrimaryKeys = this.updateDefinition(definition);
    }

    public ColumnFamilyStore getViewCfs() {
        if (this._viewCfs == null) {
            this._viewCfs = Keyspace.openAndGetStore(Schema.instance.getCFMetaData(this.baseCfs.keyspace.getName(), this.name));
        }
        return this._viewCfs;
    }

    private boolean resolveAndAddColumns(Iterable<ColumnIdentifier> columns, List<ColumnDefinition> ... definitions) {
        boolean allArePrimaryKeys = true;
        for (ColumnIdentifier identifier : columns) {
            ColumnDefinition cdef = this.baseCfs.metadata.getColumnDefinition(identifier);
            assert (cdef != null) : "Could not resolve column " + identifier.toString();
            for (List<ColumnDefinition> list : definitions) {
                list.add(cdef);
            }
            allArePrimaryKeys = allArePrimaryKeys && cdef.isPrimaryKeyColumn();
        }
        return allArePrimaryKeys;
    }

    public boolean updateDefinition(MaterializedViewDefinition definition) {
        ArrayList partitionDefs = new ArrayList(definition.partitionColumns.size());
        ArrayList primaryKeyDefs = new ArrayList(definition.partitionColumns.size() + definition.clusteringColumns.size());
        ArrayList<ColumnDefinition> baseComplexColumns = new ArrayList<ColumnDefinition>();
        boolean partitionAllPrimaryKeyColumns = this.resolveAndAddColumns(definition.partitionColumns, primaryKeyDefs, partitionDefs);
        boolean clusteringAllPrimaryKeyColumns = this.resolveAndAddColumns(definition.clusteringColumns, primaryKeyDefs);
        for (ColumnDefinition cdef : this.baseCfs.metadata.allColumns()) {
            if (!cdef.isComplex()) continue;
            baseComplexColumns.add(cdef);
        }
        this.columns = new MVColumns(partitionDefs, primaryKeyDefs, baseComplexColumns);
        return partitionAllPrimaryKeyColumns && clusteringAllPrimaryKeyColumns;
    }

    public boolean updateAffectsView(AbstractBTreePartition partition) {
        if (this.includeAll) {
            return true;
        }
        if (!partition.deletionInfo().isLive()) {
            return true;
        }
        for (Row row : partition) {
            if (row.hasComplexDeletion()) {
                return true;
            }
            if (!row.deletion().isLive()) {
                return true;
            }
            for (ColumnData data : row) {
                if (this.getViewCfs().metadata.getColumnDefinition(data.column().name) == null) continue;
                return true;
            }
        }
        return false;
    }

    private Clustering viewClustering(TemporalRow temporalRow, TemporalRow.Resolver resolver) {
        CFMetaData viewCfm = this.getViewCfs().metadata;
        int numViewClustering = viewCfm.clusteringColumns().size();
        CBuilder clustering = CBuilder.create(this.getViewCfs().getComparator());
        for (int i = 0; i < numViewClustering; ++i) {
            ColumnDefinition definition = viewCfm.clusteringColumns().get(i);
            clustering.add(temporalRow.clusteringValue(definition, resolver));
        }
        return clustering.build();
    }

    private PartitionUpdate createTombstone(TemporalRow temporalRow, DecoratedKey partitionKey, DeletionTime deletionTime, TemporalRow.Resolver resolver, int nowInSec) {
        CFMetaData viewCfm = this.getViewCfs().metadata;
        Row.Builder builder = BTreeRow.unsortedBuilder(nowInSec);
        builder.newRow(this.viewClustering(temporalRow, resolver));
        builder.addRowDeletion(deletionTime);
        return PartitionUpdate.singleRowUpdate(viewCfm, partitionKey, builder.build());
    }

    private PartitionUpdate createComplexTombstone(TemporalRow temporalRow, DecoratedKey partitionKey, ColumnDefinition deletedColumn, DeletionTime deletionTime, TemporalRow.Resolver resolver, int nowInSec) {
        CFMetaData viewCfm = this.getViewCfs().metadata;
        Row.Builder builder = BTreeRow.unsortedBuilder(nowInSec);
        builder.newRow(this.viewClustering(temporalRow, resolver));
        builder.addComplexDeletion(deletedColumn, deletionTime);
        return PartitionUpdate.singleRowUpdate(viewCfm, partitionKey, builder.build());
    }

    private DecoratedKey viewPartitionKey(TemporalRow temporalRow, TemporalRow.Resolver resolver) {
        List<ColumnDefinition> partitionDefs = this.columns.partitionDefs;
        Object[] partitionKey = new Object[partitionDefs.size()];
        for (int i = 0; i < partitionKey.length; ++i) {
            ByteBuffer value = temporalRow.clusteringValue(partitionDefs.get(i), resolver);
            if (value == null) {
                return null;
            }
            partitionKey[i] = value;
        }
        CFMetaData metadata = this.getViewCfs().metadata;
        return metadata.decorateKey(CFMetaData.serializePartitionKey(metadata.getKeyValidatorAsClusteringComparator().make(partitionKey)));
    }

    private PartitionUpdate createRangeTombstoneForRow(TemporalRow temporalRow) {
        if (this.viewHasAllPrimaryKeys) {
            return null;
        }
        boolean hasUpdate = false;
        List<ColumnDefinition> primaryKeyDefs = this.columns.primaryKeyDefs;
        for (ColumnDefinition viewPartitionKeys : primaryKeyDefs) {
            if (viewPartitionKeys.isPrimaryKeyColumn() || temporalRow.clusteringValue(viewPartitionKeys, TemporalRow.oldValueIfUpdated) == null) continue;
            hasUpdate = true;
        }
        if (!hasUpdate) {
            return null;
        }
        TemporalRow.Resolver resolver = TemporalRow.earliest;
        return this.createTombstone(temporalRow, this.viewPartitionKey(temporalRow, resolver), new DeletionTime(temporalRow.viewClusteringTimestamp(), temporalRow.nowInSec), resolver, temporalRow.nowInSec);
    }

    private PartitionUpdate createUpdatesForInserts(TemporalRow temporalRow) {
        TemporalRow.Resolver resolver = TemporalRow.latest;
        DecoratedKey partitionKey = this.viewPartitionKey(temporalRow, resolver);
        ColumnFamilyStore viewCfs = this.getViewCfs();
        if (partitionKey == null) {
            return null;
        }
        Row.Builder regularBuilder = BTreeRow.unsortedBuilder(temporalRow.nowInSec);
        CBuilder clustering = CBuilder.create(viewCfs.getComparator());
        for (int i = 0; i < viewCfs.metadata.clusteringColumns().size(); ++i) {
            clustering.add(temporalRow.clusteringValue(viewCfs.metadata.clusteringColumns().get(i), resolver));
        }
        regularBuilder.newRow(clustering.build());
        regularBuilder.addPrimaryKeyLivenessInfo(LivenessInfo.create(viewCfs.metadata, temporalRow.viewClusteringTimestamp(), temporalRow.viewClusteringTtl(), temporalRow.viewClusteringLocalDeletionTime()));
        for (ColumnDefinition columnDefinition : viewCfs.metadata.allColumns()) {
            if (columnDefinition.isPrimaryKeyColumn()) continue;
            for (Cell cell : temporalRow.values(columnDefinition, resolver)) {
                regularBuilder.addCell(cell);
            }
        }
        return PartitionUpdate.singleRowUpdate(viewCfs.metadata, partitionKey, regularBuilder.build());
    }

    private Collection<Mutation> createForDeletionInfo(TemporalRow.Set rowSet, AbstractBTreePartition partition) {
        Object columnData;
        TemporalRow.Resolver resolver = TemporalRow.earliest;
        DeletionInfo deletionInfo = partition.deletionInfo();
        ArrayList<Mutation> mutations = new ArrayList<Mutation>();
        if (!this.columns.baseComplexColumns.isEmpty()) {
            for (Row row : partition) {
                if (!row.hasComplexDeletion()) continue;
                TemporalRow temporalRow = rowSet.getClustering(row.clustering());
                assert (temporalRow != null);
                for (ColumnDefinition definition : this.columns.baseComplexColumns) {
                    DecoratedKey targetKey;
                    DeletionTime time;
                    columnData = row.getComplexColumnData(definition);
                    if (columnData == null || (time = ((ComplexColumnData)columnData).complexDeletion()).isLive() || (targetKey = this.viewPartitionKey(temporalRow, resolver)) == null) continue;
                    mutations.add(new Mutation(this.createComplexTombstone(temporalRow, targetKey, definition, time, resolver, temporalRow.nowInSec)));
                }
            }
        }
        ReadQuery command = null;
        if (!deletionInfo.isLive()) {
            DecoratedKey dk = rowSet.dk;
            if (deletionInfo.hasRanges()) {
                AbstractReadCommandBuilder.SinglePartitionSliceBuilder builder = new AbstractReadCommandBuilder.SinglePartitionSliceBuilder(this.baseCfs, dk);
                Iterator<RangeTombstone> tombstones = deletionInfo.rangeIterator(false);
                while (tombstones.hasNext()) {
                    RangeTombstone tombstone = tombstones.next();
                    builder.addSlice(tombstone.deletedSlice());
                }
                command = builder.build();
            } else {
                command = SinglePartitionReadCommand.fullPartitionRead(this.baseCfs.metadata, rowSet.nowInSec, dk);
            }
        }
        if (command == null) {
            AbstractReadCommandBuilder.SinglePartitionSliceBuilder builder = null;
            for (Object row : partition) {
                if (row.deletion().isLive()) continue;
                if (builder == null) {
                    builder = new AbstractReadCommandBuilder.SinglePartitionSliceBuilder(this.baseCfs, rowSet.dk);
                }
                builder.addSlice(Slice.make(row.clustering()));
            }
            if (builder != null) {
                command = builder.build();
            }
        }
        if (command != null) {
            if (!rowSet.hasTombstonedExisting()) {
                QueryPager pager = command.getPager(null);
                while (!pager.isExhausted()) {
                    Object row;
                    ReadOrderGroup orderGroup = pager.startOrderGroup();
                    row = null;
                    try {
                        PartitionIterator iter = pager.fetchPageInternal(128, orderGroup);
                        columnData = null;
                        try {
                            if (!iter.hasNext()) break;
                            RowIterator rowIterator = (RowIterator)iter.next();
                            Throwable throwable = null;
                            try {
                                while (rowIterator.hasNext()) {
                                    Row row2 = (Row)rowIterator.next();
                                    rowSet.addRow(row2, false);
                                }
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (rowIterator == null) continue;
                                if (throwable != null) {
                                    try {
                                        rowIterator.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                rowIterator.close();
                            }
                        }
                        catch (Throwable throwable) {
                            columnData = throwable;
                            throw throwable;
                        }
                        finally {
                            if (iter == null) continue;
                            if (columnData != null) {
                                try {
                                    iter.close();
                                }
                                catch (Throwable time) {
                                    ((Throwable)columnData).addSuppressed(time);
                                }
                                continue;
                            }
                            iter.close();
                        }
                    }
                    catch (Throwable iter) {
                        row = iter;
                        throw iter;
                    }
                    finally {
                        if (orderGroup == null) continue;
                        if (row != null) {
                            try {
                                orderGroup.close();
                            }
                            catch (Throwable time) {
                                ((Throwable)row).addSuppressed(time);
                            }
                            continue;
                        }
                        orderGroup.close();
                    }
                }
                rowSet.setTombstonedExisting();
            }
            for (TemporalRow temporalRow : rowSet) {
                PartitionUpdate update;
                DecoratedKey value;
                DeletionTime deletionTime = temporalRow.deletionTime(partition);
                if (deletionTime.isLive() || (value = this.viewPartitionKey(temporalRow, resolver)) == null || (update = this.createTombstone(temporalRow, value, deletionTime, resolver, temporalRow.nowInSec)) == null) continue;
                mutations.add(new Mutation(update));
            }
        }
        return !mutations.isEmpty() ? mutations : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readLocalRows(TemporalRow.Set rowSet) {
        AbstractReadCommandBuilder.SinglePartitionSliceBuilder builder = new AbstractReadCommandBuilder.SinglePartitionSliceBuilder(this.baseCfs, rowSet.dk);
        for (TemporalRow temporalRow : rowSet) {
            builder.addSlice(temporalRow.baseSlice());
        }
        QueryPager pager = builder.build().getPager(null);
        block27: while (!pager.isExhausted()) {
            ReadOrderGroup orderGroup = pager.startOrderGroup();
            Throwable throwable = null;
            try {
                PartitionIterator iter = pager.fetchPageInternal(128, orderGroup);
                Throwable throwable2 = null;
                try {
                    while (true) {
                        RowIterator rows;
                        block33: {
                            if (!iter.hasNext()) continue block27;
                            rows = (RowIterator)iter.next();
                            Throwable throwable3 = null;
                            try {
                                while (rows.hasNext()) {
                                    rowSet.addRow((Row)rows.next(), false);
                                }
                                if (rows == null) continue;
                                if (throwable3 == null) break block33;
                            }
                            catch (Throwable throwable4) {
                                try {
                                    throwable3 = throwable4;
                                    throw throwable4;
                                }
                                catch (Throwable throwable5) {
                                    if (rows == null) throw throwable5;
                                    if (throwable3 != null) {
                                        try {
                                            rows.close();
                                            throw throwable5;
                                        }
                                        catch (Throwable throwable6) {
                                            throwable3.addSuppressed(throwable6);
                                            throw throwable5;
                                        }
                                    }
                                    rows.close();
                                    throw throwable5;
                                }
                            }
                            try {
                                rows.close();
                            }
                            catch (Throwable throwable7) {
                                throwable3.addSuppressed(throwable7);
                            }
                            continue;
                        }
                        rows.close();
                    }
                }
                catch (Throwable throwable8) {
                    throwable2 = throwable8;
                    throw throwable8;
                }
                finally {
                    if (iter == null) continue;
                    if (throwable2 != null) {
                        try {
                            iter.close();
                        }
                        catch (Throwable throwable9) {
                            throwable2.addSuppressed(throwable9);
                        }
                        continue;
                    }
                    iter.close();
                }
            }
            catch (Throwable throwable10) {
                throwable = throwable10;
                throw throwable10;
            }
            finally {
                if (orderGroup == null) continue;
                if (throwable != null) {
                    try {
                        orderGroup.close();
                    }
                    catch (Throwable throwable11) {
                        throwable.addSuppressed(throwable11);
                    }
                    continue;
                }
                orderGroup.close();
            }
        }
    }

    private TemporalRow.Set separateRows(AbstractBTreePartition partition, Set<ColumnIdentifier> viewPrimaryKeyCols) {
        TemporalRow.Set rowSet = new TemporalRow.Set(this.baseCfs, viewPrimaryKeyCols, partition.partitionKey().getKey());
        for (Row row : partition) {
            rowSet.addRow(row, true);
        }
        return rowSet;
    }

    public TemporalRow.Set getTemporalRowSet(AbstractBTreePartition partition, TemporalRow.Set existing, boolean isBuilding) {
        if (!this.updateAffectsView(partition)) {
            return null;
        }
        HashSet<ColumnIdentifier> columns = new HashSet<ColumnIdentifier>(this.columns.primaryKeyDefs.size());
        for (ColumnDefinition def : this.columns.primaryKeyDefs) {
            columns.add(def.name);
        }
        TemporalRow.Set rowSet = null;
        if (existing == null) {
            rowSet = this.separateRows(partition, columns);
            if (!isBuilding) {
                this.readLocalRows(rowSet);
            }
        } else {
            rowSet = existing.withNewViewPrimaryKey(columns);
        }
        return rowSet;
    }

    public Collection<Mutation> createMutations(AbstractBTreePartition partition, TemporalRow.Set rowSet, boolean isBuilding) {
        Collection<Mutation> deletion;
        if (!this.updateAffectsView(partition)) {
            return null;
        }
        LinkedList<Mutation> mutations = null;
        for (TemporalRow temporalRow : rowSet) {
            PartitionUpdate insert;
            PartitionUpdate partitionTombstone;
            if (!isBuilding && (partitionTombstone = this.createRangeTombstoneForRow(temporalRow)) != null) {
                if (mutations == null) {
                    mutations = new LinkedList<Mutation>();
                }
                mutations.add(new Mutation(partitionTombstone));
            }
            if ((insert = this.createUpdatesForInserts(temporalRow)) == null) continue;
            if (mutations == null) {
                mutations = new LinkedList();
            }
            mutations.add(new Mutation(insert));
        }
        if (!isBuilding && (deletion = this.createForDeletionInfo(rowSet, partition)) != null && !deletion.isEmpty()) {
            if (mutations == null) {
                mutations = new LinkedList();
            }
            mutations.addAll(deletion);
        }
        return mutations;
    }

    public synchronized void build() {
        if (this.builder != null) {
            this.builder.stop();
            this.builder = null;
        }
        this.builder = new MaterializedViewBuilder(this.baseCfs, this);
        CompactionManager.instance.submitMaterializedViewBuilder(this.builder);
    }

    @Nullable
    public static CFMetaData findBaseTable(String keyspace, String view) {
        KeyspaceMetadata ksm = Schema.instance.getKSMetaData(keyspace);
        if (ksm == null) {
            return null;
        }
        for (CFMetaData cfm : ksm.tables) {
            if (!cfm.getMaterializedViews().get(view).isPresent()) continue;
            return cfm;
        }
        return null;
    }

    public static CFMetaData getCFMetaData(MaterializedViewDefinition definition, CFMetaData baseCf, CFProperties properties) {
        CFMetaData.Builder viewBuilder = CFMetaData.Builder.createView(baseCf.ksName, definition.viewName);
        ColumnDefinition nonPkTarget = null;
        for (ColumnIdentifier columnIdentifier : definition.partitionColumns) {
            ColumnDefinition target = baseCf.getColumnDefinition(columnIdentifier);
            if (!target.isPartitionKey()) {
                nonPkTarget = target;
            }
            viewBuilder.addPartitionKey(target.name, properties.getReversableType(columnIdentifier, target.type));
        }
        ArrayList<ColumnDefinition> included = new ArrayList<ColumnDefinition>();
        for (ColumnIdentifier identifier : definition.included) {
            ColumnDefinition cfDef = baseCf.getColumnDefinition(identifier);
            assert (cfDef != null);
            included.add(cfDef);
        }
        boolean bl = included.isEmpty();
        for (ColumnIdentifier ident : definition.clusteringColumns) {
            ColumnDefinition column = baseCf.getColumnDefinition(ident);
            viewBuilder.addClusteringColumn(ident, properties.getReversableType(ident, column.type));
        }
        for (ColumnDefinition column : baseCf.partitionColumns().regulars) {
            if (column == nonPkTarget || !bl && !included.contains(column)) continue;
            viewBuilder.addRegularColumn(column.name, column.type);
        }
        for (ColumnDefinition column : Iterables.concat(baseCf.partitionKeyColumns(), baseCf.clusteringColumns())) {
            if (definition.partitionColumns.contains(column.name) || definition.clusteringColumns.contains(column.name) || !bl && !included.contains(column)) continue;
            viewBuilder.addRegularColumn(column.name, column.type);
        }
        return viewBuilder.build().params(properties.properties.asNewTableParams());
    }

    private static class MVColumns {
        public final List<ColumnDefinition> partitionDefs;
        public final List<ColumnDefinition> primaryKeyDefs;
        public final List<ColumnDefinition> baseComplexColumns;

        private MVColumns(List<ColumnDefinition> partitionDefs, List<ColumnDefinition> primaryKeyDefs, List<ColumnDefinition> baseComplexColumns) {
            this.partitionDefs = partitionDefs;
            this.primaryKeyDefs = primaryKeyDefs;
            this.baseComplexColumns = baseComplexColumns;
        }
    }
}

