/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.collect.Iterables;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Memtable;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.filter.ClusteringIndexSliceFilter;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.lifecycle.SSTableSet;
import org.apache.cassandra.db.lifecycle.View;
import org.apache.cassandra.db.partitions.Partition;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.metrics.TableMetrics;
import org.apache.cassandra.thrift.ThriftResultsMerger;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.memory.HeapAllocator;

public class SinglePartitionSliceCommand
extends SinglePartitionReadCommand<ClusteringIndexSliceFilter> {
    private int oldestUnrepairedTombstone = Integer.MAX_VALUE;

    public SinglePartitionSliceCommand(boolean isDigest, int digestVersion, boolean isForThrift, CFMetaData metadata, int nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, DecoratedKey partitionKey, ClusteringIndexSliceFilter clusteringIndexFilter) {
        super(isDigest, digestVersion, isForThrift, metadata, nowInSec, columnFilter, rowFilter, limits, partitionKey, clusteringIndexFilter);
    }

    public SinglePartitionSliceCommand(CFMetaData metadata, int nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, DecoratedKey partitionKey, ClusteringIndexSliceFilter clusteringIndexFilter) {
        this(false, 0, false, metadata, nowInSec, columnFilter, rowFilter, limits, partitionKey, clusteringIndexFilter);
    }

    public static SinglePartitionReadCommand create(CFMetaData metadata, int nowInSec, DecoratedKey key, Slice slice) {
        return SinglePartitionSliceCommand.create(metadata, nowInSec, key, Slices.with(metadata.comparator, slice));
    }

    public static SinglePartitionReadCommand create(CFMetaData metadata, int nowInSec, DecoratedKey key, Slices slices) {
        ClusteringIndexSliceFilter filter = new ClusteringIndexSliceFilter(slices, false);
        return new SinglePartitionSliceCommand(metadata, nowInSec, ColumnFilter.all(metadata), RowFilter.NONE, DataLimits.NONE, key, filter);
    }

    public static SinglePartitionReadCommand create(CFMetaData metadata, int nowInSec, ByteBuffer key, Slices slices) {
        return SinglePartitionSliceCommand.create(metadata, nowInSec, metadata.decorateKey(key), slices);
    }

    @Override
    public SinglePartitionSliceCommand copy() {
        return new SinglePartitionSliceCommand(this.isDigestQuery(), this.digestVersion(), this.isForThrift(), this.metadata(), this.nowInSec(), this.columnFilter(), this.rowFilter(), this.limits(), this.partitionKey(), (ClusteringIndexSliceFilter)this.clusteringIndexFilter());
    }

    @Override
    protected int oldestUnrepairedTombstone() {
        return this.oldestUnrepairedTombstone;
    }

    @Override
    protected UnfilteredRowIterator queryMemtableAndDiskInternal(ColumnFamilyStore cfs, boolean copyOnHeap) {
        Tracing.trace("Acquiring sstable references");
        ColumnFamilyStore.ViewFragment view = cfs.select(View.select(SSTableSet.LIVE, this.partitionKey()));
        ArrayList<UnfilteredRowIterator> iterators = new ArrayList<UnfilteredRowIterator>(Iterables.size(view.memtables) + view.sstables.size());
        ClusteringIndexSliceFilter filter = (ClusteringIndexSliceFilter)this.clusteringIndexFilter();
        try {
            for (Memtable memtable : view.memtables) {
                Partition partition = memtable.getPartition(this.partitionKey());
                if (partition == null) continue;
                UnfilteredRowIterator iter = filter.getUnfilteredRowIterator(this.columnFilter(), partition);
                UnfilteredRowIterator maybeCopied = copyOnHeap ? UnfilteredRowIterators.cloningIterator(iter, HeapAllocator.instance) : iter;
                this.oldestUnrepairedTombstone = Math.min(this.oldestUnrepairedTombstone, partition.stats().minLocalDeletionTime);
                iterators.add(this.isForThrift() ? ThriftResultsMerger.maybeWrap(maybeCopied, this.nowInSec()) : maybeCopied);
            }
            int sstablesIterated = 0;
            Collections.sort(view.sstables, SSTableReader.maxTimestampComparator);
            ArrayList<SSTableReader> skippedSSTables = null;
            long mostRecentPartitionTombstone = Long.MIN_VALUE;
            long minTimestamp = Long.MAX_VALUE;
            int nonIntersectingSSTables = 0;
            for (SSTableReader sSTableReader : view.sstables) {
                minTimestamp = Math.min(minTimestamp, sSTableReader.getMinTimestamp());
                if (sSTableReader.getMaxTimestamp() < mostRecentPartitionTombstone) break;
                if (!filter.shouldInclude(sSTableReader)) {
                    ++nonIntersectingSSTables;
                    if (sSTableReader.getSSTableMetadata().maxLocalDeletionTime == Integer.MAX_VALUE) continue;
                    if (skippedSSTables == null) {
                        skippedSSTables = new ArrayList<SSTableReader>();
                    }
                    skippedSSTables.add(sSTableReader);
                    continue;
                }
                sSTableReader.incrementReadCount();
                UnfilteredRowIterator unfilteredRowIterator = filter.filter(sSTableReader.iterator(this.partitionKey(), this.columnFilter(), filter.isReversed(), this.isForThrift()));
                if (!sSTableReader.isRepaired()) {
                    this.oldestUnrepairedTombstone = Math.min(this.oldestUnrepairedTombstone, sSTableReader.getMinLocalDeletionTime());
                }
                iterators.add(this.isForThrift() ? ThriftResultsMerger.maybeWrap(unfilteredRowIterator, this.nowInSec()) : unfilteredRowIterator);
                mostRecentPartitionTombstone = Math.max(mostRecentPartitionTombstone, unfilteredRowIterator.partitionLevelDeletion().markedForDeleteAt());
                ++sstablesIterated;
            }
            int includedDueToTombstones = 0;
            if (skippedSSTables != null) {
                for (SSTableReader sSTableReader : skippedSSTables) {
                    if (sSTableReader.getMaxTimestamp() <= minTimestamp) continue;
                    sSTableReader.incrementReadCount();
                    UnfilteredRowIterator iter = filter.filter(sSTableReader.iterator(this.partitionKey(), this.columnFilter(), filter.isReversed(), this.isForThrift()));
                    if (iter.partitionLevelDeletion().markedForDeleteAt() > minTimestamp) {
                        iterators.add(iter);
                        if (!sSTableReader.isRepaired()) {
                            this.oldestUnrepairedTombstone = Math.min(this.oldestUnrepairedTombstone, sSTableReader.getMinLocalDeletionTime());
                        }
                        ++includedDueToTombstones;
                        ++sstablesIterated;
                        continue;
                    }
                    iter.close();
                }
            }
            if (Tracing.isTracing()) {
                Tracing.trace("Skipped {}/{} non-slice-intersecting sstables, included {} due to tombstones", nonIntersectingSSTables, view.sstables.size(), includedDueToTombstones);
            }
            cfs.metric.updateSSTableIterated(sstablesIterated);
            if (iterators.isEmpty()) {
                return UnfilteredRowIterators.emptyIterator(cfs.metadata, this.partitionKey(), filter.isReversed());
            }
            Tracing.trace("Merging data from memtables and {} sstables", (Object)sstablesIterated);
            UnfilteredRowIterator unfilteredRowIterator = UnfilteredRowIterators.merge(iterators, this.nowInSec());
            if (!unfilteredRowIterator.isEmpty()) {
                DecoratedKey decoratedKey = unfilteredRowIterator.partitionKey();
                cfs.metric.samplers.get((Object)TableMetrics.Sampler.READS).addSample(decoratedKey.getKey(), decoratedKey.hashCode(), 1);
            }
            return unfilteredRowIterator;
        }
        catch (Error | RuntimeException e) {
            try {
                FBUtilities.closeAll(iterators);
            }
            catch (Exception suppressed) {
                e.addSuppressed(suppressed);
            }
            throw e;
        }
    }
}

