/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.UTName;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.transport.Event;

public class DropTypeStatement
extends SchemaAlteringStatement {
    private final UTName name;
    private final boolean ifExists;

    public DropTypeStatement(UTName name, boolean ifExists) {
        this.name = name;
        this.ifExists = ifExists;
    }

    @Override
    public void prepareKeyspace(ClientState state) throws InvalidRequestException {
        if (!this.name.hasKeyspace()) {
            this.name.setKeyspace(state.getKeyspace());
        }
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        state.hasKeyspaceAccess(this.keyspace(), Permission.DROP);
    }

    @Override
    public void validate(ClientState state) throws RequestValidationException {
        KeyspaceMetadata ksm = Schema.instance.getKSMetaData(this.name.getKeyspace());
        if (ksm == null) {
            throw new InvalidRequestException(String.format("Cannot drop type in unknown keyspace %s", this.name.getKeyspace()));
        }
        if (!ksm.types.get(this.name.getUserTypeName()).isPresent()) {
            if (this.ifExists) {
                return;
            }
            throw new InvalidRequestException(String.format("No user type named %s exists.", this.name));
        }
        for (Function function : ksm.functions) {
            if (this.isUsedBy(function.returnType())) {
                throw new InvalidRequestException(String.format("Cannot drop user type %s as it is still used by function %s", this.name, function));
            }
            for (AbstractType<?> argType : function.argTypes()) {
                if (!this.isUsedBy(argType)) continue;
                throw new InvalidRequestException(String.format("Cannot drop user type %s as it is still used by function %s", this.name, function));
            }
        }
        for (UserType ut : ksm.types) {
            if (ut.name.equals(this.name.getUserTypeName()) || !this.isUsedBy(ut)) continue;
            throw new InvalidRequestException(String.format("Cannot drop user type %s as it is still used by user type %s", this.name, ut.asCQL3Type()));
        }
        for (CFMetaData cfm : ksm.tables) {
            for (ColumnDefinition def : cfm.allColumns()) {
                if (!this.isUsedBy(def.type)) continue;
                throw new InvalidRequestException(String.format("Cannot drop user type %s as it is still used by table %s.%s", this.name, cfm.ksName, cfm.cfName));
            }
        }
    }

    private boolean isUsedBy(AbstractType<?> toCheck) throws RequestValidationException {
        if (toCheck instanceof UserType) {
            UserType ut = (UserType)toCheck;
            if (this.name.getKeyspace().equals(ut.keyspace) && this.name.getUserTypeName().equals(ut.name)) {
                return true;
            }
            for (AbstractType<?> subtype : ut.fieldTypes()) {
                if (!this.isUsedBy(subtype)) continue;
                return true;
            }
        } else if (toCheck instanceof CompositeType) {
            CompositeType ct = (CompositeType)toCheck;
            for (AbstractType<?> subtype : ct.types) {
                if (!this.isUsedBy(subtype)) continue;
                return true;
            }
        } else if (toCheck instanceof CollectionType) {
            if (toCheck instanceof ListType) {
                return this.isUsedBy(((ListType)toCheck).getElementsType());
            }
            if (toCheck instanceof SetType) {
                return this.isUsedBy(((SetType)toCheck).getElementsType());
            }
            return this.isUsedBy(((MapType)toCheck).getKeysType()) || this.isUsedBy(((MapType)toCheck).getValuesType());
        }
        return false;
    }

    @Override
    public Event.SchemaChange changeEvent() {
        return new Event.SchemaChange(Event.SchemaChange.Change.DROPPED, Event.SchemaChange.Target.TYPE, this.keyspace(), this.name.getStringTypeName());
    }

    @Override
    public String keyspace() {
        return this.name.getKeyspace();
    }

    @Override
    public boolean announceMigration(boolean isLocalOnly) throws InvalidRequestException, ConfigurationException {
        KeyspaceMetadata ksm = Schema.instance.getKSMetaData(this.name.getKeyspace());
        assert (ksm != null);
        UserType toDrop = ksm.types.getNullable(this.name.getUserTypeName());
        if (toDrop == null) {
            return false;
        }
        MigrationManager.announceTypeDrop(toDrop, isLocalOnly);
        return true;
    }
}

