/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.cql3.ColumnIdentifier;

public class MaterializedViewDefinition {
    public final String baseCfName;
    public final String viewName;
    public final List<ColumnIdentifier> partitionColumns;
    public final List<ColumnIdentifier> clusteringColumns;
    public final Set<ColumnIdentifier> included;
    public final boolean includeAll;

    public MaterializedViewDefinition(MaterializedViewDefinition def) {
        this(def.baseCfName, def.viewName, new ArrayList<ColumnIdentifier>(def.partitionColumns), new ArrayList<ColumnIdentifier>(def.clusteringColumns), new HashSet<ColumnIdentifier>(def.included));
    }

    public MaterializedViewDefinition(String baseCfName, String viewName, List<ColumnIdentifier> partitionColumns, List<ColumnIdentifier> clusteringColumns, Set<ColumnIdentifier> included) {
        assert (partitionColumns != null && !partitionColumns.isEmpty());
        assert (included != null);
        this.baseCfName = baseCfName;
        this.viewName = viewName;
        this.partitionColumns = partitionColumns;
        this.clusteringColumns = clusteringColumns;
        this.includeAll = included.isEmpty();
        this.included = included;
    }

    public boolean includes(ColumnIdentifier column) {
        return this.includeAll || this.partitionColumns.contains(column) || this.clusteringColumns.contains(column) || this.included.contains(column);
    }

    public void renameColumn(ColumnIdentifier from, ColumnIdentifier to) {
        int clusteringIndex;
        int partitionIndex;
        if (!this.includeAll && this.included.contains(from)) {
            this.included.remove(from);
            this.included.add(to);
        }
        if ((partitionIndex = this.partitionColumns.indexOf(from)) >= 0) {
            this.partitionColumns.set(partitionIndex, to);
        }
        if ((clusteringIndex = this.clusteringColumns.indexOf(from)) >= 0) {
            this.clusteringColumns.set(clusteringIndex, to);
        }
    }
}

