/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.Optional;
import org.apache.cassandra.config.MaterializedViewDefinition;

public final class MaterializedViews
implements Iterable<MaterializedViewDefinition> {
    private final ImmutableMap<String, MaterializedViewDefinition> materializedViews;

    private MaterializedViews(Builder builder) {
        this.materializedViews = builder.materializedViews.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static MaterializedViews none() {
        return MaterializedViews.builder().build();
    }

    @Override
    public Iterator<MaterializedViewDefinition> iterator() {
        return this.materializedViews.values().iterator();
    }

    public int size() {
        return this.materializedViews.size();
    }

    public boolean isEmpty() {
        return this.materializedViews.isEmpty();
    }

    public Optional<MaterializedViewDefinition> get(String name) {
        return Optional.ofNullable(this.materializedViews.get((Object)name));
    }

    public MaterializedViews with(MaterializedViewDefinition materializedView) {
        if (this.get(materializedView.viewName).isPresent()) {
            throw new IllegalStateException(String.format("Materialized View %s already exists", materializedView.viewName));
        }
        return MaterializedViews.builder().add(this).add(materializedView).build();
    }

    public MaterializedViews without(String name) {
        MaterializedViewDefinition materializedView = this.get(name).orElseThrow(() -> new IllegalStateException(String.format("Materialized View %s doesn't exists", name)));
        return MaterializedViews.builder().add(Iterables.filter((Iterable)this, v -> v != materializedView)).build();
    }

    public MaterializedViews replace(MaterializedViewDefinition materializedView) {
        return this.without(materializedView.viewName).with(materializedView);
    }

    public boolean equals(Object o) {
        return this == o || o instanceof MaterializedViews && this.materializedViews.equals(((MaterializedViews)o).materializedViews);
    }

    public int hashCode() {
        return this.materializedViews.hashCode();
    }

    public String toString() {
        return this.materializedViews.values().toString();
    }

    public static final class Builder {
        final ImmutableMap.Builder<String, MaterializedViewDefinition> materializedViews = new ImmutableMap.Builder();

        private Builder() {
        }

        public MaterializedViews build() {
            return new MaterializedViews(this);
        }

        public Builder add(MaterializedViewDefinition materializedView) {
            this.materializedViews.put((Object)materializedView.viewName, (Object)materializedView);
            return this;
        }

        public Builder add(Iterable<MaterializedViewDefinition> materializedViews) {
            materializedViews.forEach(this::add);
            return this;
        }
    }
}

