/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.schema.KeyspaceMetadata;

public class Indexes
implements Iterable<IndexMetadata> {
    private final ImmutableMap<String, IndexMetadata> indexes;
    private final ImmutableMultimap<ColumnIdentifier, IndexMetadata> indexesByColumn;

    private Indexes(Builder builder) {
        this.indexes = builder.indexes.build();
        this.indexesByColumn = builder.indexesByColumn.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Indexes none() {
        return Indexes.builder().build();
    }

    @Override
    public Iterator<IndexMetadata> iterator() {
        return this.indexes.values().iterator();
    }

    public int size() {
        return this.indexes.size();
    }

    public boolean isEmpty() {
        return this.indexes.isEmpty();
    }

    public Optional<IndexMetadata> get(String name) {
        return this.indexes.values().stream().filter(def -> def.name.equals(name)).findFirst();
    }

    public boolean has(String name) {
        return this.get(name).isPresent();
    }

    public Collection<IndexMetadata> get(ColumnDefinition column) {
        return this.indexesByColumn.get((Object)column.name);
    }

    public boolean hasIndexFor(ColumnDefinition column) {
        return !this.indexesByColumn.get((Object)column.name).isEmpty();
    }

    public Indexes with(IndexMetadata index) {
        if (this.get(index.name).isPresent()) {
            throw new IllegalStateException(String.format("Index %s already exists", index.name));
        }
        return Indexes.builder().add(this).add(index).build();
    }

    public Indexes without(String name) {
        IndexMetadata index = this.get(name).orElseThrow(() -> new IllegalStateException(String.format("Index %s doesn't exist", name)));
        return Indexes.builder().add(Iterables.filter((Iterable)this, v -> v != index)).build();
    }

    public Indexes replace(IndexMetadata index) {
        return this.without(index.name).with(index);
    }

    public boolean equals(Object o) {
        return this == o || o instanceof Indexes && this.indexes.equals(((Indexes)o).indexes);
    }

    public int hashCode() {
        return this.indexes.hashCode();
    }

    public String toString() {
        return this.indexes.values().toString();
    }

    public static String getAvailableIndexName(String ksName, String cfName, ColumnIdentifier columnName) {
        String baseName;
        KeyspaceMetadata ksm = Schema.instance.getKSMetaData(ksName);
        Set<Object> existingNames = ksm == null ? new HashSet() : ksm.existingIndexNames(null);
        String acceptedName = baseName = IndexMetadata.getDefaultIndexName(cfName, columnName);
        int i = 0;
        while (existingNames.contains(acceptedName)) {
            acceptedName = baseName + '_' + ++i;
        }
        return acceptedName;
    }

    public static final class Builder {
        final ImmutableMap.Builder<String, IndexMetadata> indexes = new ImmutableMap.Builder();
        final ImmutableMultimap.Builder<ColumnIdentifier, IndexMetadata> indexesByColumn = new ImmutableMultimap.Builder();

        private Builder() {
        }

        public Indexes build() {
            return new Indexes(this);
        }

        public Builder add(IndexMetadata index) {
            this.indexes.put((Object)index.name, (Object)index);
            if (index.isColumnIndex()) {
                for (ColumnIdentifier target : index.columns) {
                    this.indexesByColumn.put((Object)target, (Object)index);
                }
            }
            return this;
        }

        public Builder add(Iterable<IndexMetadata> indexes) {
            indexes.forEach(this::add);
            return this;
        }
    }
}

