/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import com.google.common.util.concurrent.RateLimiter;
import org.apache.cassandra.io.compress.BufferType;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.io.util.RandomAccessReader;

public class ThrottledReader
extends RandomAccessReader {
    private final RateLimiter limiter;

    protected ThrottledReader(ChannelProxy channel, int bufferSize, long overrideLength, RateLimiter limiter) {
        super(channel, bufferSize, overrideLength, BufferType.OFF_HEAP);
        this.limiter = limiter;
    }

    @Override
    protected void reBuffer() {
        this.limiter.acquire(this.buffer.capacity());
        super.reBuffer();
    }

    public static ThrottledReader open(ChannelProxy channel, int bufferSize, long overrideLength, RateLimiter limiter) {
        return new ThrottledReader(channel, bufferSize, overrideLength, limiter);
    }
}

