/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.EOFException;
import java.io.File;
import java.nio.ByteBuffer;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.compress.BufferType;
import org.apache.cassandra.io.util.AbstractDataInput;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.FileMark;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.memory.BufferPool;

public class RandomAccessReader
extends AbstractDataInput
implements FileDataInput {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    protected final ChannelProxy channel;
    protected ByteBuffer buffer;
    protected long bufferOffset;
    protected long markedPointer;
    private final long fileLength;

    protected RandomAccessReader(ChannelProxy channel, int bufferSize, long overrideLength, BufferType bufferType) {
        this.channel = channel;
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("bufferSize must be positive");
        }
        this.fileLength = overrideLength <= 0L ? channel.size() : overrideLength;
        this.buffer = this.allocateBuffer(this.getBufferSize(bufferSize), bufferType);
        this.buffer.limit(0);
    }

    protected int getBufferSize(int size) {
        if ((size & 0xFFFFF000) != size) {
            size = size + 4095 & 0xFFFFF000;
        }
        return size;
    }

    protected ByteBuffer allocateBuffer(int size, BufferType bufferType) {
        return BufferPool.get(size, bufferType);
    }

    public static RandomAccessReader open(File file) {
        return new RandomAccessReaderWithChannel(file);
    }

    public static RandomAccessReader open(ChannelProxy channel) {
        return RandomAccessReader.open(channel, 4096, -1L);
    }

    public static RandomAccessReader open(ChannelProxy channel, int bufferSize, long overrideSize) {
        return new RandomAccessReader(channel, bufferSize, overrideSize, BufferType.OFF_HEAP);
    }

    public ChannelProxy getChannel() {
        return this.channel;
    }

    protected void reBuffer() {
        int n;
        this.bufferOffset += (long)this.buffer.position();
        this.buffer.clear();
        assert (this.bufferOffset < this.fileLength);
        long position = this.bufferOffset;
        long limit = this.bufferOffset;
        long pageAligedPos = position & 0xFFFFFFFFFFFFF000L;
        long upperLimit = Math.min(this.fileLength, pageAligedPos + (long)this.buffer.capacity());
        this.buffer.limit((int)(upperLimit - position));
        while (this.buffer.hasRemaining() && limit < upperLimit && (n = this.channel.read(this.buffer, position)) >= 0) {
            position += (long)n;
            limit = this.bufferOffset + (long)this.buffer.position();
        }
        if (limit > this.fileLength) {
            this.buffer.position((int)(this.fileLength - this.bufferOffset));
        }
        this.buffer.flip();
    }

    @Override
    public long getFilePointer() {
        return this.current();
    }

    protected long current() {
        return this.bufferOffset + (long)(this.buffer == null ? 0 : this.buffer.position());
    }

    @Override
    public String getPath() {
        return this.channel.filePath();
    }

    public int getTotalBufferSize() {
        ByteBuffer ref = this.buffer;
        return ref != null ? ref.capacity() : 0;
    }

    @Override
    public void reset() {
        this.seek(this.markedPointer);
    }

    public long bytesPastMark() {
        long bytes = this.current() - this.markedPointer;
        assert (bytes >= 0L);
        return bytes;
    }

    @Override
    public FileMark mark() {
        this.markedPointer = this.current();
        return new BufferedRandomAccessFileMark(this.markedPointer);
    }

    @Override
    public void reset(FileMark mark) {
        assert (mark instanceof BufferedRandomAccessFileMark);
        this.seek(((BufferedRandomAccessFileMark)mark).pointer);
    }

    @Override
    public long bytesPastMark(FileMark mark) {
        assert (mark instanceof BufferedRandomAccessFileMark);
        long bytes = this.current() - ((BufferedRandomAccessFileMark)mark).pointer;
        assert (bytes >= 0L);
        return bytes;
    }

    @Override
    public boolean isEOF() {
        return this.getFilePointer() == this.length();
    }

    @Override
    public long bytesRemaining() {
        return this.length() - this.getFilePointer();
    }

    @Override
    public void close() {
        if (this.buffer == null) {
            return;
        }
        this.bufferOffset += (long)this.buffer.position();
        BufferPool.put(this.buffer);
        this.buffer = null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + "filePath='" + this.channel + "')";
    }

    @Override
    public void seek(long newPosition) {
        if (newPosition < 0L) {
            throw new IllegalArgumentException("new position should not be negative");
        }
        if (this.buffer == null) {
            throw new IllegalStateException("Attempted to seek in a closed RAR");
        }
        if (newPosition >= this.length()) {
            if (newPosition > this.length()) {
                throw new IllegalArgumentException(String.format("Unable to seek to position %d in %s (%d bytes) in read-only mode", newPosition, this.getPath(), this.length()));
            }
            this.buffer.limit(0);
            this.bufferOffset = newPosition;
            return;
        }
        if (newPosition >= this.bufferOffset && newPosition < this.bufferOffset + (long)this.buffer.limit()) {
            this.buffer.position((int)(newPosition - this.bufferOffset));
            return;
        }
        this.bufferOffset = newPosition;
        this.buffer.clear();
        this.reBuffer();
        assert (this.current() == newPosition);
    }

    @Override
    public int read() {
        if (this.buffer == null) {
            throw new AssertionError((Object)"Attempted to read from closed RAR");
        }
        if (this.isEOF()) {
            return -1;
        }
        if (!this.buffer.hasRemaining()) {
            this.reBuffer();
        }
        return this.buffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] buffer) {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(byte[] buff, int offset, int length) {
        if (this.buffer == null) {
            throw new IllegalStateException("Attempted to read from closed RAR");
        }
        if (length == 0) {
            return 0;
        }
        if (this.isEOF()) {
            return -1;
        }
        if (!this.buffer.hasRemaining()) {
            this.reBuffer();
        }
        int toCopy = Math.min(length, this.buffer.remaining());
        this.buffer.get(buff, offset, toCopy);
        return toCopy;
    }

    @Override
    public ByteBuffer readBytes(int length) throws EOFException {
        assert (length >= 0) : "buffer length should not be negative: " + length;
        if (this.buffer == null) {
            throw new IllegalStateException("Attempted to read from closed RAR");
        }
        try {
            ByteBuffer result = ByteBuffer.allocate(length);
            while (result.hasRemaining()) {
                if (this.isEOF()) {
                    throw new EOFException();
                }
                if (!this.buffer.hasRemaining()) {
                    this.reBuffer();
                }
                ByteBufferUtil.put(this.buffer, result);
            }
            result.flip();
            return result;
        }
        catch (EOFException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FSReadError((Throwable)e, this.channel.toString());
        }
    }

    public long length() {
        return this.fileLength;
    }

    @Override
    public long getPosition() {
        return this.bufferOffset + (long)(this.buffer == null ? 0 : this.buffer.position());
    }

    @Override
    public long getPositionLimit() {
        return this.length();
    }

    protected static class BufferedRandomAccessFileMark
    implements FileMark {
        final long pointer;

        public BufferedRandomAccessFileMark(long pointer) {
            this.pointer = pointer;
        }
    }

    private static class RandomAccessReaderWithChannel
    extends RandomAccessReader {
        RandomAccessReaderWithChannel(File file) {
            super(new ChannelProxy(file), 4096, -1L, BufferType.OFF_HEAP);
        }

        @Override
        public void close() {
            try {
                super.close();
            }
            finally {
                this.channel.close();
            }
        }
    }
}

