/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.utils.AbstractIterator;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.CloseableIterator;

public class KeyIterator
extends AbstractIterator<DecoratedKey>
implements CloseableIterator<DecoratedKey> {
    private final In in;
    private final IPartitioner partitioner;

    public KeyIterator(Descriptor desc, CFMetaData metadata) {
        this.in = new In(new File(desc.filenameFor(Component.PRIMARY_INDEX)));
        this.partitioner = metadata.partitioner;
    }

    @Override
    protected DecoratedKey computeNext() {
        try {
            if (this.in.isEOF()) {
                return (DecoratedKey)this.endOfData();
            }
            DecoratedKey key = this.partitioner.decorateKey(ByteBufferUtil.readWithShortLength(this.in.get()));
            RowIndexEntry.Serializer.skip(this.in.get());
            return key;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        this.in.close();
    }

    public long getBytesRead() {
        return this.in.getFilePointer();
    }

    public long getTotalBytes() {
        return this.in.length();
    }

    private static final class In {
        private final File path;
        private RandomAccessReader in;

        public In(File path) {
            this.path = path;
        }

        private void maybeInit() {
            if (this.in == null) {
                this.in = RandomAccessReader.open(this.path);
            }
        }

        public DataInput get() {
            this.maybeInit();
            return this.in;
        }

        public boolean isEOF() {
            this.maybeInit();
            return this.in.isEOF();
        }

        public void close() {
            if (this.in != null) {
                this.in.close();
            }
        }

        public long getFilePointer() {
            this.maybeInit();
            return this.in.getFilePointer();
        }

        public long length() {
            this.maybeInit();
            return this.in.length();
        }
    }
}

