/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import com.google.common.collect.AbstractIterator;
import java.security.MessageDigest;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.Columns;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionPurger;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.PartitionColumns;
import org.apache.cassandra.db.rows.AbstractUnfilteredRowIterator;
import org.apache.cassandra.db.rows.AlteringUnfilteredRowIterator;
import org.apache.cassandra.db.rows.BTreeRow;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.IMergeIterator;
import org.apache.cassandra.utils.MergeIterator;
import org.apache.cassandra.utils.memory.AbstractAllocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UnfilteredRowIterators {
    private static final Logger logger = LoggerFactory.getLogger(UnfilteredRowIterators.class);

    private UnfilteredRowIterators() {
    }

    public static RowIterator filter(UnfilteredRowIterator iter, int nowInSec) {
        return new FilteringIterator(iter, nowInSec);
    }

    public static UnfilteredRowIterator merge(List<UnfilteredRowIterator> iterators, int nowInSec) {
        assert (!iterators.isEmpty());
        if (iterators.size() == 1) {
            return iterators.get(0);
        }
        return UnfilteredRowMergeIterator.create(iterators, nowInSec, null);
    }

    public static UnfilteredRowIterator merge(List<UnfilteredRowIterator> iterators, int nowInSec, MergeListener mergeListener) {
        return UnfilteredRowMergeIterator.create(iterators, nowInSec, mergeListener);
    }

    public static UnfilteredRowIterator emptyIterator(CFMetaData cfm, DecoratedKey partitionKey, boolean isReverseOrder) {
        return UnfilteredRowIterators.noRowsIterator(cfm, partitionKey, Rows.EMPTY_STATIC_ROW, DeletionTime.LIVE, isReverseOrder);
    }

    public static UnfilteredRowIterator noRowsIterator(final CFMetaData cfm, final DecoratedKey partitionKey, final Row staticRow, final DeletionTime partitionDeletion, final boolean isReverseOrder) {
        return new UnfilteredRowIterator(){

            @Override
            public CFMetaData metadata() {
                return cfm;
            }

            @Override
            public boolean isReverseOrder() {
                return isReverseOrder;
            }

            @Override
            public PartitionColumns columns() {
                return PartitionColumns.NONE;
            }

            @Override
            public DecoratedKey partitionKey() {
                return partitionKey;
            }

            @Override
            public DeletionTime partitionLevelDeletion() {
                return partitionDeletion;
            }

            @Override
            public Row staticRow() {
                return staticRow;
            }

            @Override
            public EncodingStats stats() {
                return EncodingStats.NO_STATS;
            }

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public Unfiltered next() {
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
            }

            @Override
            public void close() {
            }
        };
    }

    public static void digest(UnfilteredRowIterator iterator, MessageDigest digest) {
        digest.update(iterator.partitionKey().getKey().duplicate());
        iterator.partitionLevelDeletion().digest(digest);
        iterator.columns().digest(digest);
        FBUtilities.updateWithBoolean(digest, iterator.isReverseOrder());
        iterator.staticRow().digest(digest);
        while (iterator.hasNext()) {
            Unfiltered unfiltered = (Unfiltered)iterator.next();
            unfiltered.digest(digest);
        }
    }

    public static UnfilteredRowIterator concat(final UnfilteredRowIterator iter1, final UnfilteredRowIterator iter2) {
        assert (iter1.metadata().cfId.equals(iter2.metadata().cfId) && iter1.partitionKey().equals(iter2.partitionKey()) && iter1.partitionLevelDeletion().equals(iter2.partitionLevelDeletion()) && iter1.isReverseOrder() == iter2.isReverseOrder() && iter1.columns().equals(iter2.columns()) && iter1.staticRow().equals(iter2.staticRow()));
        return new AbstractUnfilteredRowIterator(iter1.metadata(), iter1.partitionKey(), iter1.partitionLevelDeletion(), iter1.columns(), iter1.staticRow(), iter1.isReverseOrder(), iter1.stats()){

            @Override
            protected Unfiltered computeNext() {
                if (iter1.hasNext()) {
                    return (Unfiltered)iter1.next();
                }
                return iter2.hasNext() ? (Unfiltered)iter2.next() : (Unfiltered)this.endOfData();
            }

            @Override
            public void close() {
                try {
                    iter1.close();
                }
                finally {
                    iter2.close();
                }
            }
        };
    }

    public static UnfilteredRowIterator cloningIterator(UnfilteredRowIterator iterator, final AbstractAllocator allocator) {
        return new AlteringUnfilteredRowIterator(iterator){
            private Row.Builder regularBuilder;

            @Override
            protected Row computeNextStatic(Row row) {
                Row.Builder staticBuilder = allocator.cloningBTreeRowBuilder(this.columns().statics);
                return Rows.copy(row, staticBuilder).build();
            }

            @Override
            protected Row computeNext(Row row) {
                if (this.regularBuilder == null) {
                    this.regularBuilder = allocator.cloningBTreeRowBuilder(this.columns().regulars);
                }
                return Rows.copy(row, this.regularBuilder).build();
            }

            @Override
            protected RangeTombstoneMarker computeNext(RangeTombstoneMarker marker) {
                return marker.copy(allocator);
            }
        };
    }

    public static UnfilteredRowIterator withValidation(final UnfilteredRowIterator iterator, final String filename) {
        return new AlteringUnfilteredRowIterator(iterator){

            @Override
            protected Row computeNextStatic(Row row) {
                this.validate(row);
                return row;
            }

            @Override
            protected Row computeNext(Row row) {
                this.validate(row);
                return row;
            }

            @Override
            protected RangeTombstoneMarker computeNext(RangeTombstoneMarker marker) {
                this.validate(marker);
                return marker;
            }

            private void validate(Unfiltered unfiltered) {
                try {
                    unfiltered.validateData(iterator.metadata());
                }
                catch (MarshalException me) {
                    throw new CorruptSSTableException((Exception)me, filename);
                }
            }
        };
    }

    public static UnfilteredRowIterator loggingIterator(UnfilteredRowIterator iterator, final String id, final boolean fullDetails) {
        CFMetaData metadata = iterator.metadata();
        logger.info("[{}] Logging iterator on {}.{}, partition key={}, reversed={}, deletion={}", new Object[]{id, metadata.ksName, metadata.cfName, metadata.getKeyValidator().getString(iterator.partitionKey().getKey()), iterator.isReverseOrder(), iterator.partitionLevelDeletion().markedForDeleteAt()});
        return new AlteringUnfilteredRowIterator(iterator){

            @Override
            protected Row computeNextStatic(Row row) {
                if (!row.isEmpty()) {
                    logger.info("[{}] {}", (Object)id, (Object)row.toString(this.metadata(), fullDetails));
                }
                return row;
            }

            @Override
            protected Row computeNext(Row row) {
                logger.info("[{}] {}", (Object)id, (Object)row.toString(this.metadata(), fullDetails));
                return row;
            }

            @Override
            protected RangeTombstoneMarker computeNext(RangeTombstoneMarker marker) {
                logger.info("[{}] {}", (Object)id, (Object)marker.toString(this.metadata()));
                return marker;
            }
        };
    }

    private static class FilteringIterator
    extends AbstractIterator<Row>
    implements RowIterator {
        private final UnfilteredRowIterator iter;
        private final int nowInSec;

        public FilteringIterator(UnfilteredRowIterator iter, int nowInSec) {
            this.iter = iter;
            this.nowInSec = nowInSec;
        }

        @Override
        public CFMetaData metadata() {
            return this.iter.metadata();
        }

        @Override
        public boolean isReverseOrder() {
            return this.iter.isReverseOrder();
        }

        @Override
        public PartitionColumns columns() {
            return this.iter.columns();
        }

        @Override
        public DecoratedKey partitionKey() {
            return this.iter.partitionKey();
        }

        @Override
        public Row staticRow() {
            Row row = this.iter.staticRow();
            if (row.isEmpty()) {
                return Rows.EMPTY_STATIC_ROW;
            }
            return (row = row.purge(DeletionPurger.PURGE_ALL, this.nowInSec)) == null ? Rows.EMPTY_STATIC_ROW : row;
        }

        protected Row computeNext() {
            while (this.iter.hasNext()) {
                Row row;
                Unfiltered next = (Unfiltered)this.iter.next();
                if (next.isRangeTombstoneMarker() || (row = ((Row)next).purge(DeletionPurger.PURGE_ALL, this.nowInSec)) == null) continue;
                return row;
            }
            return (Row)this.endOfData();
        }

        @Override
        public void close() {
            this.iter.close();
        }
    }

    private static class UnfilteredRowMergeIterator
    extends AbstractUnfilteredRowIterator {
        private final IMergeIterator<Unfiltered, Unfiltered> mergeIterator;
        private final MergeListener listener;

        private UnfilteredRowMergeIterator(CFMetaData metadata, List<UnfilteredRowIterator> iterators, PartitionColumns columns, DeletionTime partitionDeletion, int nowInSec, boolean reversed, MergeListener listener) {
            super(metadata, iterators.get(0).partitionKey(), partitionDeletion, columns, UnfilteredRowMergeIterator.mergeStaticRows(metadata, iterators, columns.statics, nowInSec, listener, partitionDeletion), reversed, UnfilteredRowMergeIterator.mergeStats(iterators));
            this.mergeIterator = MergeIterator.get(iterators, reversed ? metadata.comparator.reversed() : metadata.comparator, new MergeReducer(iterators.size(), reversed, nowInSec, listener));
            this.listener = listener;
        }

        private static UnfilteredRowMergeIterator create(List<UnfilteredRowIterator> iterators, int nowInSec, MergeListener listener) {
            try {
                UnfilteredRowMergeIterator.checkForInvalidInput(iterators);
                return new UnfilteredRowMergeIterator(iterators.get(0).metadata(), iterators, UnfilteredRowMergeIterator.collectColumns(iterators), UnfilteredRowMergeIterator.collectPartitionLevelDeletion(iterators, listener), nowInSec, iterators.get(0).isReverseOrder(), listener);
            }
            catch (Error | RuntimeException e) {
                try {
                    FBUtilities.closeAll(iterators);
                }
                catch (Exception suppressed) {
                    e.addSuppressed(suppressed);
                }
                throw e;
            }
        }

        private static void checkForInvalidInput(List<UnfilteredRowIterator> iterators) {
            if (iterators.isEmpty()) {
                return;
            }
            UnfilteredRowIterator first = iterators.get(0);
            for (int i = 1; i < iterators.size(); ++i) {
                UnfilteredRowIterator iter = iterators.get(i);
                assert (first.metadata().cfId.equals(iter.metadata().cfId));
                assert (first.partitionKey().equals(iter.partitionKey()));
                assert (first.isReverseOrder() == iter.isReverseOrder());
            }
        }

        private static DeletionTime collectPartitionLevelDeletion(List<UnfilteredRowIterator> iterators, MergeListener listener) {
            DeletionTime[] versions = listener == null ? null : new DeletionTime[iterators.size()];
            DeletionTime delTime = DeletionTime.LIVE;
            for (int i = 0; i < iterators.size(); ++i) {
                UnfilteredRowIterator iter = iterators.get(i);
                DeletionTime iterDeletion = iter.partitionLevelDeletion();
                if (listener != null) {
                    versions[i] = iterDeletion;
                }
                if (delTime.supersedes(iterDeletion)) continue;
                delTime = iterDeletion;
            }
            if (listener != null && !delTime.isLive()) {
                listener.onMergedPartitionLevelDeletion(delTime, versions);
            }
            return delTime;
        }

        private static Row mergeStaticRows(CFMetaData metadata, List<UnfilteredRowIterator> iterators, Columns columns, int nowInSec, MergeListener listener, DeletionTime partitionDeletion) {
            if (columns.isEmpty()) {
                return Rows.EMPTY_STATIC_ROW;
            }
            if (iterators.stream().allMatch(iter -> iter.staticRow().isEmpty())) {
                return Rows.EMPTY_STATIC_ROW;
            }
            Row.Merger merger = new Row.Merger(iterators.size(), nowInSec, columns);
            for (int i = 0; i < iterators.size(); ++i) {
                merger.add(i, iterators.get(i).staticRow());
            }
            Row merged = merger.merge(partitionDeletion);
            if (merged == null) {
                merged = Rows.EMPTY_STATIC_ROW;
            }
            if (listener != null) {
                listener.onMergedRows(merged, columns, merger.mergedRows());
            }
            return merged;
        }

        private static PartitionColumns collectColumns(List<UnfilteredRowIterator> iterators) {
            PartitionColumns first = iterators.get(0).columns();
            Columns statics = first.statics;
            Columns regulars = first.regulars;
            for (int i = 1; i < iterators.size(); ++i) {
                PartitionColumns cols = iterators.get(i).columns();
                statics = statics.mergeTo(cols.statics);
                regulars = regulars.mergeTo(cols.regulars);
            }
            return statics == first.statics && regulars == first.regulars ? first : new PartitionColumns(statics, regulars);
        }

        private static EncodingStats mergeStats(List<UnfilteredRowIterator> iterators) {
            EncodingStats stats = EncodingStats.NO_STATS;
            for (UnfilteredRowIterator iter : iterators) {
                stats = stats.mergeWith(iter.stats());
            }
            return stats;
        }

        @Override
        protected Unfiltered computeNext() {
            while (this.mergeIterator.hasNext()) {
                Unfiltered merged = (Unfiltered)this.mergeIterator.next();
                if (merged == null) continue;
                return merged;
            }
            return (Unfiltered)this.endOfData();
        }

        @Override
        public void close() {
            FileUtils.closeQuietly(this.mergeIterator);
            if (this.listener != null) {
                this.listener.close();
            }
        }

        private class MergeReducer
        extends MergeIterator.Reducer<Unfiltered, Unfiltered> {
            private final MergeListener listener;
            private Unfiltered.Kind nextKind;
            private final Row.Merger rowMerger;
            private final RangeTombstoneMarker.Merger markerMerger;

            private MergeReducer(int size, boolean reversed, int nowInSec, MergeListener listener) {
                this.rowMerger = new Row.Merger(size, nowInSec, UnfilteredRowMergeIterator.this.columns().regulars);
                this.markerMerger = new RangeTombstoneMarker.Merger(size, UnfilteredRowMergeIterator.this.partitionLevelDeletion(), reversed);
                this.listener = listener;
            }

            @Override
            public boolean trivialReduceIsTrivial() {
                return this.listener == null;
            }

            @Override
            public void reduce(int idx, Unfiltered current) {
                this.nextKind = current.kind();
                if (this.nextKind == Unfiltered.Kind.ROW) {
                    this.rowMerger.add(idx, (Row)current);
                } else {
                    this.markerMerger.add(idx, (RangeTombstoneMarker)current);
                }
            }

            @Override
            protected Unfiltered getReduced() {
                if (this.nextKind == Unfiltered.Kind.ROW) {
                    Row merged = this.rowMerger.merge(this.markerMerger.activeDeletion());
                    if (this.listener != null) {
                        this.listener.onMergedRows(merged == null ? BTreeRow.emptyRow(this.rowMerger.mergedClustering()) : merged, UnfilteredRowMergeIterator.this.columns().regulars, this.rowMerger.mergedRows());
                    }
                    return merged;
                }
                RangeTombstoneMarker merged = this.markerMerger.merge();
                if (merged != null && this.listener != null) {
                    this.listener.onMergedRangeTombstoneMarkers(merged, this.markerMerger.mergedMarkers());
                }
                return merged;
            }

            @Override
            protected void onKeyChange() {
                if (this.nextKind == Unfiltered.Kind.ROW) {
                    this.rowMerger.clear();
                } else {
                    this.markerMerger.clear();
                }
            }
        }
    }

    public static interface MergeListener {
        public void onMergedPartitionLevelDeletion(DeletionTime var1, DeletionTime[] var2);

        public void onMergedRows(Row var1, Columns var2, Row[] var3);

        public void onMergedRangeTombstoneMarkers(RangeTombstoneMarker var1, RangeTombstoneMarker[] var2);

        public void close();
    }
}

