/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.partitions;

import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.partitions.AbstractUnfilteredPartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;

public abstract class WrappingUnfilteredPartitionIterator
extends AbstractUnfilteredPartitionIterator {
    protected final UnfilteredPartitionIterator wrapped;
    private UnfilteredRowIterator next;

    protected WrappingUnfilteredPartitionIterator(UnfilteredPartitionIterator wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public boolean isForThrift() {
        return this.wrapped.isForThrift();
    }

    @Override
    public CFMetaData metadata() {
        return this.wrapped.metadata();
    }

    @Override
    public boolean hasNext() {
        this.prepareNext();
        return this.next != null;
    }

    @Override
    public UnfilteredRowIterator next() {
        this.prepareNext();
        assert (this.next != null);
        UnfilteredRowIterator toReturn = this.next;
        this.next = null;
        return toReturn;
    }

    private void prepareNext() {
        while (this.next == null && this.wrapped.hasNext()) {
            UnfilteredRowIterator wrappedNext = (UnfilteredRowIterator)this.wrapped.next();
            try {
                UnfilteredRowIterator maybeNext = this.computeNext(wrappedNext);
                if (maybeNext != null && (this.isForThrift() || maybeNext == wrappedNext || !maybeNext.isEmpty())) {
                    this.next = maybeNext;
                    return;
                }
                wrappedNext.close();
            }
            catch (Error | RuntimeException e) {
                wrappedNext.close();
                throw e;
            }
        }
    }

    protected UnfilteredRowIterator computeNext(UnfilteredRowIterator iter) {
        return iter;
    }

    @Override
    public void close() {
        try {
            this.wrapped.close();
        }
        finally {
            if (this.next != null) {
                this.next.close();
            }
        }
    }
}

