/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.partitions;

import java.io.IOError;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.partitions.AbstractUnfilteredPartitionIterator;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.partitions.WrappingUnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.LazilyInitializedUnfilteredRowIterator;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.rows.SerializationHelper;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIteratorSerializer;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.db.rows.WrappingUnfilteredRowIterator;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.MergeIterator;

public abstract class UnfilteredPartitionIterators {
    private static final Serializer serializer = new Serializer();
    private static final Comparator<UnfilteredRowIterator> partitionComparator = (p1, p2) -> p1.partitionKey().compareTo(p2.partitionKey());

    private UnfilteredPartitionIterators() {
    }

    public static UnfilteredPartitionIterator empty(final CFMetaData metadata) {
        return new AbstractUnfilteredPartitionIterator(){

            @Override
            public boolean isForThrift() {
                return false;
            }

            @Override
            public CFMetaData metadata() {
                return metadata;
            }

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public UnfilteredRowIterator next() {
                throw new NoSuchElementException();
            }
        };
    }

    public static UnfilteredRowIterator getOnlyElement(final UnfilteredPartitionIterator iter, SinglePartitionReadCommand<?> command) {
        UnfilteredRowIterator toReturn = iter.hasNext() ? (UnfilteredRowIterator)iter.next() : UnfilteredRowIterators.emptyIterator(command.metadata(), command.partitionKey(), command.clusteringIndexFilter().isReversed());
        return new WrappingUnfilteredRowIterator(toReturn){

            @Override
            public void close() {
                try {
                    super.close();
                }
                finally {
                    assert (!iter.hasNext());
                    iter.close();
                }
            }
        };
    }

    public static PartitionIterator mergeAndFilter(List<UnfilteredPartitionIterator> iterators, int nowInSec, MergeListener listener) {
        return UnfilteredPartitionIterators.filter(UnfilteredPartitionIterators.merge(iterators, nowInSec, listener), nowInSec);
    }

    public static PartitionIterator filter(final UnfilteredPartitionIterator iterator, final int nowInSec) {
        return new PartitionIterator(){
            private RowIterator next;

            @Override
            public boolean hasNext() {
                while (this.next == null && iterator.hasNext()) {
                    UnfilteredRowIterator rowIterator = (UnfilteredRowIterator)iterator.next();
                    this.next = UnfilteredRowIterators.filter(rowIterator, nowInSec);
                    if (iterator.isForThrift() || !this.next.isEmpty()) continue;
                    rowIterator.close();
                    this.next = null;
                }
                return this.next != null;
            }

            @Override
            public RowIterator next() {
                if (this.next == null && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                RowIterator toReturn = this.next;
                this.next = null;
                return toReturn;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void close() {
                try {
                    iterator.close();
                }
                finally {
                    if (this.next != null) {
                        this.next.close();
                    }
                }
            }
        };
    }

    public static UnfilteredPartitionIterator merge(final List<? extends UnfilteredPartitionIterator> iterators, final int nowInSec, final MergeListener listener) {
        assert (listener != null);
        assert (!iterators.isEmpty());
        final boolean isForThrift = iterators.get(0).isForThrift();
        final CFMetaData metadata = iterators.get(0).metadata();
        final MergeIterator<UnfilteredRowIterator, UnfilteredRowIterator> merged = MergeIterator.get(iterators, partitionComparator, new MergeIterator.Reducer<UnfilteredRowIterator, UnfilteredRowIterator>(){
            private final List<UnfilteredRowIterator> toMerge;
            private DecoratedKey partitionKey;
            private boolean isReverseOrder;
            {
                this.toMerge = new ArrayList<UnfilteredRowIterator>(iterators.size());
            }

            @Override
            public void reduce(int idx, UnfilteredRowIterator current) {
                this.partitionKey = current.partitionKey();
                this.isReverseOrder = current.isReverseOrder();
                this.toMerge.set(idx, current);
            }

            @Override
            protected UnfilteredRowIterator getReduced() {
                UnfilteredRowIterators.MergeListener rowListener = listener.getRowMergeListener(this.partitionKey, this.toMerge);
                for (int i = 0; i < this.toMerge.size(); ++i) {
                    if (this.toMerge.get(i) != null) continue;
                    this.toMerge.set(i, UnfilteredRowIterators.emptyIterator(metadata, this.partitionKey, this.isReverseOrder));
                }
                return UnfilteredRowIterators.merge(this.toMerge, nowInSec, rowListener);
            }

            @Override
            protected void onKeyChange() {
                this.toMerge.clear();
                for (int i = 0; i < iterators.size(); ++i) {
                    this.toMerge.add(null);
                }
            }
        });
        return new AbstractUnfilteredPartitionIterator(){

            @Override
            public boolean isForThrift() {
                return isForThrift;
            }

            @Override
            public CFMetaData metadata() {
                return metadata;
            }

            @Override
            public boolean hasNext() {
                return merged.hasNext();
            }

            @Override
            public UnfilteredRowIterator next() {
                return (UnfilteredRowIterator)merged.next();
            }

            @Override
            public void close() {
                merged.close();
            }
        };
    }

    public static UnfilteredPartitionIterator mergeLazily(final List<? extends UnfilteredPartitionIterator> iterators, final int nowInSec) {
        assert (!iterators.isEmpty());
        if (iterators.size() == 1) {
            return iterators.get(0);
        }
        final boolean isForThrift = iterators.get(0).isForThrift();
        final CFMetaData metadata = iterators.get(0).metadata();
        final MergeIterator<UnfilteredRowIterator, UnfilteredRowIterator> merged = MergeIterator.get(iterators, partitionComparator, new MergeIterator.Reducer<UnfilteredRowIterator, UnfilteredRowIterator>(){
            private final List<UnfilteredRowIterator> toMerge;
            {
                this.toMerge = new ArrayList<UnfilteredRowIterator>(iterators.size());
            }

            @Override
            public boolean trivialReduceIsTrivial() {
                return false;
            }

            @Override
            public void reduce(int idx, UnfilteredRowIterator current) {
                this.toMerge.add(current);
            }

            @Override
            protected UnfilteredRowIterator getReduced() {
                return new LazilyInitializedUnfilteredRowIterator(this.toMerge.get(0).partitionKey()){

                    @Override
                    protected UnfilteredRowIterator initializeIterator() {
                        return UnfilteredRowIterators.merge(toMerge, nowInSec);
                    }
                };
            }

            @Override
            protected void onKeyChange() {
                this.toMerge.clear();
            }
        });
        return new AbstractUnfilteredPartitionIterator(){

            @Override
            public boolean isForThrift() {
                return isForThrift;
            }

            @Override
            public CFMetaData metadata() {
                return metadata;
            }

            @Override
            public boolean hasNext() {
                return merged.hasNext();
            }

            @Override
            public UnfilteredRowIterator next() {
                return (UnfilteredRowIterator)merged.next();
            }

            @Override
            public void close() {
                merged.close();
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void digest(UnfilteredPartitionIterator iterator, MessageDigest digest) {
        try (UnfilteredPartitionIterator iter = iterator;){
            while (iter.hasNext()) {
                UnfilteredRowIterator partition;
                block22: {
                    partition = (UnfilteredRowIterator)iter.next();
                    Throwable throwable = null;
                    try {
                        UnfilteredRowIterators.digest(partition, digest);
                        if (partition == null) continue;
                        if (throwable == null) break block22;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (partition == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    partition.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            partition.close();
                            throw throwable3;
                        }
                    }
                    try {
                        partition.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                partition.close();
            }
            return;
        }
    }

    public static Serializer serializerForIntraNode() {
        return serializer;
    }

    public static UnfilteredPartitionIterator loggingIterator(UnfilteredPartitionIterator iterator, final String id, final boolean fullDetails) {
        return new WrappingUnfilteredPartitionIterator(iterator){

            @Override
            public UnfilteredRowIterator next() {
                return UnfilteredRowIterators.loggingIterator(super.next(), id, fullDetails);
            }
        };
    }

    public static class Serializer {
        public void serialize(UnfilteredPartitionIterator iter, ColumnFilter selection, DataOutputPlus out, int version) throws IOException {
            assert (version >= 10);
            out.writeBoolean(iter.isForThrift());
            while (iter.hasNext()) {
                out.writeBoolean(true);
                UnfilteredRowIterator partition = (UnfilteredRowIterator)iter.next();
                Throwable throwable = null;
                try {
                    UnfilteredRowIteratorSerializer.serializer.serialize(partition, selection, out, version);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (partition == null) continue;
                    if (throwable != null) {
                        try {
                            partition.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    partition.close();
                }
            }
            out.writeBoolean(false);
        }

        public UnfilteredPartitionIterator deserialize(final DataInputPlus in, final int version, final CFMetaData metadata, final ColumnFilter selection, final SerializationHelper.Flag flag) throws IOException {
            assert (version >= 10);
            final boolean isForThrift = in.readBoolean();
            return new AbstractUnfilteredPartitionIterator(){
                private UnfilteredRowIterator next;
                private boolean hasNext;
                private boolean nextReturned = true;

                @Override
                public boolean isForThrift() {
                    return isForThrift;
                }

                @Override
                public CFMetaData metadata() {
                    return metadata;
                }

                @Override
                public boolean hasNext() {
                    if (!this.nextReturned) {
                        return this.hasNext;
                    }
                    if (this.next != null && this.next.hasNext()) {
                        throw new IllegalStateException("Cannot call hasNext() until the previous iterator has been fully consumed");
                    }
                    try {
                        this.hasNext = in.readBoolean();
                        this.nextReturned = false;
                        return this.hasNext;
                    }
                    catch (IOException e) {
                        throw new IOError(e);
                    }
                }

                @Override
                public UnfilteredRowIterator next() {
                    if (this.nextReturned && !this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    try {
                        this.nextReturned = true;
                        this.next = UnfilteredRowIteratorSerializer.serializer.deserialize(in, version, metadata, selection, flag);
                        return this.next;
                    }
                    catch (IOException e) {
                        throw new IOError(e);
                    }
                }

                @Override
                public void close() {
                    if (this.next != null) {
                        this.next.close();
                    }
                }
            };
        }
    }

    public static interface MergeListener {
        public UnfilteredRowIterators.MergeListener getRowMergeListener(DecoratedKey var1, List<UnfilteredRowIterator> var2);

        public void close();
    }
}

