/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.partitions;

import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.WrappingUnfilteredRowIterator;

public class CountingUnfilteredRowIterator
extends WrappingUnfilteredRowIterator {
    private final DataLimits.Counter counter;

    public CountingUnfilteredRowIterator(UnfilteredRowIterator iter, DataLimits.Counter counter) {
        super(iter);
        this.counter = counter;
        counter.newPartition(iter.partitionKey(), iter.staticRow());
    }

    public DataLimits.Counter counter() {
        return this.counter;
    }

    @Override
    public boolean hasNext() {
        if (this.counter.isDoneForPartition()) {
            return false;
        }
        return super.hasNext();
    }

    @Override
    public Unfiltered next() {
        Unfiltered next = super.next();
        if (next.isRow()) {
            this.counter.newRow((Row)next);
        }
        return next;
    }

    @Override
    public void close() {
        super.close();
        this.counter.endOfPartition();
    }
}

