/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Lists;
import org.apache.cassandra.cql3.Maps;
import org.apache.cassandra.cql3.Sets;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.serializers.CollectionSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CollectionType<T>
extends AbstractType<T> {
    private static final Logger logger = LoggerFactory.getLogger(CollectionType.class);
    public static final int MAX_ELEMENTS = 65535;
    public static CellPath.Serializer cellPathSerializer = new CollectionPathSerializer();
    public final Kind kind;

    protected CollectionType(Kind kind) {
        this.kind = kind;
    }

    public abstract AbstractType<?> nameComparator();

    public abstract AbstractType<?> valueComparator();

    protected abstract List<ByteBuffer> serializedValues(Iterator<Cell> var1);

    @Override
    public abstract CollectionSerializer<T> getSerializer();

    public ColumnSpecification makeCollectionReceiver(ColumnSpecification collection, boolean isKey) {
        return this.kind.makeCollectionReceiver(collection, isKey);
    }

    @Override
    public String getString(ByteBuffer bytes) {
        return BytesType.instance.getString(bytes);
    }

    @Override
    public ByteBuffer fromString(String source) {
        try {
            return ByteBufferUtil.hexToBytes(source);
        }
        catch (NumberFormatException e) {
            throw new MarshalException(String.format("cannot parse '%s' as hex bytes", source), e);
        }
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    @Override
    public void validateCellValue(ByteBuffer cellValue) throws MarshalException {
        if (this.isMultiCell()) {
            this.valueComparator().validateCellValue(cellValue);
        } else {
            super.validateCellValue(cellValue);
        }
    }

    public boolean isMap() {
        return this.kind == Kind.MAP;
    }

    protected int collectionSize(List<ByteBuffer> values) {
        return values.size();
    }

    protected int enforceLimit(ColumnDefinition def, List<ByteBuffer> values, int version) {
        assert (this.isMultiCell());
        int size = this.collectionSize(values);
        if (version >= 3 || size <= 65535) {
            return size;
        }
        logger.error("Detected collection for table {}.{} with {} elements, more than the {} limit. Only the first {} elements will be returned to the client. Please see http://cassandra.apache.org/doc/cql3/CQL.html#collections for more details.", new Object[]{def.ksName, def.cfName, values.size(), 65535, 65535});
        return 65535;
    }

    public ByteBuffer serializeForNativeProtocol(ColumnDefinition def, Iterator<Cell> cells, int version) {
        assert (this.isMultiCell());
        List<ByteBuffer> values = this.serializedValues(cells);
        int size = this.enforceLimit(def, values, version);
        return CollectionSerializer.pack(values, size, version);
    }

    @Override
    public boolean isCompatibleWith(AbstractType<?> previous) {
        if (this == previous) {
            return true;
        }
        if (!this.getClass().equals(previous.getClass())) {
            return false;
        }
        CollectionType tprev = (CollectionType)previous;
        if (this.isMultiCell() != tprev.isMultiCell()) {
            return false;
        }
        if (!this.isMultiCell()) {
            return this.isCompatibleWithFrozen(tprev);
        }
        if (!this.nameComparator().isCompatibleWith(tprev.nameComparator())) {
            return false;
        }
        return this.valueComparator().isValueCompatibleWith(tprev.valueComparator());
    }

    @Override
    public boolean isValueCompatibleWithInternal(AbstractType<?> previous) {
        if (this.isMultiCell()) {
            return this.isCompatibleWith(previous);
        }
        if (this == previous) {
            return true;
        }
        if (!this.getClass().equals(previous.getClass())) {
            return false;
        }
        CollectionType tprev = (CollectionType)previous;
        if (this.isMultiCell() != tprev.isMultiCell()) {
            return false;
        }
        return this.isValueCompatibleWithFrozen(tprev);
    }

    protected abstract boolean isCompatibleWithFrozen(CollectionType<?> var1);

    protected abstract boolean isValueCompatibleWithFrozen(CollectionType<?> var1);

    @Override
    public CQL3Type asCQL3Type() {
        return new CQL3Type.Collection(this);
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    private static class CollectionPathSerializer
    implements CellPath.Serializer {
        private CollectionPathSerializer() {
        }

        @Override
        public void serialize(CellPath path, DataOutputPlus out) throws IOException {
            ByteBufferUtil.writeWithVIntLength(path.get(0), out);
        }

        @Override
        public CellPath deserialize(DataInputPlus in) throws IOException {
            return CellPath.create(ByteBufferUtil.readWithVIntLength(in));
        }

        @Override
        public long serializedSize(CellPath path) {
            return ByteBufferUtil.serializedSizeWithVIntLength(path.get(0));
        }

        @Override
        public void skip(DataInputPlus in) throws IOException {
            ByteBufferUtil.skipWithVIntLength(in);
        }
    }

    public static enum Kind {
        MAP{

            @Override
            public ColumnSpecification makeCollectionReceiver(ColumnSpecification collection, boolean isKey) {
                return isKey ? Maps.keySpecOf(collection) : Maps.valueSpecOf(collection);
            }
        }
        ,
        SET{

            @Override
            public ColumnSpecification makeCollectionReceiver(ColumnSpecification collection, boolean isKey) {
                return Sets.valueSpecOf(collection);
            }
        }
        ,
        LIST{

            @Override
            public ColumnSpecification makeCollectionReceiver(ColumnSpecification collection, boolean isKey) {
                return Lists.valueSpecOf(collection);
            }
        };


        public abstract ColumnSpecification makeCollectionReceiver(ColumnSpecification var1, boolean var2);
    }
}

