/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.io.ISerializer;
import org.apache.cassandra.io.sstable.IndexHelper;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;

public class Serializers {
    private final CFMetaData metadata;

    public Serializers(CFMetaData metadata) {
        this.metadata = metadata;
    }

    public IndexHelper.IndexInfo.Serializer indexSerializer(Version version) {
        return new IndexHelper.IndexInfo.Serializer(this.metadata, version);
    }

    public ISerializer<ClusteringPrefix> clusteringPrefixSerializer(final Version version, final SerializationHeader header) {
        if (!version.storeRows()) {
            throw new UnsupportedOperationException();
        }
        return new ISerializer<ClusteringPrefix>(){

            @Override
            public void serialize(ClusteringPrefix clustering, DataOutputPlus out) throws IOException {
                ClusteringPrefix.serializer.serialize(clustering, out, version.correspondingMessagingVersion(), header.clusteringTypes());
            }

            @Override
            public ClusteringPrefix deserialize(DataInputPlus in) throws IOException {
                return ClusteringPrefix.serializer.deserialize(in, version.correspondingMessagingVersion(), header.clusteringTypes());
            }

            @Override
            public long serializedSize(ClusteringPrefix clustering) {
                return ClusteringPrefix.serializer.serializedSize(clustering, version.correspondingMessagingVersion(), header.clusteringTypes());
            }
        };
    }
}

