/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Map;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.IndexName;
import org.apache.cassandra.cql3.statements.IndexPropDefs;
import org.apache.cassandra.cql3.statements.IndexTarget;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.schema.Indexes;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.transport.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateIndexStatement
extends SchemaAlteringStatement {
    private static final Logger logger = LoggerFactory.getLogger(CreateIndexStatement.class);
    private final String indexName;
    private final IndexTarget.Raw rawTarget;
    private final IndexPropDefs properties;
    private final boolean ifNotExists;

    public CreateIndexStatement(CFName name, IndexName indexName, IndexTarget.Raw target, IndexPropDefs properties, boolean ifNotExists) {
        super(name);
        this.indexName = indexName.getIdx();
        this.rawTarget = target;
        this.properties = properties;
        this.ifNotExists = ifNotExists;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        state.hasColumnFamilyAccess(this.keyspace(), this.columnFamily(), Permission.ALTER);
    }

    @Override
    public void validate(ClientState state) throws RequestValidationException {
        boolean isFrozenCollection;
        CFMetaData cfm = ThriftValidation.validateColumnFamily(this.keyspace(), this.columnFamily());
        if (cfm.isCounter()) {
            throw new InvalidRequestException("Secondary indexes are not supported on counter tables");
        }
        IndexTarget target = this.rawTarget.prepare(cfm);
        ColumnDefinition cd = cfm.getColumnDefinition(target.column);
        if (cd == null) {
            throw new InvalidRequestException("No column definition found for column " + target.column);
        }
        boolean isMap = cd.type instanceof MapType;
        boolean bl = isFrozenCollection = cd.type.isCollection() && !cd.type.isMultiCell();
        if (isFrozenCollection) {
            this.validateForFrozenCollection(target);
        } else {
            this.validateNotFullIndex(target);
            this.validateIsValuesIndexIfTargetColumnNotCollection(cd, target);
            this.validateTargetColumnIsMapIfIndexInvolvesKeys(isMap, target);
        }
        if (!Strings.isNullOrEmpty((String)this.indexName) && Schema.instance.getKSMetaData(this.keyspace()).existingIndexNames(null).contains(this.indexName)) {
            if (this.ifNotExists) {
                return;
            }
            throw new InvalidRequestException(String.format("Index %s already exists", this.indexName));
        }
        this.properties.validate();
        if (cfm.isCompactTable()) {
            if (!cfm.isStaticCompactTable()) {
                throw new InvalidRequestException("Secondary indexes are not supported on COMPACT STORAGE tables that have clustering columns");
            }
            if (cd.isPrimaryKeyColumn()) {
                throw new InvalidRequestException("Secondary indexes are not supported on PRIMARY KEY columns in COMPACT STORAGE tables");
            }
        }
        if (!cfm.isCompactTable() && cd.isStatic()) {
            throw new InvalidRequestException("Secondary indexes are not allowed on static columns");
        }
        if (cd.kind == ColumnDefinition.Kind.PARTITION_KEY && cd.isOnAllComponents()) {
            throw new InvalidRequestException(String.format("Cannot create secondary index on partition key column %s", target.column));
        }
    }

    private void validateForFrozenCollection(IndexTarget target) throws InvalidRequestException {
        if (target.type != IndexTarget.Type.FULL) {
            throw new InvalidRequestException(String.format("Cannot create index on %s of frozen<map> column %s", new Object[]{target.type, target.column}));
        }
    }

    private void validateNotFullIndex(IndexTarget target) throws InvalidRequestException {
        if (target.type == IndexTarget.Type.FULL) {
            throw new InvalidRequestException("full() indexes can only be created on frozen collections");
        }
    }

    private void validateIsValuesIndexIfTargetColumnNotCollection(ColumnDefinition cd, IndexTarget target) throws InvalidRequestException {
        if (!cd.type.isCollection() && target.type != IndexTarget.Type.VALUES) {
            throw new InvalidRequestException(String.format("Cannot create index on %s of column %s; only non-frozen collections support %s indexes", new Object[]{target.type, target.column, target.type}));
        }
    }

    private void validateTargetColumnIsMapIfIndexInvolvesKeys(boolean isMap, IndexTarget target) throws InvalidRequestException {
        if (!(target.type != IndexTarget.Type.KEYS && target.type != IndexTarget.Type.KEYS_AND_VALUES || isMap)) {
            throw new InvalidRequestException(String.format("Cannot create index on %s of column %s with non-map type", new Object[]{target.type, target.column}));
        }
    }

    @Override
    public boolean announceMigration(boolean isLocalOnly) throws RequestValidationException {
        Map<String, String> indexOptions;
        IndexMetadata.IndexType indexType;
        CFMetaData cfm = Schema.instance.getCFMetaData(this.keyspace(), this.columnFamily()).copy();
        IndexTarget target = this.rawTarget.prepare(cfm);
        ColumnDefinition cd = cfm.getColumnDefinition(target.column);
        String acceptedName = this.indexName;
        if (Strings.isNullOrEmpty((String)acceptedName)) {
            acceptedName = Indexes.getAvailableIndexName(this.keyspace(), this.columnFamily(), cd.name);
        }
        if (Schema.instance.getKSMetaData(this.keyspace()).existingIndexNames(null).contains(acceptedName)) {
            if (this.ifNotExists) {
                return false;
            }
            throw new InvalidRequestException(String.format("Index %s already exists", acceptedName));
        }
        if (this.properties.isCustom) {
            indexType = IndexMetadata.IndexType.CUSTOM;
            indexOptions = this.properties.getOptions();
        } else if (cfm.isCompound()) {
            ImmutableMap options = Collections.emptyMap();
            if (cd.type.isCollection() && cd.type.isMultiCell()) {
                options = ImmutableMap.of((Object)target.type.indexOption(), (Object)"");
            }
            indexType = IndexMetadata.IndexType.COMPOSITES;
            indexOptions = options;
        } else {
            indexType = IndexMetadata.IndexType.KEYS;
            indexOptions = Collections.emptyMap();
        }
        IndexMetadata index = IndexMetadata.singleColumnIndex(cd, acceptedName, indexType, indexOptions);
        Optional existingIndex = Iterables.tryFind((Iterable)cfm.getIndexes(), existing -> existing.equalsWithoutName(index));
        if (existingIndex.isPresent()) {
            throw new InvalidRequestException(String.format("Index %s is a duplicate of existing index %s", index.name, ((IndexMetadata)existingIndex.get()).name));
        }
        logger.debug("Updating index definition for {}", (Object)this.indexName);
        cfm.indexes(cfm.getIndexes().with(index));
        MigrationManager.announceColumnFamilyUpdate(cfm, false, isLocalOnly);
        return true;
    }

    @Override
    public Event.SchemaChange changeEvent() {
        return new Event.SchemaChange(Event.SchemaChange.Change.UPDATED, Event.SchemaChange.Target.TABLE, this.keyspace(), this.columnFamily());
    }
}

