/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import java.security.AccessControlException;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import org.apache.cassandra.cql3.functions.SecurityThreadGroup;
import sun.security.util.SecurityConstants;

public final class ThreadAwareSecurityManager
extends SecurityManager {
    static final PermissionCollection noPermissions = new PermissionCollection(){

        @Override
        public void add(Permission permission) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean implies(Permission permission) {
            return false;
        }

        @Override
        public Enumeration<Permission> elements() {
            return Collections.emptyEnumeration();
        }
    };
    private static volatile boolean installed;

    public static void install() {
        if (installed) {
            return;
        }
        System.setSecurityManager(new ThreadAwareSecurityManager());
        installed = true;
    }

    private ThreadAwareSecurityManager() {
    }

    private static boolean isSecuredThread() {
        return Thread.currentThread().getThreadGroup() instanceof SecurityThreadGroup;
    }

    @Override
    public void checkAccess(Thread t) {
        if (ThreadAwareSecurityManager.isSecuredThread()) {
            throw new AccessControlException("access denied: " + SecurityConstants.MODIFY_THREAD_PERMISSION, SecurityConstants.MODIFY_THREAD_PERMISSION);
        }
        super.checkAccess(t);
    }

    @Override
    public void checkAccess(ThreadGroup g) {
        if (ThreadAwareSecurityManager.isSecuredThread()) {
            throw new AccessControlException("access denied: " + SecurityConstants.MODIFY_THREADGROUP_PERMISSION, SecurityConstants.MODIFY_THREADGROUP_PERMISSION);
        }
        super.checkAccess(g);
    }

    @Override
    public void checkPermission(Permission perm) {
        if (ThreadAwareSecurityManager.isSecuredThread()) {
            super.checkPermission(perm);
        }
    }

    @Override
    public void checkPermission(Permission perm, Object context) {
        if (ThreadAwareSecurityManager.isSecuredThread()) {
            super.checkPermission(perm, context);
        }
    }

    @Override
    public void checkPackageAccess(String pkg) {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        if (threadGroup instanceof SecurityThreadGroup) {
            Set<String> allowedPackages = ((SecurityThreadGroup)threadGroup).getAllowedPackages();
            if (allowedPackages != null && !allowedPackages.contains(pkg)) {
                throw new AccessControlException("access denied: " + new RuntimePermission("accessClassInPackage." + pkg), new RuntimePermission("accessClassInPackage." + pkg));
            }
            super.checkPackageAccess(pkg);
        }
    }

    static {
        Policy.setPolicy(new Policy(){

            @Override
            public PermissionCollection getPermissions(CodeSource codesource) {
                Permissions perms = new Permissions();
                if (codesource == null || codesource.getLocation() == null) {
                    return perms;
                }
                switch (codesource.getLocation().getProtocol()) {
                    case "file": {
                        perms.add(new AllPermission());
                        return perms;
                    }
                }
                return perms;
            }

            @Override
            public PermissionCollection getPermissions(ProtectionDomain domain) {
                return this.getPermissions(domain.getCodeSource());
            }

            @Override
            public boolean implies(ProtectionDomain domain, Permission permission) {
                CodeSource codesource = domain.getCodeSource();
                if (codesource == null || codesource.getLocation() == null) {
                    return false;
                }
                switch (codesource.getLocation().getProtocol()) {
                    case "file": {
                        return true;
                    }
                }
                return false;
            }
        });
    }
}

