/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.auth.AllowAllAuthorizer;
import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.auth.IAuthorizer;
import org.apache.cassandra.auth.IResource;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.auth.PermissionsCacheMBean;
import org.apache.cassandra.concurrent.DebuggableThreadPoolExecutor;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermissionsCache
implements PermissionsCacheMBean {
    private static final Logger logger = LoggerFactory.getLogger(PermissionsCache.class);
    private final String MBEAN_NAME = "org.apache.cassandra.auth:type=PermissionsCache";
    private final ThreadPoolExecutor cacheRefreshExecutor = new DebuggableThreadPoolExecutor("PermissionsCacheRefresh", 5);
    private final IAuthorizer authorizer;
    private volatile LoadingCache<Pair<AuthenticatedUser, IResource>, Set<Permission>> cache;

    public PermissionsCache(IAuthorizer authorizer) {
        this.authorizer = authorizer;
        this.cache = this.initCache(null);
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            mbs.registerMBean(this, new ObjectName("org.apache.cassandra.auth:type=PermissionsCache"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Set<Permission> getPermissions(AuthenticatedUser user, IResource resource) {
        if (this.cache == null) {
            return this.authorizer.authorize(user, resource);
        }
        try {
            return (Set)this.cache.get(Pair.create(user, resource));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void invalidate() {
        this.cache = this.initCache(null);
    }

    @Override
    public void setValidity(int validityPeriod) {
        DatabaseDescriptor.setPermissionsValidity(validityPeriod);
        this.cache = this.initCache(this.cache);
    }

    @Override
    public int getValidity() {
        return DatabaseDescriptor.getPermissionsValidity();
    }

    @Override
    public void setUpdateInterval(int updateInterval) {
        DatabaseDescriptor.setPermissionsUpdateInterval(updateInterval);
        this.cache = this.initCache(this.cache);
    }

    @Override
    public int getUpdateInterval() {
        return DatabaseDescriptor.getPermissionsUpdateInterval();
    }

    private LoadingCache<Pair<AuthenticatedUser, IResource>, Set<Permission>> initCache(LoadingCache<Pair<AuthenticatedUser, IResource>, Set<Permission>> existing) {
        if (this.authorizer instanceof AllowAllAuthorizer) {
            return null;
        }
        if (DatabaseDescriptor.getPermissionsValidity() <= 0) {
            return null;
        }
        LoadingCache newcache = CacheBuilder.newBuilder().refreshAfterWrite((long)DatabaseDescriptor.getPermissionsUpdateInterval(), TimeUnit.MILLISECONDS).expireAfterWrite((long)DatabaseDescriptor.getPermissionsValidity(), TimeUnit.MILLISECONDS).maximumSize((long)DatabaseDescriptor.getPermissionsCacheMaxEntries()).build((CacheLoader)new CacheLoader<Pair<AuthenticatedUser, IResource>, Set<Permission>>(){

            public Set<Permission> load(Pair<AuthenticatedUser, IResource> userResource) {
                return PermissionsCache.this.authorizer.authorize((AuthenticatedUser)userResource.left, (IResource)userResource.right);
            }

            public ListenableFuture<Set<Permission>> reload(final Pair<AuthenticatedUser, IResource> userResource, Set<Permission> oldValue) {
                ListenableFutureTask task = ListenableFutureTask.create((Callable)new Callable<Set<Permission>>(){

                    @Override
                    public Set<Permission> call() throws Exception {
                        try {
                            return PermissionsCache.this.authorizer.authorize((AuthenticatedUser)userResource.left, (IResource)userResource.right);
                        }
                        catch (Exception e) {
                            logger.debug("Error performing async refresh of user permissions", (Throwable)e);
                            throw e;
                        }
                    }
                });
                PermissionsCache.this.cacheRefreshExecutor.execute((Runnable)task);
                return task;
            }
        });
        if (existing != null) {
            newcache.putAll((Map)existing.asMap());
        }
        return newcache;
    }
}

