/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.memory;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.Columns;
import org.apache.cassandra.db.rows.BTreeBackedRow;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.utils.ByteBufferUtil;

public abstract class AbstractAllocator {
    public ByteBuffer clone(ByteBuffer buffer) {
        assert (buffer != null);
        if (buffer.remaining() == 0) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        ByteBuffer cloned = this.allocate(buffer.remaining());
        cloned.mark();
        cloned.put(buffer.duplicate());
        cloned.reset();
        return cloned;
    }

    public abstract ByteBuffer allocate(int var1);

    public Row.Builder cloningArrayBackedRowBuilder(Columns columns) {
        return new CloningArrayBackedRowBuilder(columns, this);
    }

    private static class CloningArrayBackedRowBuilder
    extends BTreeBackedRow.Builder {
        private final AbstractAllocator allocator;

        private CloningArrayBackedRowBuilder(Columns columns, AbstractAllocator allocator) {
            super(columns, true);
            this.allocator = allocator;
        }

        @Override
        public void newRow(Clustering clustering) {
            super.newRow(clustering.copy(this.allocator));
        }

        @Override
        public void addCell(Cell cell) {
            super.addCell(cell.copy(this.allocator));
        }
    }
}

