/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.cassandra.utils.DynamicList;

public class LockedDynamicList<E>
extends DynamicList<E> {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public LockedDynamicList(int maxExpectedSize) {
        super(maxExpectedSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DynamicList.Node<E> append(E value, int maxSize) {
        this.lock.writeLock().lock();
        try {
            DynamicList.Node<E> node = super.append(value, maxSize);
            return node;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void remove(DynamicList.Node<E> node) {
        this.lock.writeLock().lock();
        try {
            super.remove(node);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public E get(int index) {
        this.lock.readLock().lock();
        try {
            Object e = super.get(index);
            return e;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public int size() {
        this.lock.readLock().lock();
        try {
            int n = super.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

