/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.io.sstable.ISSTableScanner;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableWriter;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.streaming.StreamTask;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.concurrent.Refs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamReceiveTask
extends StreamTask {
    private static final Logger logger = LoggerFactory.getLogger(StreamReceiveTask.class);
    private static final ExecutorService executor = Executors.newCachedThreadPool(new NamedThreadFactory("StreamReceiveTask"));
    private final int totalFiles;
    private final long totalSize;
    public final LifecycleTransaction txn;
    private boolean done = false;
    protected Collection<SSTableWriter> sstables;

    public StreamReceiveTask(StreamSession session, UUID cfId, int totalFiles, long totalSize) {
        super(session, cfId);
        this.totalFiles = totalFiles;
        this.totalSize = totalSize;
        this.txn = LifecycleTransaction.offline(OperationType.STREAM, Schema.instance.getCFMetaData(cfId));
        this.sstables = new ArrayList<SSTableWriter>(totalFiles);
    }

    public synchronized void received(SSTableWriter sstable) {
        if (this.done) {
            return;
        }
        assert (this.cfId.equals(sstable.metadata.cfId));
        this.sstables.add(sstable);
        if (this.sstables.size() == this.totalFiles) {
            this.done = true;
            executor.submit(new OnCompletionRunnable(this));
        }
    }

    @Override
    public int getTotalNumberOfFiles() {
        return this.totalFiles;
    }

    @Override
    public long getTotalSize() {
        return this.totalSize;
    }

    @Override
    public synchronized void abort() {
        if (this.done) {
            return;
        }
        this.done = true;
        for (SSTableWriter writer : this.sstables) {
            writer.abort();
        }
        this.txn.abort();
        this.sstables.clear();
    }

    private static class OnCompletionRunnable
    implements Runnable {
        private final StreamReceiveTask task;

        public OnCompletionRunnable(StreamReceiveTask task) {
            this.task = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Pair<String, String> kscf = Schema.instance.getCF(this.task.cfId);
            if (kscf == null) {
                Iterator<SSTableWriter> iterator = this.task.sstables.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        this.task.sstables.clear();
                        this.task.txn.abort();
                        return;
                    }
                    SSTableWriter writer = iterator.next();
                    writer.abort();
                }
            }
            ColumnFamilyStore cfs = Keyspace.open((String)kscf.left).getColumnFamilyStore((String)kscf.right);
            boolean hasMaterializedViews = cfs.materializedViewManager.allViews().iterator().hasNext();
            try {
                ArrayList<SSTableReader> readers = new ArrayList<SSTableReader>();
                for (SSTableWriter writer : this.task.sstables) {
                    SSTableReader reader = writer.finish(true);
                    readers.add(reader);
                    this.task.txn.update(reader, false);
                }
                this.task.sstables.clear();
                try {
                    block48: {
                        try (Refs refs = Refs.ref(readers);){
                            if (hasMaterializedViews) {
                                for (SSTableReader reader : readers) {
                                    ISSTableScanner scanner = reader.getScanner();
                                    Throwable throwable = null;
                                    try {
                                        while (scanner.hasNext()) {
                                            UnfilteredRowIterator rowIterator;
                                            block47: {
                                                rowIterator = (UnfilteredRowIterator)scanner.next();
                                                Throwable throwable2 = null;
                                                try {
                                                    new Mutation(PartitionUpdate.fromIterator(rowIterator)).apply();
                                                    if (rowIterator == null) continue;
                                                    if (throwable2 == null) break block47;
                                                }
                                                catch (Throwable throwable3) {
                                                    try {
                                                        throwable2 = throwable3;
                                                        throw throwable3;
                                                    }
                                                    catch (Throwable throwable4) {
                                                        if (rowIterator == null) throw throwable4;
                                                        if (throwable2 != null) {
                                                            try {
                                                                rowIterator.close();
                                                                throw throwable4;
                                                            }
                                                            catch (Throwable throwable5) {
                                                                throwable2.addSuppressed(throwable5);
                                                                throw throwable4;
                                                            }
                                                        }
                                                        rowIterator.close();
                                                        throw throwable4;
                                                    }
                                                }
                                                try {
                                                    rowIterator.close();
                                                    continue;
                                                }
                                                catch (Throwable throwable6) {
                                                    throwable2.addSuppressed(throwable6);
                                                    continue;
                                                }
                                            }
                                            rowIterator.close();
                                        }
                                    }
                                    catch (Throwable throwable7) {
                                        throwable = throwable7;
                                        throw throwable7;
                                    }
                                    finally {
                                        if (scanner == null) continue;
                                        if (throwable != null) {
                                            try {
                                                scanner.close();
                                            }
                                            catch (Throwable throwable8) {
                                                throwable.addSuppressed(throwable8);
                                            }
                                            continue;
                                        }
                                        scanner.close();
                                    }
                                }
                                break block48;
                            }
                            this.task.txn.finish();
                            cfs.addSSTables(readers);
                            cfs.indexManager.maybeBuildSecondaryIndexes(readers, cfs.indexManager.allIndexesNames());
                        }
                    }
                    if (!hasMaterializedViews) return;
                }
                catch (Throwable t) {
                    try {
                        logger.error("Error applying streamed sstable: ", t);
                        JVMStabilityInspector.inspectThrowable(t);
                        return;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (hasMaterializedViews) {
                            this.task.txn.abort();
                        }
                    }
                }
                this.task.txn.abort();
                return;
            }
            finally {
                this.task.session.taskCompleted(this.task);
            }
        }
    }
}

