/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.pager;

import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadOrderGroup;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.partitions.CountingPartitionIterator;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.PartitionIterators;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.rows.WrappingRowIterator;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.pager.QueryPager;
import org.apache.cassandra.service.pager.SinglePartitionPager;

abstract class AbstractQueryPager
implements QueryPager {
    protected final ReadCommand command;
    protected final DataLimits limits;
    private int remaining;
    private DecoratedKey lastKey;
    private int remainingInPartition;
    private boolean exhausted;

    protected AbstractQueryPager(ReadCommand command) {
        this.command = command;
        this.limits = command.limits();
        this.remaining = this.limits.count();
        this.remainingInPartition = this.limits.perPartitionCount();
    }

    @Override
    public ReadOrderGroup startOrderGroup() {
        return this.command.startOrderGroup();
    }

    @Override
    public PartitionIterator fetchPage(int pageSize, ConsistencyLevel consistency, ClientState clientState) throws RequestValidationException, RequestExecutionException {
        if (this.isExhausted()) {
            return PartitionIterators.EMPTY;
        }
        pageSize = Math.min(pageSize, this.remaining);
        return new PagerIterator(this.nextPageReadCommand(pageSize).execute(consistency, clientState), this.limits.forPaging(pageSize), this.command.nowInSec());
    }

    @Override
    public PartitionIterator fetchPageInternal(int pageSize, ReadOrderGroup orderGroup) throws RequestValidationException, RequestExecutionException {
        if (this.isExhausted()) {
            return PartitionIterators.EMPTY;
        }
        pageSize = Math.min(pageSize, this.remaining);
        return new PagerIterator(this.nextPageReadCommand(pageSize).executeInternal(orderGroup), this.limits.forPaging(pageSize), this.command.nowInSec());
    }

    protected void restoreState(DecoratedKey lastKey, int remaining, int remainingInPartition) {
        this.lastKey = lastKey;
        this.remaining = remaining;
        this.remainingInPartition = remainingInPartition;
    }

    @Override
    public boolean isExhausted() {
        return this.exhausted || this.remaining == 0 || this instanceof SinglePartitionPager && this.remainingInPartition == 0;
    }

    @Override
    public int maxRemaining() {
        return this.remaining;
    }

    protected int remainingInPartition() {
        return this.remainingInPartition;
    }

    protected abstract ReadCommand nextPageReadCommand(int var1);

    protected abstract void recordLast(DecoratedKey var1, Row var2);

    private class PagerIterator
    extends CountingPartitionIterator {
        private final DataLimits pageLimits;
        private Row lastRow;

        private PagerIterator(PartitionIterator iter, DataLimits pageLimits, int nowInSec) {
            super(iter, pageLimits, nowInSec);
            this.pageLimits = pageLimits;
        }

        @Override
        public RowIterator next() {
            RowIterator iter = super.next();
            try {
                DecoratedKey key = iter.partitionKey();
                if (AbstractQueryPager.this.lastKey == null || !AbstractQueryPager.this.lastKey.equals(key)) {
                    AbstractQueryPager.this.remainingInPartition = AbstractQueryPager.this.limits.perPartitionCount();
                }
                AbstractQueryPager.this.lastKey = key;
                return new RowPagerIterator(iter);
            }
            catch (RuntimeException e) {
                iter.close();
                throw e;
            }
        }

        @Override
        public void close() {
            super.close();
            AbstractQueryPager.this.recordLast(AbstractQueryPager.this.lastKey, this.lastRow);
            int counted = this.counter.counted();
            AbstractQueryPager.this.remaining = AbstractQueryPager.this.remaining - counted;
            AbstractQueryPager.this.remainingInPartition = AbstractQueryPager.this.remainingInPartition - this.counter.countedInCurrentPartition();
            AbstractQueryPager.this.exhausted = counted < this.pageLimits.count();
        }

        private class RowPagerIterator
        extends WrappingRowIterator {
            RowPagerIterator(RowIterator iter) {
                super(iter);
            }

            @Override
            public Row next() {
                PagerIterator.this.lastRow = super.next();
                return PagerIterator.this.lastRow;
            }
        }
    }
}

