/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.cassandra.db.marshal.UserType;

public final class Types
implements Iterable<UserType> {
    private final ImmutableMap<ByteBuffer, UserType> types;

    private Types(Builder builder) {
        this.types = builder.types.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Types none() {
        return Types.builder().build();
    }

    public static Types of(UserType ... types) {
        return Types.builder().add(types).build();
    }

    @Override
    public Iterator<UserType> iterator() {
        return this.types.values().iterator();
    }

    public Optional<UserType> get(ByteBuffer name) {
        return Optional.ofNullable(this.types.get((Object)name));
    }

    @Nullable
    public UserType getNullable(ByteBuffer name) {
        return (UserType)this.types.get((Object)name);
    }

    public Types with(UserType type) {
        if (this.get(type.name).isPresent()) {
            throw new IllegalStateException(String.format("Type %s already exists", type.name));
        }
        return Types.builder().add(this).add(type).build();
    }

    public Types without(ByteBuffer name) {
        UserType type = this.get(name).orElseThrow(() -> new IllegalStateException(String.format("Type %s doesn't exists", name)));
        return Types.builder().add(Iterables.filter((Iterable)this, t -> t != type)).build();
    }

    public boolean equals(Object o) {
        return this == o || o instanceof Types && this.types.equals(((Types)o).types);
    }

    public int hashCode() {
        return this.types.hashCode();
    }

    public String toString() {
        return this.types.values().toString();
    }

    public static final class Builder {
        final ImmutableMap.Builder<ByteBuffer, UserType> types = new ImmutableMap.Builder();

        private Builder() {
        }

        public Types build() {
            return new Types(this);
        }

        public Builder add(UserType type) {
            this.types.put((Object)type.name, (Object)type);
            return this;
        }

        public Builder add(UserType ... types) {
            for (UserType type : types) {
                this.add(type);
            }
            return this;
        }

        public Builder add(Iterable<UserType> types) {
            types.forEach(this::add);
            return this;
        }
    }
}

