/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.Set;
import java.util.zip.Checksum;
import net.jpountz.lz4.LZ4BlockInputStream;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import net.jpountz.xxhash.XXHashFactory;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.UnknownColumnFamilyException;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.NIODataInputStream;
import org.apache.cassandra.net.CompactEndpointSerializationHelper;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessagingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xerial.snappy.SnappyInputStream;

public class IncomingTcpConnection
extends Thread
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(IncomingTcpConnection.class);
    private static final int BUFFER_SIZE = Integer.getInteger("cassandra..itc_buffer_size", 4096);
    private final int version;
    private final boolean compressed;
    private final Socket socket;
    private final Set<Closeable> group;
    public InetAddress from;

    public IncomingTcpConnection(int version, boolean compressed, Socket socket, Set<Closeable> group) {
        super("MessagingService-Incoming-" + socket.getInetAddress());
        this.version = version;
        this.compressed = compressed;
        this.socket = socket;
        this.group = group;
        if (DatabaseDescriptor.getInternodeRecvBufferSize() != null) {
            try {
                this.socket.setReceiveBufferSize(DatabaseDescriptor.getInternodeRecvBufferSize());
            }
            catch (SocketException se) {
                logger.warn("Failed to set receive buffer size on internode socket.", (Throwable)se);
            }
        }
    }

    @Override
    public void run() {
        try {
            if (this.version < 7) {
                throw new UnsupportedOperationException(String.format("Unable to read obsolete message version %s; The earliest version supported is 2.0.0", this.version));
            }
            this.receiveMessages();
        }
        catch (EOFException e) {
            logger.trace("eof reading from socket; closing", (Throwable)e);
        }
        catch (UnknownColumnFamilyException e) {
            logger.warn("UnknownColumnFamilyException reading from socket; closing", (Throwable)e);
        }
        catch (IOException e) {
            logger.debug("IOException reading from socket; closing", (Throwable)e);
        }
        finally {
            this.close();
        }
    }

    @Override
    public void close() {
        try {
            if (!this.socket.isClosed()) {
                this.socket.close();
            }
        }
        catch (IOException e) {
            logger.debug("Error closing socket", (Throwable)e);
        }
        finally {
            this.group.remove(this);
        }
    }

    private void receiveMessages() throws IOException {
        DataOutputStream out = new DataOutputStream(this.socket.getOutputStream());
        out.writeInt(10);
        out.flush();
        InputStream in = new DataInputPlus.DataInputStreamPlus(this.socket.getInputStream());
        int maxVersion = in.readInt();
        assert (this.version <= 10);
        this.from = CompactEndpointSerializationHelper.deserialize((DataInput)((Object)in));
        MessagingService.instance().setVersion(this.from, maxVersion);
        logger.debug("Set version for {} to {} (will use {})", new Object[]{this.from, maxVersion, MessagingService.instance().getVersion(this.from)});
        if (this.compressed) {
            logger.debug("Upgrading incoming connection to be compressed");
            if (this.version < 8) {
                in = new DataInputPlus.DataInputStreamPlus((InputStream)new SnappyInputStream(this.socket.getInputStream()));
            } else {
                LZ4FastDecompressor decompressor = LZ4Factory.fastestInstance().fastDecompressor();
                Checksum checksum = XXHashFactory.fastestInstance().newStreamingHash32(-1756908916).asChecksum();
                in = new DataInputPlus.DataInputStreamPlus((InputStream)new LZ4BlockInputStream(this.socket.getInputStream(), decompressor, checksum));
            }
        } else {
            in = new NIODataInputStream(this.socket.getChannel(), BUFFER_SIZE);
        }
        while (true) {
            MessagingService.validateMagic(in.readInt());
            this.receiveMessage((DataInputPlus)((Object)in), this.version);
        }
    }

    private InetAddress receiveMessage(DataInputPlus input, int version) throws IOException {
        MessageIn message;
        int id = version < 7 ? Integer.parseInt(input.readUTF()) : input.readInt();
        long timestamp = System.currentTimeMillis();
        boolean isCrossNodeTimestamp = false;
        int partial = input.readInt();
        if (DatabaseDescriptor.hasCrossNodeTimeout()) {
            long crossNodeTimestamp = timestamp & 0xFFFFFFFF00000000L | ((long)partial & 0xFFFFFFFFL) << 2 >> 2;
            isCrossNodeTimestamp = timestamp != crossNodeTimestamp;
            timestamp = crossNodeTimestamp;
        }
        if ((message = MessageIn.read(input, version, id)) == null) {
            return null;
        }
        if (version <= 10) {
            MessagingService.instance().receive(message, id, timestamp, isCrossNodeTimestamp);
        } else {
            logger.debug("Received connection from newer protocol version {}. Ignoring message", (Object)version);
        }
        return message.from;
    }
}

