/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import java.security.MessageDigest;
import java.util.NoSuchElementException;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.PartitionColumns;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.WrappingRowIterator;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RowIterators {
    private static final Logger logger = LoggerFactory.getLogger(RowIterators.class);

    private RowIterators() {
    }

    public static void digest(RowIterator iterator, MessageDigest digest) {
        digest.update(iterator.partitionKey().getKey().duplicate());
        iterator.columns().digest(digest);
        FBUtilities.updateWithBoolean(digest, iterator.isReverseOrder());
        iterator.staticRow().digest(digest);
        while (iterator.hasNext()) {
            ((Row)iterator.next()).digest(digest);
        }
    }

    public static RowIterator emptyIterator(final CFMetaData cfm, final DecoratedKey partitionKey, final boolean isReverseOrder) {
        return new RowIterator(){

            @Override
            public CFMetaData metadata() {
                return cfm;
            }

            @Override
            public boolean isReverseOrder() {
                return isReverseOrder;
            }

            @Override
            public PartitionColumns columns() {
                return PartitionColumns.NONE;
            }

            @Override
            public DecoratedKey partitionKey() {
                return partitionKey;
            }

            @Override
            public Row staticRow() {
                return Rows.EMPTY_STATIC_ROW;
            }

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public Row next() {
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void close() {
            }
        };
    }

    public static RowIterator loggingIterator(RowIterator iterator, final String id) {
        CFMetaData metadata = iterator.metadata();
        logger.info("[{}] Logging iterator on {}.{}, partition key={}, reversed={}", new Object[]{id, metadata.ksName, metadata.cfName, metadata.getKeyValidator().getString(iterator.partitionKey().getKey()), iterator.isReverseOrder()});
        return new WrappingRowIterator(iterator){

            @Override
            public Row staticRow() {
                Row row = super.staticRow();
                if (!row.isEmpty()) {
                    logger.info("[{}] {}", (Object)id, (Object)row.toString(this.metadata()));
                }
                return row;
            }

            @Override
            public Row next() {
                Row next = super.next();
                logger.info("[{}] {}", (Object)id, (Object)next.toString(this.metadata()));
                return next;
            }
        };
    }
}

