/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.DeletionPurger;
import org.apache.cassandra.db.LivenessInfo;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.rows.BufferCell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.db.rows.ColumnData;
import org.apache.cassandra.db.rows.SerializationHelper;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.memory.AbstractAllocator;

public abstract class Cell
extends ColumnData {
    public static final int NO_TTL = 0;
    public static final int NO_DELETION_TIME = Integer.MAX_VALUE;
    public final Comparator<Cell> comparator = (c1, c2) -> {
        int cmp = c1.column().compareTo(c2.column());
        if (cmp != 0) {
            return cmp;
        }
        Comparator<CellPath> pathComparator = c1.column().cellPathComparator();
        return pathComparator == null ? 0 : pathComparator.compare(c1.path(), c2.path());
    };
    public static final Serializer serializer = new BufferCell.Serializer();

    protected Cell(ColumnDefinition column) {
        super(column);
    }

    public abstract boolean isCounterCell();

    public abstract ByteBuffer value();

    public abstract long timestamp();

    public abstract int ttl();

    public abstract int localDeletionTime();

    public abstract boolean isTombstone();

    public abstract boolean isExpiring();

    public abstract boolean isLive(int var1);

    public abstract CellPath path();

    public abstract Cell withUpdatedValue(ByteBuffer var1);

    public abstract Cell copy(AbstractAllocator var1);

    @Override
    public abstract Cell markCounterLocalToBeCleared();

    @Override
    public abstract Cell purge(DeletionPurger var1, int var2);

    public static interface Serializer {
        public void serialize(Cell var1, DataOutputPlus var2, LivenessInfo var3, SerializationHeader var4) throws IOException;

        public Cell deserialize(DataInputPlus var1, LivenessInfo var2, ColumnDefinition var3, SerializationHeader var4, SerializationHelper var5) throws IOException;

        public long serializedSize(Cell var1, LivenessInfo var2, SerializationHeader var3);

        public boolean skip(DataInputPlus var1, ColumnDefinition var2, SerializationHeader var3) throws IOException;
    }
}

