/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.partitions;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.Columns;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.LegacyLayout;
import org.apache.cassandra.db.MutableDeletionInfo;
import org.apache.cassandra.db.PartitionColumns;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.partitions.AbstractThreadUnsafePartition;
import org.apache.cassandra.db.rows.BTreeBackedRow;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.db.rows.ColumnData;
import org.apache.cassandra.db.rows.ComplexColumnData;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.SerializationHelper;
import org.apache.cassandra.db.rows.SliceableUnfilteredRowIterator;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIteratorSerializer;
import org.apache.cassandra.io.util.DataInputBuffer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.MergeIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionUpdate
extends AbstractThreadUnsafePartition {
    protected static final Logger logger = LoggerFactory.getLogger(PartitionUpdate.class);
    public static final PartitionUpdateSerializer serializer = new PartitionUpdateSerializer();
    private final int createdAtInSec = FBUtilities.nowInSeconds();
    private boolean isBuilt;
    private boolean canReOpen = true;
    private final MutableDeletionInfo deletionInfo;
    private EncodingStats stats;
    private Row staticRow = Rows.EMPTY_STATIC_ROW;
    private final boolean canHaveShadowedData;

    private PartitionUpdate(CFMetaData metadata, DecoratedKey key, PartitionColumns columns, Row staticRow, List<Row> rows, MutableDeletionInfo deletionInfo, EncodingStats stats, boolean isBuilt, boolean canHaveShadowedData) {
        super(metadata, key, columns, rows);
        this.staticRow = staticRow;
        this.deletionInfo = deletionInfo;
        this.stats = stats;
        this.isBuilt = isBuilt;
        this.canHaveShadowedData = canHaveShadowedData;
    }

    public PartitionUpdate(CFMetaData metadata, DecoratedKey key, PartitionColumns columns, int initialRowCapacity) {
        this(metadata, key, columns, Rows.EMPTY_STATIC_ROW, new ArrayList<Row>(initialRowCapacity), MutableDeletionInfo.live(), null, false, true);
    }

    public static PartitionUpdate emptyUpdate(CFMetaData metadata, DecoratedKey key) {
        return new PartitionUpdate(metadata, key, PartitionColumns.NONE, Rows.EMPTY_STATIC_ROW, Collections.emptyList(), MutableDeletionInfo.live(), EncodingStats.NO_STATS, true, false);
    }

    public static PartitionUpdate fullPartitionDelete(CFMetaData metadata, DecoratedKey key, long timestamp, int nowInSec) {
        return new PartitionUpdate(metadata, key, PartitionColumns.NONE, Rows.EMPTY_STATIC_ROW, Collections.emptyList(), new MutableDeletionInfo(timestamp, nowInSec), EncodingStats.NO_STATS, true, false);
    }

    public static PartitionUpdate singleRowUpdate(CFMetaData metadata, DecoratedKey key, Row row) {
        return row.isStatic() ? new PartitionUpdate(metadata, key, new PartitionColumns(row.columns(), Columns.NONE), row, Collections.emptyList(), MutableDeletionInfo.live(), EncodingStats.NO_STATS, true, false) : new PartitionUpdate(metadata, key, new PartitionColumns(Columns.NONE, row.columns()), Rows.EMPTY_STATIC_ROW, Collections.singletonList(row), MutableDeletionInfo.live(), EncodingStats.NO_STATS, true, false);
    }

    public static PartitionUpdate fromIterator(UnfilteredRowIterator iterator) {
        CFMetaData metadata = iterator.metadata();
        boolean reversed = iterator.isReverseOrder();
        ArrayList<Row> rows = new ArrayList<Row>();
        MutableDeletionInfo.Builder deletionBuilder = MutableDeletionInfo.builder(iterator.partitionLevelDeletion(), metadata.comparator, reversed);
        while (iterator.hasNext()) {
            Unfiltered unfiltered = (Unfiltered)iterator.next();
            if (unfiltered.kind() == Unfiltered.Kind.ROW) {
                rows.add((Row)unfiltered);
                continue;
            }
            deletionBuilder.add((RangeTombstoneMarker)unfiltered);
        }
        if (reversed) {
            Collections.reverse(rows);
        }
        return new PartitionUpdate(metadata, iterator.partitionKey(), iterator.columns(), iterator.staticRow(), rows, deletionBuilder.build(), iterator.stats(), true, false);
    }

    public static PartitionUpdate fromIterator(RowIterator iterator) {
        CFMetaData metadata = iterator.metadata();
        boolean reversed = iterator.isReverseOrder();
        ArrayList<Row> rows = new ArrayList<Row>();
        EncodingStats.Collector collector = new EncodingStats.Collector();
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            rows.add(row);
            Rows.collectStats(row, collector);
        }
        if (reversed) {
            Collections.reverse(rows);
        }
        return new PartitionUpdate(metadata, iterator.partitionKey(), iterator.columns(), iterator.staticRow(), rows, MutableDeletionInfo.live(), collector.get(), true, false);
    }

    @Override
    protected boolean canHaveShadowedData() {
        return this.canHaveShadowedData;
    }

    @Override
    public Row staticRow() {
        return this.staticRow;
    }

    @Override
    public DeletionInfo deletionInfo() {
        return this.deletionInfo;
    }

    public static PartitionUpdate fromBytes(ByteBuffer bytes, int version, DecoratedKey key) {
        if (bytes == null) {
            return null;
        }
        try {
            return serializer.deserialize(new DataInputBuffer(bytes, true), version, SerializationHelper.Flag.LOCAL, version < 10 ? key : null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ByteBuffer toBytes(PartitionUpdate update, int version) {
        try (DataOutputBuffer out = new DataOutputBuffer();){
            serializer.serialize(update, out, version);
            ByteBuffer byteBuffer = ByteBuffer.wrap(out.getData(), 0, out.getLength());
            return byteBuffer;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static PartitionUpdate merge(Collection<PartitionUpdate> updates) {
        assert (!updates.isEmpty());
        int size = updates.size();
        if (size == 1) {
            return (PartitionUpdate)Iterables.getOnlyElement(updates);
        }
        int nowInSec = FBUtilities.nowInSeconds();
        PartitionColumns.Builder builder = PartitionColumns.builder();
        DecoratedKey key = null;
        CFMetaData metadata = null;
        MutableDeletionInfo deletion = MutableDeletionInfo.live();
        Row staticRow = Rows.EMPTY_STATIC_ROW;
        ArrayList<Iterator<Row>> updateRowIterators = new ArrayList<Iterator<Row>>(size);
        EncodingStats stats = EncodingStats.NO_STATS;
        for (PartitionUpdate update : updates) {
            builder.addAll(update.columns());
            deletion.add(update.deletionInfo());
            if (!update.staticRow().isEmpty()) {
                staticRow = staticRow == Rows.EMPTY_STATIC_ROW ? update.staticRow() : Rows.merge(staticRow, update.staticRow(), nowInSec);
            }
            updateRowIterators.add(update.iterator());
            stats = stats.mergeWith(update.stats());
            if (key == null) {
                key = update.partitionKey();
            } else assert (key.equals(update.partitionKey()));
            if (metadata == null) {
                metadata = update.metadata();
                continue;
            }
            assert (metadata.cfId.equals(update.metadata().cfId));
        }
        PartitionColumns columns = builder.build();
        final Row.Merger merger = new Row.Merger(size, nowInSec, columns.regulars);
        MergeIterator<Row, Row> merged = MergeIterator.get(updateRowIterators, metadata.comparator, new MergeIterator.Reducer<Row, Row>(){

            @Override
            public boolean trivialReduceIsTrivial() {
                return true;
            }

            @Override
            public void reduce(int idx, Row current) {
                merger.add(idx, current);
            }

            @Override
            protected Row getReduced() {
                return merger.merge(DeletionTime.LIVE);
            }

            @Override
            protected void onKeyChange() {
                merger.clear();
            }
        });
        ArrayList<Row> rows = new ArrayList<Row>();
        Iterators.addAll(rows, merged);
        return new PartitionUpdate(metadata, key, columns, staticRow, rows, deletion, stats, true, true);
    }

    public void updateAllTimestamp(long newTimestamp) {
        this.maybeBuild();
        this.deletionInfo.updateAllTimestamp(newTimestamp - 1L);
        if (!this.staticRow.isEmpty()) {
            this.staticRow = this.staticRow.updateAllTimestamp(newTimestamp);
        }
        for (int i = 0; i < this.rows.size(); ++i) {
            this.rows.set(i, ((Row)this.rows.get(i)).updateAllTimestamp(newTimestamp));
        }
    }

    public int operationCount() {
        return this.rows.size() + this.deletionInfo.rangeCount() + (this.deletionInfo.getPartitionDeletion().isLive() ? 0 : 1);
    }

    public int dataSize() {
        int size = 0;
        for (Row row : this) {
            size += row.clustering().dataSize();
            for (ColumnData cd : row) {
                size += cd.dataSize();
            }
        }
        return size;
    }

    @Override
    public int rowCount() {
        this.maybeBuild();
        return super.rowCount();
    }

    @Override
    public EncodingStats stats() {
        this.maybeBuild();
        return this.stats;
    }

    public synchronized void allowNewUpdates() {
        if (!this.canReOpen) {
            throw new IllegalStateException("You cannot do more updates on collectCounterMarks has been called");
        }
        this.isBuilt = false;
    }

    @Override
    public Iterator<Row> iterator() {
        this.maybeBuild();
        return super.iterator();
    }

    @Override
    protected SliceableUnfilteredRowIterator sliceableUnfilteredIterator(ColumnFilter columns, boolean reversed) {
        this.maybeBuild();
        return super.sliceableUnfilteredIterator(columns, reversed);
    }

    public void validate() {
        for (Row row : this) {
            this.metadata().comparator.validate(row.clustering());
            for (ColumnData cd : row) {
                cd.validate();
            }
        }
    }

    public long maxTimestamp() {
        this.maybeBuild();
        long maxTimestamp = this.deletionInfo.maxTimestamp();
        for (Row row : this) {
            maxTimestamp = Math.max(maxTimestamp, row.primaryKeyLivenessInfo().timestamp());
            for (ColumnData cd : row) {
                if (cd.column().isSimple()) {
                    maxTimestamp = Math.max(maxTimestamp, ((Cell)cd).timestamp());
                    continue;
                }
                ComplexColumnData complexData = (ComplexColumnData)cd;
                maxTimestamp = Math.max(maxTimestamp, complexData.complexDeletion().markedForDeleteAt());
                for (Cell cell : complexData) {
                    maxTimestamp = Math.max(maxTimestamp, cell.timestamp());
                }
            }
        }
        return maxTimestamp;
    }

    public List<CounterMark> collectCounterMarks() {
        assert (this.metadata().isCounter());
        this.maybeBuild();
        this.canReOpen = false;
        ArrayList<CounterMark> l = new ArrayList<CounterMark>();
        for (Row row : this.rows) {
            for (Cell cell : row.cells()) {
                if (!cell.isCounterCell()) continue;
                l.add(new CounterMark(row, cell.column(), cell.path()));
            }
        }
        return l;
    }

    private void assertNotBuilt() {
        if (this.isBuilt) {
            throw new IllegalStateException("An update should not be written again once it has been read");
        }
    }

    public void addPartitionDeletion(DeletionTime deletionTime) {
        this.assertNotBuilt();
        this.deletionInfo.add(deletionTime);
    }

    public void add(RangeTombstone range) {
        this.assertNotBuilt();
        this.deletionInfo.add(range, this.metadata.comparator);
    }

    public void add(Row row) {
        if (row.isEmpty()) {
            return;
        }
        this.assertNotBuilt();
        if (row.isStatic()) {
            assert (this.columns().statics == row.columns() || this.columns().statics.contains(row.columns()));
            this.staticRow = this.staticRow.isEmpty() ? row : Rows.merge(this.staticRow, row, this.createdAtInSec);
        } else {
            assert (this.columns().regulars == row.columns() || this.columns().regulars.contains(row.columns()));
            this.rows.add(row);
        }
    }

    public int size() {
        return this.rows.size();
    }

    private void maybeBuild() {
        if (this.isBuilt) {
            return;
        }
        this.build();
    }

    private synchronized void build() {
        if (this.isBuilt) {
            return;
        }
        if (this.rows.size() <= 1) {
            this.finishBuild();
            return;
        }
        Comparator<Row> comparator = this.metadata.comparator.rowComparator();
        Collections.sort(this.rows, comparator);
        int previous = 0;
        for (int current = 1; current < this.rows.size(); ++current) {
            Row currentRow;
            Row previousRow = (Row)this.rows.get(previous);
            int cmp = comparator.compare(previousRow, currentRow = (Row)this.rows.get(current));
            if (cmp == 0) {
                this.rows.set(previous, Rows.merge(previousRow, currentRow, this.createdAtInSec));
                continue;
            }
            if (++previous == current) continue;
            this.rows.set(previous, currentRow);
        }
        for (int j = this.rows.size() - 1; j > previous; --j) {
            this.rows.remove(j);
        }
        this.finishBuild();
    }

    private void finishBuild() {
        EncodingStats.Collector collector = new EncodingStats.Collector();
        this.deletionInfo.collectStats(collector);
        for (Row row : this.rows) {
            Rows.collectStats(row, collector);
        }
        this.stats = collector.get();
        this.isBuilt = true;
    }

    public static class CounterMark {
        private final Row row;
        private final ColumnDefinition column;
        private final CellPath path;

        private CounterMark(Row row, ColumnDefinition column, CellPath path) {
            this.row = row;
            this.column = column;
            this.path = path;
        }

        public Clustering clustering() {
            return this.row.clustering();
        }

        public ColumnDefinition column() {
            return this.column;
        }

        public CellPath path() {
            return this.path;
        }

        public ByteBuffer value() {
            return this.path == null ? this.row.getCell(this.column).value() : this.row.getCell(this.column, this.path).value();
        }

        public void setValue(ByteBuffer value) {
            assert (this.row instanceof BTreeBackedRow);
            ((BTreeBackedRow)this.row).setValue(this.column, this.path, value);
        }
    }

    public static class PartitionUpdateSerializer {
        public void serialize(PartitionUpdate update, DataOutputPlus out, int version) throws IOException {
            if (version < 10) {
                throw new UnsupportedOperationException();
            }
            CFMetaData.serializer.serialize(update.metadata(), out, version);
            try (SliceableUnfilteredRowIterator iter = update.sliceableUnfilteredIterator();){
                assert (!iter.isReverseOrder());
                UnfilteredRowIteratorSerializer.serializer.serialize(iter, out, version, update.rows.size());
            }
        }

        public PartitionUpdate deserialize(DataInputPlus in, int version, SerializationHelper.Flag flag, DecoratedKey key) throws IOException {
            if (version < 10) {
                assert (key != null);
                boolean present = in.readBoolean();
                assert (present);
                CFMetaData metadata = CFMetaData.serializer.deserialize(in, version);
                LegacyLayout.LegacyDeletionInfo info = LegacyLayout.LegacyDeletionInfo.serializer.deserialize(metadata, in, version);
                int size = in.readInt();
                Iterator<LegacyLayout.LegacyCell> cells = LegacyLayout.deserializeCells(metadata, in, flag, size);
                SerializationHelper helper = new SerializationHelper(metadata, version, flag);
                try (UnfilteredRowIterator iterator = LegacyLayout.onWireCellstoUnfilteredRowIterator(metadata, key, info, cells, false, helper);){
                    PartitionUpdate partitionUpdate = PartitionUpdate.fromIterator(iterator);
                    return partitionUpdate;
                }
            }
            assert (key == null);
            CFMetaData metadata = CFMetaData.serializer.deserialize(in, version);
            UnfilteredRowIteratorSerializer.Header header = UnfilteredRowIteratorSerializer.serializer.deserializeHeader(in, version, metadata, flag);
            if (header.isEmpty) {
                return PartitionUpdate.emptyUpdate(metadata, header.key);
            }
            assert (!header.isReversed);
            assert (header.rowEstimate >= 0);
            MutableDeletionInfo.Builder deletionBuilder = MutableDeletionInfo.builder(header.partitionDeletion, metadata.comparator, false);
            ArrayList<Row> rows = new ArrayList<Row>(header.rowEstimate);
            try (UnfilteredRowIterator partition = UnfilteredRowIteratorSerializer.serializer.deserialize(in, version, metadata, flag, header);){
                while (partition.hasNext()) {
                    Unfiltered unfiltered = (Unfiltered)partition.next();
                    if (unfiltered.kind() == Unfiltered.Kind.ROW) {
                        rows.add((Row)unfiltered);
                        continue;
                    }
                    deletionBuilder.add((RangeTombstoneMarker)unfiltered);
                }
            }
            return new PartitionUpdate(metadata, header.key, header.sHeader.columns(), header.staticRow, rows, deletionBuilder.build(), header.sHeader.stats(), true, false);
        }

        public long serializedSize(PartitionUpdate update, int version) {
            if (version < 10) {
                throw new UnsupportedOperationException("Version is " + version);
            }
            try (SliceableUnfilteredRowIterator iter = update.sliceableUnfilteredIterator();){
                long l = CFMetaData.serializer.serializedSize(update.metadata(), version) + UnfilteredRowIteratorSerializer.serializer.serializedSize(iter, version, update.rows.size());
                return l;
            }
        }
    }
}

