/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.partitions;

import com.google.common.collect.AbstractIterator;
import java.security.MessageDigest;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.WrappingPartitionIterator;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.rows.RowIterators;
import org.apache.cassandra.db.rows.WrappingRowIterator;
import org.apache.cassandra.io.util.FileUtils;

public abstract class PartitionIterators {
    public static final PartitionIterator EMPTY = new PartitionIterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public RowIterator next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
        }

        @Override
        public void close() {
        }
    };

    private PartitionIterators() {
    }

    public static RowIterator getOnlyElement(final PartitionIterator iter, SinglePartitionReadCommand<?> command) {
        RowIterator toReturn = iter.hasNext() ? (RowIterator)iter.next() : RowIterators.emptyIterator(command.metadata(), command.partitionKey(), command.clusteringIndexFilter().isReversed());
        return new WrappingRowIterator(toReturn){

            @Override
            public void close() {
                try {
                    super.close();
                }
                finally {
                    assert (!iter.hasNext());
                    iter.close();
                }
            }
        };
    }

    public static PartitionIterator concat(final List<PartitionIterator> iterators) {
        if (iterators.size() == 1) {
            return iterators.get(0);
        }
        return new PartitionIterator(){
            private int idx = 0;

            @Override
            public boolean hasNext() {
                while (this.idx < iterators.size()) {
                    if (((PartitionIterator)iterators.get(this.idx)).hasNext()) {
                        return true;
                    }
                    ++this.idx;
                }
                return false;
            }

            @Override
            public RowIterator next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return (RowIterator)((PartitionIterator)iterators.get(this.idx)).next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void close() {
                FileUtils.closeQuietly(iterators);
            }
        };
    }

    public static void digest(PartitionIterator iterator, MessageDigest digest) {
        while (iterator.hasNext()) {
            RowIterator partition = (RowIterator)iterator.next();
            Throwable throwable = null;
            try {
                RowIterators.digest(partition, digest);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (partition == null) continue;
                if (throwable != null) {
                    try {
                        partition.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                partition.close();
            }
        }
    }

    public static PartitionIterator singletonIterator(RowIterator iterator) {
        return new SingletonPartitionIterator(iterator);
    }

    public static void consume(PartitionIterator iterator) {
        while (iterator.hasNext()) {
            RowIterator partition = (RowIterator)iterator.next();
            Throwable throwable = null;
            try {
                while (partition.hasNext()) {
                    partition.next();
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (partition == null) continue;
                if (throwable != null) {
                    try {
                        partition.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                partition.close();
            }
        }
    }

    public static PartitionIterator loggingIterator(PartitionIterator iterator, final String id) {
        return new WrappingPartitionIterator(iterator){

            @Override
            public RowIterator next() {
                return RowIterators.loggingIterator(super.next(), id);
            }
        };
    }

    private static class SingletonPartitionIterator
    extends AbstractIterator<RowIterator>
    implements PartitionIterator {
        private final RowIterator iterator;
        private boolean returned;

        private SingletonPartitionIterator(RowIterator iterator) {
            this.iterator = iterator;
        }

        protected RowIterator computeNext() {
            if (this.returned) {
                return (RowIterator)this.endOfData();
            }
            this.returned = true;
            return this.iterator;
        }

        @Override
        public void close() {
            this.iterator.close();
        }
    }
}

