/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.partitions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.MutableDeletionInfo;
import org.apache.cassandra.db.PartitionColumns;
import org.apache.cassandra.db.partitions.AbstractThreadUnsafePartition;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;

public class ArrayBackedPartition
extends AbstractThreadUnsafePartition {
    private final Row staticRow;
    private final DeletionInfo deletionInfo;
    private final EncodingStats stats;

    protected ArrayBackedPartition(CFMetaData metadata, DecoratedKey partitionKey, PartitionColumns columns, Row staticRow, List<Row> rows, DeletionInfo deletionInfo, EncodingStats stats) {
        super(metadata, partitionKey, columns, rows);
        this.staticRow = staticRow;
        this.deletionInfo = deletionInfo;
        this.stats = stats;
    }

    public static ArrayBackedPartition create(UnfilteredRowIterator iterator) {
        return ArrayBackedPartition.create(iterator, 16);
    }

    public static ArrayBackedPartition create(UnfilteredRowIterator iterator, int initialRowCapacity) {
        CFMetaData metadata = iterator.metadata();
        boolean reversed = iterator.isReverseOrder();
        ArrayList<Row> rows = new ArrayList<Row>(initialRowCapacity);
        MutableDeletionInfo.Builder deletionBuilder = MutableDeletionInfo.builder(iterator.partitionLevelDeletion(), metadata.comparator, reversed);
        while (iterator.hasNext()) {
            Unfiltered unfiltered = (Unfiltered)iterator.next();
            if (unfiltered.kind() == Unfiltered.Kind.ROW) {
                rows.add((Row)unfiltered);
                continue;
            }
            deletionBuilder.add((RangeTombstoneMarker)unfiltered);
        }
        if (reversed) {
            Collections.reverse(rows);
        }
        return new ArrayBackedPartition(metadata, iterator.partitionKey(), iterator.columns(), iterator.staticRow(), rows, deletionBuilder.build(), iterator.stats());
    }

    @Override
    protected boolean canHaveShadowedData() {
        return false;
    }

    @Override
    public Row staticRow() {
        return this.staticRow;
    }

    @Override
    public DeletionInfo deletionInfo() {
        return this.deletionInfo;
    }

    @Override
    public EncodingStats stats() {
        return this.stats;
    }
}

