/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.partitions;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.PartitionColumns;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.partitions.Partition;
import org.apache.cassandra.db.rows.AbstractUnfilteredRowIterator;
import org.apache.cassandra.db.rows.BTreeBackedRow;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowAndDeletionMergeIterator;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.SliceableUnfilteredRowIterator;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.utils.SearchIterator;

public abstract class AbstractThreadUnsafePartition
implements Partition,
Iterable<Row> {
    protected final CFMetaData metadata;
    protected final DecoratedKey key;
    protected final PartitionColumns columns;
    protected final List<Row> rows;

    protected AbstractThreadUnsafePartition(CFMetaData metadata, DecoratedKey key, PartitionColumns columns, List<Row> rows) {
        this.metadata = metadata;
        this.key = key;
        this.columns = columns;
        this.rows = rows;
    }

    @Override
    public CFMetaData metadata() {
        return this.metadata;
    }

    @Override
    public DecoratedKey partitionKey() {
        return this.key;
    }

    @Override
    public DeletionTime partitionLevelDeletion() {
        return this.deletionInfo().getPartitionDeletion();
    }

    @Override
    public PartitionColumns columns() {
        return this.columns;
    }

    public abstract Row staticRow();

    protected abstract boolean canHaveShadowedData();

    public abstract DeletionInfo deletionInfo();

    public int rowCount() {
        return this.rows.size();
    }

    @Override
    public boolean isEmpty() {
        return this.deletionInfo().isLive() && this.rows.isEmpty() && this.staticRow().isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        CFMetaData metadata = this.metadata();
        sb.append(String.format("Partition[%s.%s] key=%s columns=%s%s", this.metadata().ksName, this.metadata().cfName, this.metadata().getKeyValidator().getString(this.partitionKey().getKey()), this.columns(), this.deletionInfo().isLive() ? "" : " " + this.deletionInfo()));
        if (this.staticRow() != Rows.EMPTY_STATIC_ROW) {
            sb.append("\n    ").append(this.staticRow().toString(metadata, true));
        }
        for (Row row : this) {
            sb.append("\n    ").append(row.toString(metadata, true));
        }
        return sb.toString();
    }

    @Override
    public Row getRow(Clustering clustering) {
        Row row = this.searchIterator(ColumnFilter.selection(this.columns()), false).next(clustering);
        return row == null || clustering == Clustering.STATIC_CLUSTERING && row.isEmpty() ? null : row;
    }

    @Override
    public Iterator<Row> iterator() {
        return this.rows.iterator();
    }

    @Override
    public SearchIterator<Clustering, Row> searchIterator(final ColumnFilter columns, boolean reversed) {
        final RowSearcher searcher = reversed ? new ReverseRowSearcher() : new ForwardRowSearcher();
        return new SearchIterator<Clustering, Row>(){

            @Override
            public boolean hasNext() {
                return !searcher.isDone();
            }

            @Override
            public Row next(Clustering clustering) {
                if (clustering == Clustering.STATIC_CLUSTERING) {
                    Row staticRow = AbstractThreadUnsafePartition.this.staticRow();
                    return staticRow.isEmpty() || columns.fetchedColumns().statics.isEmpty() ? Rows.EMPTY_STATIC_ROW : staticRow.filter(columns, AbstractThreadUnsafePartition.this.partitionLevelDeletion(), true, AbstractThreadUnsafePartition.this.metadata);
                }
                Row row = searcher.search(clustering);
                RangeTombstone rt = AbstractThreadUnsafePartition.this.deletionInfo().rangeCovering(clustering);
                DeletionTime activeDeletion = AbstractThreadUnsafePartition.this.partitionLevelDeletion();
                if (rt != null && rt.deletionTime().supersedes(activeDeletion)) {
                    activeDeletion = rt.deletionTime();
                }
                if (row == null) {
                    return activeDeletion.isLive() ? null : BTreeBackedRow.emptyDeletedRow(clustering, activeDeletion);
                }
                return row.filter(columns, activeDeletion, true, AbstractThreadUnsafePartition.this.metadata);
            }
        };
    }

    @Override
    public UnfilteredRowIterator unfilteredIterator() {
        return this.unfilteredIterator(ColumnFilter.all(this.metadata()), Slices.ALL, false);
    }

    @Override
    public UnfilteredRowIterator unfilteredIterator(ColumnFilter columns, Slices slices, boolean reversed) {
        return slices.makeSliceIterator(this.sliceableUnfilteredIterator(columns, reversed));
    }

    protected SliceableUnfilteredRowIterator sliceableUnfilteredIterator() {
        return this.sliceableUnfilteredIterator(ColumnFilter.all(this.metadata()), false);
    }

    protected SliceableUnfilteredRowIterator sliceableUnfilteredIterator(ColumnFilter selection, boolean reversed) {
        return new SliceableIterator(this, selection, reversed);
    }

    private int binarySearch(Clustering clustering, int fromIndex, int toIndex) {
        ClusteringComparator comparator = this.metadata().comparator;
        int low = fromIndex;
        int mid = toIndex;
        int high = mid - 1;
        int result = -1;
        while (low <= high) {
            mid = low + high >> 1;
            result = comparator.compare(clustering, this.rows.get(mid).clustering());
            if (result > 0) {
                low = mid + 1;
                continue;
            }
            if (result == 0) {
                return mid;
            }
            high = mid - 1;
        }
        return -mid - (result < 0 ? 1 : 2);
    }

    private class ReverseRowSearcher
    extends RowSearcher {
        private int nextIdx;

        private ReverseRowSearcher() {
            this.nextIdx = AbstractThreadUnsafePartition.this.rows.size() - 1;
        }

        @Override
        public boolean isDone() {
            return this.nextIdx < 0;
        }

        @Override
        public Row search(Clustering name) {
            if (this.isDone()) {
                return null;
            }
            int idx = this.search(name, 0, this.nextIdx);
            if (idx < 0) {
                this.nextIdx = -idx - 2;
                return null;
            }
            this.nextIdx = idx - 1;
            return AbstractThreadUnsafePartition.this.rows.get(idx);
        }

        @Override
        public Iterator<Row> slice(Slice slice) {
            int end;
            int start = -this.search(slice.end(), 0, this.nextIdx + 1) - 2;
            if (start < 0) {
                return Collections.emptyIterator();
            }
            this.nextIdx = end = -this.search(slice.start(), 0, start + 1) - 2;
            if (start < end) {
                return Collections.emptyIterator();
            }
            return Lists.reverse(AbstractThreadUnsafePartition.this.rows.subList(end + 1, start + 1)).iterator();
        }
    }

    private class ForwardRowSearcher
    extends RowSearcher {
        private int nextIdx;

        private ForwardRowSearcher() {
            this.nextIdx = 0;
        }

        @Override
        public boolean isDone() {
            return this.nextIdx >= AbstractThreadUnsafePartition.this.rows.size();
        }

        @Override
        public Row search(Clustering name) {
            if (this.isDone()) {
                return null;
            }
            int idx = this.search(name, this.nextIdx, AbstractThreadUnsafePartition.this.rows.size());
            if (idx < 0) {
                this.nextIdx = -idx - 1;
                return null;
            }
            this.nextIdx = idx + 1;
            return AbstractThreadUnsafePartition.this.rows.get(idx);
        }

        @Override
        public Iterator<Row> slice(Slice slice) {
            int end;
            int start = -this.search(slice.start(), this.nextIdx, AbstractThreadUnsafePartition.this.rows.size()) - 1;
            if (start >= AbstractThreadUnsafePartition.this.rows.size()) {
                return Collections.emptyIterator();
            }
            this.nextIdx = end = -this.search(slice.end(), start, AbstractThreadUnsafePartition.this.rows.size()) - 1;
            if (start >= end) {
                return Collections.emptyIterator();
            }
            return AbstractThreadUnsafePartition.this.rows.subList(start, end).iterator();
        }
    }

    private abstract class RowSearcher {
        private RowSearcher() {
        }

        public abstract boolean isDone();

        public abstract Row search(Clustering var1);

        public abstract Iterator<Row> slice(Slice var1);

        protected int search(Clustering clustering, int from, int to) {
            return AbstractThreadUnsafePartition.this.binarySearch(clustering, from, to);
        }

        protected int search(Slice.Bound bound, int from, int to) {
            return Collections.binarySearch(AbstractThreadUnsafePartition.this.rows.subList(from, to), bound, AbstractThreadUnsafePartition.this.metadata.comparator);
        }
    }

    private class SliceableIterator
    extends AbstractUnfilteredRowIterator
    implements SliceableUnfilteredRowIterator {
        private final ColumnFilter columns;
        private RowSearcher searcher;
        private Iterator<Unfiltered> iterator;

        private SliceableIterator(AbstractThreadUnsafePartition partition, ColumnFilter columns, boolean isReverseOrder) {
            super(partition.metadata(), partition.partitionKey(), partition.partitionLevelDeletion(), columns.fetchedColumns(), partition.staticRow().isEmpty() ? Rows.EMPTY_STATIC_ROW : partition.staticRow().filter(columns, partition.partitionLevelDeletion(), false, partition.metadata()), isReverseOrder, partition.stats());
            this.columns = columns;
        }

        protected Unfiltered computeNext() {
            if (this.iterator == null) {
                this.iterator = this.merge(this.isReverseOrder ? Lists.reverse(AbstractThreadUnsafePartition.this.rows).iterator() : AbstractThreadUnsafePartition.this.iterator(), AbstractThreadUnsafePartition.this.deletionInfo().rangeIterator(this.isReverseOrder()));
            }
            return this.iterator.hasNext() ? this.iterator.next() : (Unfiltered)this.endOfData();
        }

        @Override
        public Iterator<Unfiltered> slice(Slice slice) {
            if (this.searcher == null) {
                this.searcher = this.isReverseOrder() ? new ReverseRowSearcher() : new ForwardRowSearcher();
            }
            return this.merge(this.searcher.slice(slice), AbstractThreadUnsafePartition.this.deletionInfo().rangeIterator(slice, this.isReverseOrder()));
        }

        private Iterator<Unfiltered> merge(Iterator<Row> rows, Iterator<RangeTombstone> ranges) {
            return new RowAndDeletionMergeIterator(this.metadata, this.partitionKey, this.partitionLevelDeletion, this.columns, this.staticRow(), this.isReverseOrder(), this.stats(), rows, ranges, AbstractThreadUnsafePartition.this.canHaveShadowedData());
        }
    }
}

