/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.ByteBufferUtil;

public class LocalByPartionerType
extends AbstractType<ByteBuffer> {
    private final IPartitioner partitioner;

    public LocalByPartionerType(IPartitioner partitioner) {
        this.partitioner = partitioner;
    }

    public static LocalByPartionerType getInstance(TypeParser parser) {
        return new LocalByPartionerType(StorageService.getPartitioner());
    }

    @Override
    public ByteBuffer compose(ByteBuffer bytes) {
        throw new UnsupportedOperationException("You can't do this with a local partitioner.");
    }

    @Override
    public ByteBuffer decompose(ByteBuffer bytes) {
        throw new UnsupportedOperationException("You can't do this with a local partitioner.");
    }

    @Override
    public String getString(ByteBuffer bytes) {
        return ByteBufferUtil.bytesToHex(bytes);
    }

    @Override
    public ByteBuffer fromString(String source) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Term fromJSONObject(Object parsed) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toJSONString(ByteBuffer buffer, int protocolVersion) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int compare(ByteBuffer o1, ByteBuffer o2) {
        return PartitionPosition.ForKey.get(o1, this.partitioner).compareTo(PartitionPosition.ForKey.get(o2, this.partitioner));
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
        throw new IllegalStateException("You shouldn't be validating this.");
    }

    @Override
    public TypeSerializer<ByteBuffer> getSerializer() {
        throw new UnsupportedOperationException("You can't do this with a local partitioner.");
    }
}

