/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.index.keys;

import java.nio.ByteBuffer;
import java.util.Set;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.CBuilder;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.index.AbstractSimplePerColumnSecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndexSearcher;
import org.apache.cassandra.db.index.keys.KeysSearcher;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.utils.concurrent.OpOrder;

public class KeysIndex
extends AbstractSimplePerColumnSecondaryIndex {
    public static void addIndexClusteringColumns(CFMetaData.Builder indexMetadata, CFMetaData baseMetadata, ColumnDefinition cfDef) {
        indexMetadata.addClusteringColumn("partition_key", SecondaryIndex.keyComparator);
    }

    @Override
    public void indexRow(DecoratedKey key, Row row, OpOrder.Group opGroup, int nowInSec) {
        Cell cell;
        Clustering clustering;
        super.indexRow(key, row, opGroup, nowInSec);
        assert (this.baseCfs.metadata.isCompactTable());
        if (!row.isStatic() && (clustering = row.clustering()).get(0).equals(this.columnDef.name.bytes) && (cell = row.getCell(this.baseCfs.metadata.compactValueColumn())) != null && cell.isLive(nowInSec)) {
            this.insert(key.getKey(), clustering, cell, opGroup);
        }
    }

    @Override
    protected ByteBuffer getIndexedValue(ByteBuffer rowKey, Clustering clustering, ByteBuffer cellValue, CellPath path) {
        return cellValue;
    }

    @Override
    protected CBuilder buildIndexClusteringPrefix(ByteBuffer rowKey, ClusteringPrefix prefix, CellPath path) {
        CBuilder builder = CBuilder.create(this.getIndexComparator());
        builder.add(rowKey);
        return builder;
    }

    @Override
    public SecondaryIndexSearcher createSecondaryIndexSearcher(Set<ColumnDefinition> columns) {
        return new KeysSearcher(this.baseCfs.indexManager, columns);
    }

    @Override
    public void validateOptions() throws ConfigurationException {
    }
}

