/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.index.composites;

import java.nio.ByteBuffer;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.db.CBuilder;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.index.composites.CompositesIndex;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.db.rows.ComplexColumnData;
import org.apache.cassandra.db.rows.Row;

public class CompositesIndexOnCollectionValue
extends CompositesIndex {
    public static void addClusteringColumns(CFMetaData.Builder indexMetadata, CFMetaData baseMetadata, ColumnDefinition columnDef) {
        CompositesIndexOnCollectionValue.addGenericClusteringColumns(indexMetadata, baseMetadata, columnDef);
        indexMetadata.addClusteringColumn("cell_path", ((CollectionType)columnDef.type).nameComparator());
    }

    @Override
    protected AbstractType<?> getIndexKeyComparator() {
        return ((CollectionType)this.columnDef.type).valueComparator();
    }

    @Override
    protected ByteBuffer getIndexedValue(ByteBuffer rowKey, Clustering clustering, ByteBuffer cellValue, CellPath path) {
        return cellValue;
    }

    @Override
    protected CBuilder buildIndexClusteringPrefix(ByteBuffer rowKey, ClusteringPrefix prefix, CellPath path) {
        CBuilder builder = CBuilder.create(this.getIndexComparator());
        builder.add(rowKey);
        for (int i = 0; i < prefix.size(); ++i) {
            builder.add(prefix.get(i));
        }
        if (prefix.size() == this.baseCfs.metadata.clusteringColumns().size() && path != null) {
            builder.add(path.get(0));
        }
        return builder;
    }

    @Override
    public CompositesIndex.IndexedEntry decodeEntry(DecoratedKey indexedValue, Row indexEntry) {
        Clustering clustering = indexEntry.clustering();
        CBuilder builder = CBuilder.create(this.baseCfs.getComparator());
        for (int i = 0; i < this.baseCfs.getComparator().size(); ++i) {
            builder.add(clustering.get(i + 1));
        }
        return new CompositesIndex.IndexedEntry(indexedValue, clustering, indexEntry.primaryKeyLivenessInfo().timestamp(), clustering.get(0), builder.build());
    }

    @Override
    public boolean supportsOperator(Operator operator) {
        return operator == Operator.CONTAINS && !(this.columnDef.type instanceof SetType);
    }

    @Override
    public boolean isStale(Row data, ByteBuffer indexValue, int nowInSec) {
        ComplexColumnData complexData = data.getComplexColumnData(this.columnDef);
        for (Cell cell : complexData) {
            if (!cell.isLive(nowInSec) || ((CollectionType)this.columnDef.type).valueComparator().compare(indexValue, cell.value()) != 0) continue;
            return false;
        }
        return true;
    }
}

