/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.index;

import com.google.common.util.concurrent.ListenableFuture;
import java.nio.ByteBuffer;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.CBuilder;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.LivenessInfo;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.index.PerColumnSecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.db.lifecycle.Tracker;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.rows.BTreeBackedRow;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.dht.LocalPartitioner;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.concurrent.OpOrder;

public abstract class AbstractSimplePerColumnSecondaryIndex
extends PerColumnSecondaryIndex {
    protected ColumnFamilyStore indexCfs;
    protected ColumnDefinition columnDef;

    @Override
    public void init() {
        assert (this.baseCfs != null && this.columnDefs != null && this.columnDefs.size() == 1);
        this.columnDef = (ColumnDefinition)this.columnDefs.iterator().next();
        CFMetaData indexedCfMetadata = SecondaryIndex.newIndexMetadata(this.baseCfs.metadata, this.columnDef);
        this.indexCfs = ColumnFamilyStore.createColumnFamilyStore(this.baseCfs.keyspace, indexedCfMetadata.cfName, new LocalPartitioner(this.getIndexKeyComparator()), indexedCfMetadata, this.baseCfs.getTracker().loadsstables);
    }

    protected AbstractType<?> getIndexKeyComparator() {
        return this.columnDef.type;
    }

    public ColumnDefinition indexedColumn() {
        return this.columnDef;
    }

    @Override
    String indexTypeForGrouping() {
        return "_internal_";
    }

    protected Clustering makeIndexClustering(ByteBuffer rowKey, Clustering clustering, Cell cell) {
        return this.makeIndexClustering(rowKey, clustering, cell == null ? null : cell.path());
    }

    protected Clustering makeIndexClustering(ByteBuffer rowKey, Clustering clustering, CellPath path) {
        return this.buildIndexClusteringPrefix(rowKey, clustering, path).build();
    }

    protected Slice.Bound makeIndexBound(ByteBuffer rowKey, Slice.Bound bound) {
        return this.buildIndexClusteringPrefix(rowKey, bound, null).buildBound(bound.isStart(), bound.isInclusive());
    }

    protected abstract CBuilder buildIndexClusteringPrefix(ByteBuffer var1, ClusteringPrefix var2, CellPath var3);

    protected ByteBuffer getIndexedValue(ByteBuffer rowKey, Clustering clustering, Cell cell) {
        return cell == null ? this.getIndexedValue(rowKey, clustering, null, null) : this.getIndexedValue(rowKey, clustering, cell.value(), cell.path());
    }

    protected abstract ByteBuffer getIndexedValue(ByteBuffer var1, Clustering var2, ByteBuffer var3, CellPath var4);

    @Override
    public void delete(ByteBuffer rowKey, Clustering clustering, Cell cell, OpOrder.Group opGroup, int nowInSec) {
        this.deleteForCleanup(rowKey, clustering, cell, opGroup, nowInSec);
    }

    @Override
    public void deleteForCleanup(ByteBuffer rowKey, Clustering clustering, Cell cell, OpOrder.Group opGroup, int nowInSec) {
        this.delete(rowKey, clustering, cell.value(), cell.path(), new DeletionTime(cell.timestamp(), nowInSec), opGroup);
    }

    public void delete(ByteBuffer rowKey, Clustering clustering, ByteBuffer cellValue, CellPath path, DeletionTime deletion, OpOrder.Group opGroup) {
        DecoratedKey valueKey = this.getIndexKeyFor(this.getIndexedValue(rowKey, clustering, cellValue, path));
        BTreeBackedRow row = BTreeBackedRow.emptyDeletedRow(this.makeIndexClustering(rowKey, clustering, path), deletion);
        PartitionUpdate upd = PartitionUpdate.singleRowUpdate(this.indexCfs.metadata, valueKey, row);
        this.indexCfs.apply(upd, SecondaryIndexManager.nullUpdater, opGroup, null);
        if (logger.isDebugEnabled()) {
            logger.debug("removed index entry for cleaned-up value {}:{}", (Object)valueKey, (Object)upd);
        }
    }

    @Override
    public void insert(ByteBuffer rowKey, Clustering clustering, Cell cell, OpOrder.Group opGroup) {
        this.insert(rowKey, clustering, cell, LivenessInfo.create(cell.timestamp(), cell.ttl(), cell.localDeletionTime()), opGroup);
    }

    public void insert(ByteBuffer rowKey, Clustering clustering, Cell cell, LivenessInfo info, OpOrder.Group opGroup) {
        DecoratedKey valueKey = this.getIndexKeyFor(this.getIndexedValue(rowKey, clustering, cell));
        BTreeBackedRow row = BTreeBackedRow.noCellLiveRow(this.makeIndexClustering(rowKey, clustering, cell), info);
        PartitionUpdate upd = PartitionUpdate.singleRowUpdate(this.indexCfs.metadata, valueKey, row);
        if (logger.isDebugEnabled()) {
            logger.debug("applying index row {} in {}", (Object)this.indexCfs.metadata.getKeyValidator().getString(valueKey.getKey()), (Object)upd);
        }
        this.indexCfs.apply(upd, SecondaryIndexManager.nullUpdater, opGroup, null);
    }

    @Override
    public void update(ByteBuffer rowKey, Clustering clustering, Cell oldCell, Cell cell, OpOrder.Group opGroup, int nowInSec) {
        this.insert(rowKey, clustering, cell, opGroup);
        if (SecondaryIndexManager.shouldCleanupOldValue(oldCell, cell)) {
            this.delete(rowKey, clustering, oldCell, opGroup, nowInSec);
        }
    }

    @Override
    public boolean indexes(ColumnDefinition column) {
        return column.name.equals(this.columnDef.name);
    }

    @Override
    public void removeIndex(ByteBuffer columnName) {
        this.indexCfs.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceBlockingFlush() {
        ListenableFuture<?> wait;
        Tracker tracker = this.baseCfs.getTracker();
        synchronized (tracker) {
            wait = this.indexCfs.forceFlush();
        }
        FBUtilities.waitOnFuture(wait);
    }

    @Override
    public void invalidate() {
        this.indexCfs.invalidate();
    }

    @Override
    public void truncateBlocking(long truncatedAt) {
        this.indexCfs.discardSSTables(truncatedAt);
    }

    @Override
    public ColumnFamilyStore getIndexCfs() {
        return this.indexCfs;
    }

    protected ClusteringComparator getIndexComparator() {
        assert (this.indexCfs != null);
        return this.indexCfs.metadata.comparator;
    }

    @Override
    public String getIndexName() {
        return this.indexCfs.name;
    }

    @Override
    public void reload() {
        this.indexCfs.metadata.reloadIndexMetadataProperties(this.baseCfs.metadata);
        this.indexCfs.reload();
    }

    @Override
    public long estimateResultRows() {
        return this.getIndexCfs().getMeanColumns();
    }

    @Override
    public void validate(DecoratedKey partitionKey) throws InvalidRequestException {
        if (this.columnDef.kind == ColumnDefinition.Kind.PARTITION_KEY) {
            this.validateIndexedValue(this.getIndexedValue(partitionKey.getKey(), null, null, null));
        }
    }

    @Override
    public void validate(Clustering clustering) throws InvalidRequestException {
        if (this.columnDef.kind == ColumnDefinition.Kind.CLUSTERING) {
            this.validateIndexedValue(this.getIndexedValue(null, clustering, null, null));
        }
    }

    @Override
    public void validate(ByteBuffer cellValue, CellPath path) throws InvalidRequestException {
        if (!this.columnDef.isPrimaryKeyColumn()) {
            this.validateIndexedValue(this.getIndexedValue(null, null, cellValue, path));
        }
    }

    private void validateIndexedValue(ByteBuffer value) {
        if (value != null && value.remaining() >= 65535) {
            throw new InvalidRequestException(String.format("Cannot index value of size %d for index %s on %s.%s(%s) (maximum allowed size=%d)", value.remaining(), this.getIndexName(), this.baseKeyspace(), this.baseTable(), this.columnDef.name, 65535));
        }
    }

    @Override
    public String toString() {
        return String.format("%s(%s)", this.baseTable(), this.columnDef.name);
    }
}

