/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction.writers;

import java.io.File;
import java.util.Arrays;
import java.util.Set;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.compaction.writers.CompactionAwareWriter;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableWriter;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplittingSizeTieredCompactionWriter
extends CompactionAwareWriter {
    private static final Logger logger = LoggerFactory.getLogger(SplittingSizeTieredCompactionWriter.class);
    public static final long DEFAULT_SMALLEST_SSTABLE_BYTES = 50000000L;
    private final double[] ratios;
    private final long totalSize;
    private final Set<SSTableReader> allSSTables;
    private long currentBytesToWrite;
    private int currentRatioIndex = 0;

    public SplittingSizeTieredCompactionWriter(ColumnFamilyStore cfs, LifecycleTransaction txn, Set<SSTableReader> nonExpiredSSTables) {
        this(cfs, txn, nonExpiredSSTables, 50000000L);
    }

    public SplittingSizeTieredCompactionWriter(ColumnFamilyStore cfs, LifecycleTransaction txn, Set<SSTableReader> nonExpiredSSTables, long smallestSSTable) {
        super(cfs, txn, nonExpiredSSTables, false);
        this.allSSTables = txn.originals();
        this.totalSize = cfs.getExpectedCompactedFileSize(nonExpiredSSTables, txn.opType());
        double[] potentialRatios = new double[20];
        double currentRatio = 1.0;
        for (int i = 0; i < potentialRatios.length; ++i) {
            potentialRatios[i] = currentRatio /= 2.0;
        }
        int noPointIndex = 0;
        for (double ratio : potentialRatios) {
            ++noPointIndex;
            if (ratio * (double)this.totalSize < (double)smallestSSTable) break;
        }
        this.ratios = Arrays.copyOfRange(potentialRatios, 0, noPointIndex);
        File sstableDirectory = cfs.directories.getLocationForDisk(this.getWriteDirectory(Math.round((double)this.totalSize * this.ratios[this.currentRatioIndex])));
        long currentPartitionsToWrite = Math.round((double)this.estimatedTotalKeys * this.ratios[this.currentRatioIndex]);
        this.currentBytesToWrite = Math.round((double)this.totalSize * this.ratios[this.currentRatioIndex]);
        SSTableWriter writer = SSTableWriter.create(Descriptor.fromFilename(cfs.getSSTablePath(sstableDirectory)), currentPartitionsToWrite, (Long)this.minRepairedAt, cfs.metadata, cfs.partitioner, new MetadataCollector(this.allSSTables, cfs.metadata.comparator, 0), SerializationHeader.make(cfs.metadata, nonExpiredSSTables), txn);
        this.sstableWriter.switchWriter(writer);
        logger.debug("Ratios={}, expectedKeys = {}, totalSize = {}, currentPartitionsToWrite = {}, currentBytesToWrite = {}", new Object[]{this.ratios, this.estimatedTotalKeys, this.totalSize, currentPartitionsToWrite, this.currentBytesToWrite});
    }

    @Override
    public boolean append(UnfilteredRowIterator partition) {
        RowIndexEntry rie = this.sstableWriter.append(partition);
        if (this.sstableWriter.currentWriter().getOnDiskFilePointer() > this.currentBytesToWrite && this.currentRatioIndex < this.ratios.length - 1) {
            ++this.currentRatioIndex;
            this.currentBytesToWrite = Math.round((double)this.totalSize * this.ratios[this.currentRatioIndex]);
            long currentPartitionsToWrite = Math.round(this.ratios[this.currentRatioIndex] * (double)this.estimatedTotalKeys);
            File sstableDirectory = this.cfs.directories.getLocationForDisk(this.getWriteDirectory(Math.round((double)this.totalSize * this.ratios[this.currentRatioIndex])));
            SSTableWriter writer = SSTableWriter.create(Descriptor.fromFilename(this.cfs.getSSTablePath(sstableDirectory)), currentPartitionsToWrite, (Long)this.minRepairedAt, this.cfs.metadata, this.cfs.partitioner, new MetadataCollector(this.allSSTables, this.cfs.metadata.comparator, 0), SerializationHeader.make(this.cfs.metadata, this.nonExpiredSSTables), this.txn);
            this.sstableWriter.switchWriter(writer);
            logger.debug("Switching writer, currentPartitionsToWrite = {}", (Object)currentPartitionsToWrite);
        }
        return rie != null;
    }
}

