/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.LegacyLayout;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.rows.BTreeBackedRow;
import org.apache.cassandra.db.rows.RangeTombstoneBoundMarker;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.SerializationHelper;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UnfilteredDeserializer {
    private static final Logger logger = LoggerFactory.getLogger(UnfilteredDeserializer.class);
    protected final CFMetaData metadata;
    protected final DataInputPlus in;
    protected final SerializationHelper helper;

    protected UnfilteredDeserializer(CFMetaData metadata, DataInputPlus in, SerializationHelper helper) {
        this.metadata = metadata;
        this.in = in;
        this.helper = helper;
    }

    public static UnfilteredDeserializer create(CFMetaData metadata, DataInputPlus in, SerializationHeader header, SerializationHelper helper, DeletionTime partitionDeletion, boolean readAllAsDynamic) {
        if (helper.version >= 10) {
            return new CurrentDeserializer(metadata, in, header, helper);
        }
        return new OldFormatDeserializer(metadata, in, helper, partitionDeletion, readAllAsDynamic);
    }

    public abstract boolean hasNext() throws IOException;

    public abstract int compareNextTo(Slice.Bound var1) throws IOException;

    public abstract boolean nextIsRow() throws IOException;

    public abstract boolean nextIsStatic() throws IOException;

    public abstract Unfiltered readNext() throws IOException;

    public abstract void clearState() throws IOException;

    public abstract void skipNext() throws IOException;

    public static class OldFormatDeserializer
    extends UnfilteredDeserializer {
        private final boolean readAllAsDynamic;
        private boolean skipStatic;
        private boolean isDone;
        private boolean isStart = true;
        private final LegacyLayout.CellGrouper grouper;
        private LegacyLayout.LegacyAtom nextAtom;
        private boolean staticFinished;
        private LegacyLayout.LegacyAtom savedAtom;
        private final LegacyLayout.TombstoneTracker tombstoneTracker;
        private RangeTombstoneMarker closingMarker;

        private OldFormatDeserializer(CFMetaData metadata, DataInputPlus in, SerializationHelper helper, DeletionTime partitionDeletion, boolean readAllAsDynamic) {
            super(metadata, in, helper);
            this.readAllAsDynamic = readAllAsDynamic;
            this.grouper = new LegacyLayout.CellGrouper(metadata, helper);
            this.tombstoneTracker = new LegacyLayout.TombstoneTracker(metadata, partitionDeletion);
        }

        public void setSkipStatic() {
            this.skipStatic = true;
        }

        @Override
        public boolean hasNext() throws IOException {
            return this.nextAtom != null || !this.isDone && this.deserializeNextAtom();
        }

        private boolean deserializeNextAtom() throws IOException {
            if (this.staticFinished && this.savedAtom != null) {
                this.nextAtom = this.savedAtom;
                this.savedAtom = null;
                return true;
            }
            while (true) {
                this.nextAtom = LegacyLayout.readLegacyAtom(this.metadata, this.in, this.readAllAsDynamic);
                if (this.nextAtom == null) {
                    this.isDone = true;
                    return false;
                }
                if (this.tombstoneTracker.isShadowed(this.nextAtom)) {
                    this.nextAtom = null;
                    continue;
                }
                this.tombstoneTracker.update(this.nextAtom);
                if (!this.skipStatic || !this.metadata.isStaticCompactTable() || !this.nextAtom.isCell()) break;
                LegacyLayout.LegacyCell cell = this.nextAtom.asCell();
                if (!cell.name.column.isStatic()) break;
                this.nextAtom = null;
            }
            if (this.isStart) {
                this.isStart = false;
                if (!this.nextAtom.isCell()) {
                    LegacyLayout.LegacyRangeTombstone tombstone = this.nextAtom.asRangeTombstone();
                    if (tombstone.start.bound.size() == 0) {
                        this.savedAtom = tombstone;
                        this.nextAtom = LegacyLayout.readLegacyAtom(this.metadata, this.in, this.readAllAsDynamic);
                        if (this.nextAtom == null) {
                            this.nextAtom = this.savedAtom;
                            this.savedAtom = null;
                        } else if (!this.nextAtom.isStatic()) {
                            LegacyLayout.LegacyAtom atom = this.nextAtom;
                            this.nextAtom = this.savedAtom;
                            this.savedAtom = atom;
                        }
                    }
                }
            }
            return true;
        }

        private void checkReady() throws IOException {
            if (this.nextAtom == null) {
                this.hasNext();
            }
            assert (!this.isDone);
        }

        @Override
        public int compareNextTo(Slice.Bound bound) throws IOException {
            this.checkReady();
            int cmp = this.metadata.comparator.compare(this.nextAtom.clustering(), bound);
            if (cmp != 0 || this.nextAtom.isCell() || !this.nextIsRow()) {
                return cmp;
            }
            return bound.isStart() ? 1 : -1;
        }

        @Override
        public boolean nextIsRow() throws IOException {
            this.checkReady();
            if (this.nextAtom.isCell()) {
                return true;
            }
            LegacyLayout.LegacyRangeTombstone tombstone = this.nextAtom.asRangeTombstone();
            return tombstone.isCollectionTombstone() || tombstone.isRowDeletion(this.metadata);
        }

        @Override
        public boolean nextIsStatic() throws IOException {
            this.checkReady();
            return this.nextAtom.isStatic();
        }

        @Override
        public Unfiltered readNext() throws IOException {
            if (!this.nextIsRow()) {
                LegacyLayout.LegacyRangeTombstone tombstone = this.nextAtom.asRangeTombstone();
                if (this.closingMarker == null) {
                    throw new UnsupportedOperationException();
                }
                this.closingMarker = new RangeTombstoneBoundMarker(tombstone.stop.bound, tombstone.deletionTime);
                return new RangeTombstoneBoundMarker(tombstone.start.bound, tombstone.deletionTime);
            }
            LegacyLayout.CellGrouper grouper = this.nextAtom.isStatic() ? LegacyLayout.CellGrouper.staticGrouper(this.metadata, this.helper) : this.grouper;
            grouper.reset();
            grouper.addAtom(this.nextAtom);
            while (this.deserializeNextAtom() && grouper.addAtom(this.nextAtom)) {
            }
            this.staticFinished = true;
            return grouper.getRow();
        }

        @Override
        public void skipNext() throws IOException {
            this.readNext();
        }

        @Override
        public void clearState() {
            this.isDone = false;
            this.nextAtom = null;
        }
    }

    private static class CurrentDeserializer
    extends UnfilteredDeserializer {
        private final ClusteringPrefix.Deserializer clusteringDeserializer;
        private final SerializationHeader header;
        private int nextFlags;
        private boolean isReady;
        private boolean isDone;
        private final Row.Builder builder;

        private CurrentDeserializer(CFMetaData metadata, DataInputPlus in, SerializationHeader header, SerializationHelper helper) {
            super(metadata, in, helper);
            this.header = header;
            this.clusteringDeserializer = new ClusteringPrefix.Deserializer(metadata.comparator, in, header);
            this.builder = BTreeBackedRow.sortedBuilder(helper.fetchedRegularColumns(header));
        }

        @Override
        public boolean hasNext() throws IOException {
            if (this.isReady) {
                return true;
            }
            this.prepareNext();
            return !this.isDone;
        }

        private void prepareNext() throws IOException {
            if (this.isDone) {
                return;
            }
            this.nextFlags = this.in.readUnsignedByte();
            if (UnfilteredSerializer.isEndOfPartition(this.nextFlags)) {
                this.isDone = true;
                this.isReady = false;
                return;
            }
            this.clusteringDeserializer.prepare(this.nextFlags);
            this.isReady = true;
        }

        @Override
        public int compareNextTo(Slice.Bound bound) throws IOException {
            if (!this.isReady) {
                this.prepareNext();
            }
            assert (!this.isDone);
            return this.clusteringDeserializer.compareNextTo(bound);
        }

        @Override
        public boolean nextIsRow() throws IOException {
            if (!this.isReady) {
                this.prepareNext();
            }
            return UnfilteredSerializer.kind(this.nextFlags) == Unfiltered.Kind.ROW;
        }

        @Override
        public boolean nextIsStatic() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Unfiltered readNext() throws IOException {
            this.isReady = false;
            if (UnfilteredSerializer.kind(this.nextFlags) == Unfiltered.Kind.RANGE_TOMBSTONE_MARKER) {
                RangeTombstone.Bound bound = this.clusteringDeserializer.deserializeNextBound();
                return UnfilteredSerializer.serializer.deserializeMarkerBody(this.in, this.header, bound);
            }
            this.builder.newRow(this.clusteringDeserializer.deserializeNextClustering());
            return UnfilteredSerializer.serializer.deserializeRowBody(this.in, this.header, this.helper, this.nextFlags, this.builder);
        }

        @Override
        public void skipNext() throws IOException {
            this.isReady = false;
            ClusteringPrefix.Kind kind = this.clusteringDeserializer.skipNext();
            if (UnfilteredSerializer.kind(this.nextFlags) == Unfiltered.Kind.RANGE_TOMBSTONE_MARKER) {
                UnfilteredSerializer.serializer.skipMarkerBody(this.in, this.header, kind.isBoundary());
            } else {
                UnfilteredSerializer.serializer.skipRowBody(this.in, this.header, this.nextFlags);
            }
        }

        @Override
        public void clearState() {
            this.isReady = false;
            this.isDone = false;
        }
    }
}

