/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.io.DataInput;
import java.io.IOError;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.Columns;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.LivenessInfo;
import org.apache.cassandra.db.MutableDeletionInfo;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.RangeTombstoneList;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.UnknownColumnException;
import org.apache.cassandra.db.context.CounterContext;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.ColumnToCollectionType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.partitions.ArrayBackedPartition;
import org.apache.cassandra.db.rows.BTreeBackedRow;
import org.apache.cassandra.db.rows.BufferCell;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowAndDeletionMergeIterator;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.SerializationHelper;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.MergeIterator;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LegacyLayout {
    private static final Logger logger = LoggerFactory.getLogger(LegacyLayout.class);
    public static final int MAX_CELL_NAME_LENGTH = 65535;
    private static final int DELETION_MASK = 1;
    private static final int EXPIRATION_MASK = 2;
    private static final int COUNTER_MASK = 4;
    private static final int COUNTER_UPDATE_MASK = 8;
    private static final int RANGE_TOMBSTONE_MASK = 16;

    private LegacyLayout() {
    }

    public static AbstractType<?> makeLegacyComparator(CFMetaData metadata) {
        ClusteringComparator comparator = metadata.comparator;
        if (!metadata.isCompound()) {
            assert (comparator.size() == 1);
            return comparator.subtype(0);
        }
        boolean hasCollections = metadata.hasCollectionColumns() || metadata.hasDroppedCollectionColumns();
        ArrayList types = new ArrayList(comparator.size() + (metadata.isDense() ? 0 : 1) + (hasCollections ? 1 : 0));
        types.addAll(comparator.subtypes());
        if (!metadata.isDense()) {
            types.add(UTF8Type.instance);
            if (hasCollections) {
                HashMap<ByteBuffer, CollectionType> defined = new HashMap<ByteBuffer, CollectionType>();
                for (CFMetaData.DroppedColumn droppedColumn : metadata.getDroppedColumns().values()) {
                    if (!(droppedColumn.type instanceof CollectionType) || !droppedColumn.type.isMultiCell()) continue;
                    defined.put(ByteBufferUtil.bytes(droppedColumn.name), (CollectionType)droppedColumn.type);
                }
                for (ColumnDefinition columnDefinition : metadata.partitionColumns()) {
                    if (!(columnDefinition.type instanceof CollectionType) || !columnDefinition.type.isMultiCell()) continue;
                    defined.put(columnDefinition.name.bytes, (CollectionType)columnDefinition.type);
                }
                types.add(ColumnToCollectionType.getInstance(defined));
            }
        }
        return CompositeType.getInstance(types);
    }

    public static LegacyCellName decodeCellName(CFMetaData metadata, ByteBuffer superColumnName, ByteBuffer cellname) throws UnknownColumnException {
        assert (cellname != null);
        if (metadata.isSuper()) {
            assert (superColumnName != null);
            return LegacyLayout.decodeForSuperColumn(metadata, new Clustering(superColumnName), cellname);
        }
        assert (superColumnName == null);
        return LegacyLayout.decodeCellName(metadata, cellname);
    }

    private static LegacyCellName decodeForSuperColumn(CFMetaData metadata, Clustering clustering, ByteBuffer subcol) {
        ColumnDefinition def = metadata.getColumnDefinition(subcol);
        if (def != null) {
            return new LegacyCellName(clustering, def, null);
        }
        def = metadata.compactValueColumn();
        assert (def != null && def.type instanceof MapType);
        return new LegacyCellName(clustering, def, subcol);
    }

    public static LegacyCellName decodeCellName(CFMetaData metadata, ByteBuffer cellname) throws UnknownColumnException {
        return LegacyLayout.decodeCellName(metadata, cellname, false);
    }

    public static LegacyCellName decodeCellName(CFMetaData metadata, ByteBuffer cellname, boolean readAllAsDynamic) throws UnknownColumnException {
        ByteBuffer column;
        Clustering clustering = LegacyLayout.decodeClustering(metadata, cellname);
        if (metadata.isSuper()) {
            return LegacyLayout.decodeForSuperColumn(metadata, clustering, CompositeType.extractComponent(cellname, 1));
        }
        if (metadata.isDense() || metadata.isCompactTable() && readAllAsDynamic) {
            return new LegacyCellName(clustering, metadata.compactValueColumn(), null);
        }
        ByteBuffer byteBuffer = column = metadata.isCompound() ? CompositeType.extractComponent(cellname, metadata.comparator.size()) : cellname;
        if (column == null) {
            if (metadata.partitionColumns().isEmpty()) {
                return new LegacyCellName(clustering, null, null);
            }
            throw new IllegalArgumentException("No column name component found in cell name");
        }
        if (!column.hasRemaining()) {
            return new LegacyCellName(clustering, null, null);
        }
        ColumnDefinition def = metadata.getColumnDefinition(column);
        if (def == null) {
            if (metadata.isCompactTable()) {
                return new LegacyCellName(new Clustering(column), metadata.compactValueColumn(), null);
            }
            throw new UnknownColumnException(metadata, column);
        }
        ByteBuffer collectionElement = metadata.isCompound() ? CompositeType.extractComponent(cellname, metadata.comparator.size() + 1) : null;
        return new LegacyCellName(def.isStatic() ? Clustering.STATIC_CLUSTERING : clustering, def, collectionElement);
    }

    public static LegacyBound decodeBound(CFMetaData metadata, ByteBuffer bound, boolean isStart) {
        List<ByteBuffer> components;
        if (!bound.hasRemaining()) {
            return isStart ? LegacyBound.BOTTOM : LegacyBound.TOP;
        }
        List<ByteBuffer> list = components = metadata.isCompound() ? CompositeType.splitName(bound) : Collections.singletonList(bound);
        assert (components.size() <= metadata.comparator.size() || !metadata.isCompactTable() && components.size() == metadata.comparator.size() + 1);
        List<ByteBuffer> prefix = components.size() <= metadata.comparator.size() ? components : components.subList(0, metadata.comparator.size());
        Slice.Bound sb = Slice.Bound.create(isStart ? ClusteringPrefix.Kind.INCL_START_BOUND : ClusteringPrefix.Kind.INCL_END_BOUND, prefix.toArray(new ByteBuffer[prefix.size()]));
        ColumnDefinition collectionName = components.size() == metadata.comparator.size() + 1 ? metadata.getColumnDefinition(components.get(metadata.comparator.size())) : null;
        return new LegacyBound(sb, metadata.isCompound() && CompositeType.isStaticName(bound), collectionName);
    }

    public static ByteBuffer encodeCellName(CFMetaData metadata, Clustering clustering, ByteBuffer columnName, ByteBuffer collectionElement) {
        boolean isStatic;
        boolean bl = isStatic = clustering == Clustering.STATIC_CLUSTERING;
        if (!metadata.isCompound()) {
            if (isStatic) {
                return columnName;
            }
            assert (clustering.size() == 1);
            return clustering.get(0);
        }
        int clusteringSize = metadata.comparator.size();
        int size = clusteringSize + (metadata.isDense() ? 0 : 1) + (collectionElement == null ? 0 : 1);
        ByteBuffer[] values = new ByteBuffer[size];
        for (int i = 0; i < clusteringSize; ++i) {
            if (isStatic) {
                values[i] = ByteBufferUtil.EMPTY_BYTE_BUFFER;
                continue;
            }
            ByteBuffer v = clustering.get(i);
            if (v == null) {
                return CompositeType.build(Arrays.copyOfRange(values, 0, i));
            }
            values[i] = v;
        }
        if (!metadata.isDense()) {
            values[clusteringSize] = columnName;
        }
        if (collectionElement != null) {
            values[clusteringSize + 1] = collectionElement;
        }
        return CompositeType.build(isStatic, values);
    }

    public static Clustering decodeClustering(CFMetaData metadata, ByteBuffer value) {
        int csize = metadata.comparator.size();
        if (csize == 0) {
            return Clustering.EMPTY;
        }
        if (metadata.isCompound() && CompositeType.isStaticName(value)) {
            return Clustering.STATIC_CLUSTERING;
        }
        List<ByteBuffer> components = metadata.isCompound() ? CompositeType.splitName(value) : Collections.singletonList(value);
        return new Clustering(components.subList(0, Math.min(csize, components.size())).toArray(new ByteBuffer[csize]));
    }

    public static ByteBuffer encodeClustering(CFMetaData metadata, Clustering clustering) {
        if (!metadata.isCompound()) {
            assert (clustering.size() == 1);
            return clustering.get(0);
        }
        ByteBuffer[] values = new ByteBuffer[clustering.size()];
        for (int i = 0; i < clustering.size(); ++i) {
            values[i] = clustering.get(i);
        }
        return CompositeType.build(values);
    }

    public static Pair<DeletionInfo, Iterator<LegacyCell>> fromUnfilteredRowIterator(UnfilteredRowIterator iterator) {
        ArrayBackedPartition partition = ArrayBackedPartition.create(iterator);
        DeletionInfo info = partition.deletionInfo();
        Iterator<LegacyCell> cells = LegacyLayout.fromRowIterator(partition.metadata(), partition.iterator(), partition.staticRow());
        return Pair.create(info, cells);
    }

    public static UnfilteredRowIterator toUnfilteredRowIterator(CFMetaData metadata, DecoratedKey key, DeletionInfo delInfo, Iterator<LegacyCell> cells) {
        SerializationHelper helper = new SerializationHelper(metadata, 0, SerializationHelper.Flag.LOCAL);
        return LegacyLayout.toUnfilteredRowIterator(metadata, key, LegacyDeletionInfo.from(delInfo), cells, false, helper);
    }

    public static UnfilteredRowIterator onWireCellstoUnfilteredRowIterator(CFMetaData metadata, DecoratedKey key, LegacyDeletionInfo delInfo, Iterator<LegacyCell> cells, boolean reversed, SerializationHelper helper) {
        if (metadata.isStaticCompactTable() || reversed) {
            ArrayList l = new ArrayList();
            Iterators.addAll(l, cells);
            Collections.sort(l, LegacyLayout.legacyCellComparator(metadata, reversed));
            cells = l.iterator();
        }
        return LegacyLayout.toUnfilteredRowIterator(metadata, key, delInfo, cells, reversed, helper);
    }

    private static UnfilteredRowIterator toUnfilteredRowIterator(CFMetaData metadata, DecoratedKey key, LegacyDeletionInfo delInfo, Iterator<LegacyCell> cells, boolean reversed, SerializationHelper helper) {
        PeekingIterator iter = Iterators.peekingIterator(cells);
        Row staticRow = iter.hasNext() && ((LegacyCell)iter.peek()).name.clustering == Clustering.STATIC_CLUSTERING ? LegacyLayout.getNextRow(CellGrouper.staticGrouper(metadata, helper), (PeekingIterator<? extends LegacyAtom>)iter) : Rows.EMPTY_STATIC_ROW;
        Iterator<Row> rows = LegacyLayout.convertToRows(new CellGrouper(metadata, helper), (Iterator<LegacyCell>)iter, delInfo);
        Iterator<RangeTombstone> ranges = delInfo.deletionInfo.rangeIterator(reversed);
        return new RowAndDeletionMergeIterator(metadata, key, delInfo.deletionInfo.getPartitionDeletion(), ColumnFilter.all(metadata), staticRow, reversed, EncodingStats.NO_STATS, rows, ranges, true);
    }

    public static Row extractStaticColumns(CFMetaData metadata, DataInputPlus in, Columns statics) throws IOException {
        LegacyAtom atom;
        assert (!statics.isEmpty());
        assert (metadata.isCompactTable());
        if (metadata.isSuper()) {
            throw new UnsupportedOperationException();
        }
        HashSet<ByteBuffer> columnsToFetch = new HashSet<ByteBuffer>(statics.columnCount());
        for (ColumnDefinition column : statics) {
            columnsToFetch.add(column.name.bytes);
        }
        Row.Builder builder = BTreeBackedRow.unsortedBuilder(statics, FBUtilities.nowInSeconds());
        builder.newRow(Clustering.STATIC_CLUSTERING);
        boolean foundOne = false;
        while ((atom = LegacyLayout.readLegacyAtom(metadata, in, false)) != null) {
            if (atom.isCell()) {
                LegacyCell cell = atom.asCell();
                if (!columnsToFetch.contains(cell.name.encode(metadata))) continue;
                foundOne = true;
                builder.addCell(new BufferCell(cell.name.column, cell.timestamp, cell.ttl, cell.localDeletionTime, cell.value, null));
                continue;
            }
            LegacyRangeTombstone tombstone = atom.asRangeTombstone();
            throw new UnsupportedOperationException();
        }
        return foundOne ? builder.build() : Rows.EMPTY_STATIC_ROW;
    }

    private static Row getNextRow(CellGrouper grouper, PeekingIterator<? extends LegacyAtom> cells) {
        if (!cells.hasNext()) {
            return null;
        }
        grouper.reset();
        while (cells.hasNext() && grouper.addAtom((LegacyAtom)cells.peek())) {
            cells.next();
        }
        return grouper.getRow();
    }

    private static Iterator<LegacyAtom> asLegacyAtomIterator(Iterator<? extends LegacyAtom> iter) {
        return iter;
    }

    private static Iterator<Row> convertToRows(final CellGrouper grouper, Iterator<LegacyCell> cells, LegacyDeletionInfo delInfo) {
        MergeIterator.Reducer<LegacyAtom, LegacyAtom> reducer = new MergeIterator.Reducer<LegacyAtom, LegacyAtom>(){
            private LegacyAtom atom;

            @Override
            public void reduce(int idx, LegacyAtom current) {
                assert (this.atom == null);
                this.atom = current;
            }

            @Override
            protected LegacyAtom getReduced() {
                return this.atom;
            }

            @Override
            protected void onKeyChange() {
                this.atom = null;
            }
        };
        List<Iterator> iterators = Arrays.asList(LegacyLayout.asLegacyAtomIterator(cells), LegacyLayout.asLegacyAtomIterator(delInfo.inRowRangeTombstones()));
        MergeIterator<LegacyAtom, LegacyAtom> merged = MergeIterator.get(iterators, LegacyLayout.legacyAtomComparator(grouper.metadata), reducer);
        final PeekingIterator atoms = Iterators.peekingIterator(merged);
        return new AbstractIterator<Row>(){

            protected Row computeNext() {
                if (!atoms.hasNext()) {
                    return (Row)this.endOfData();
                }
                return LegacyLayout.getNextRow(grouper, (PeekingIterator<? extends LegacyAtom>)atoms);
            }
        };
    }

    public static Iterator<LegacyCell> fromRowIterator(RowIterator iterator) {
        return LegacyLayout.fromRowIterator(iterator.metadata(), iterator, iterator.staticRow());
    }

    public static Iterator<LegacyCell> fromRowIterator(final CFMetaData metadata, final Iterator<Row> iterator, final Row staticRow) {
        return new AbstractIterator<LegacyCell>(){
            private Iterator<LegacyCell> currentRow;
            {
                this.currentRow = staticRow.isEmpty() ? Collections.emptyIterator() : LegacyLayout.fromRow(metadata, staticRow);
            }

            protected LegacyCell computeNext() {
                if (this.currentRow.hasNext()) {
                    return this.currentRow.next();
                }
                if (!iterator.hasNext()) {
                    return (LegacyCell)this.endOfData();
                }
                this.currentRow = LegacyLayout.fromRow(metadata, (Row)iterator.next());
                return this.computeNext();
            }
        };
    }

    private static Iterator<LegacyCell> fromRow(final CFMetaData metadata, final Row row) {
        return new AbstractIterator<LegacyCell>(){
            private final Iterator<Cell> cells;
            private boolean hasReturnedRowMarker;
            {
                this.cells = row.cells().iterator();
                this.hasReturnedRowMarker = metadata.isCompactTable();
            }

            protected LegacyCell computeNext() {
                if (!this.hasReturnedRowMarker) {
                    this.hasReturnedRowMarker = true;
                    LegacyCellName cellName = new LegacyCellName(row.clustering(), null, null);
                    LivenessInfo info = row.primaryKeyLivenessInfo();
                    return new LegacyCell(LegacyCell.Kind.REGULAR, cellName, ByteBufferUtil.EMPTY_BYTE_BUFFER, info.timestamp(), info.localExpirationTime(), info.ttl());
                }
                if (!this.cells.hasNext()) {
                    return (LegacyCell)this.endOfData();
                }
                Cell cell = this.cells.next();
                return LegacyLayout.makeLegacyCell(row.clustering(), cell);
            }
        };
    }

    private static LegacyCell makeLegacyCell(Clustering clustering, Cell cell) {
        LegacyCell.Kind kind = cell.isCounterCell() ? LegacyCell.Kind.COUNTER : (cell.isTombstone() ? LegacyCell.Kind.DELETED : (cell.isExpiring() ? LegacyCell.Kind.EXPIRING : LegacyCell.Kind.REGULAR));
        CellPath path = cell.path();
        assert (path == null || path.size() == 1);
        LegacyCellName name = new LegacyCellName(clustering, cell.column(), path == null ? null : path.get(0));
        return new LegacyCell(kind, name, cell.value(), cell.timestamp(), cell.localDeletionTime(), cell.ttl());
    }

    public static RowIterator toRowIterator(CFMetaData metadata, DecoratedKey key, Iterator<LegacyCell> cells, int nowInSec) {
        SerializationHelper helper = new SerializationHelper(metadata, 0, SerializationHelper.Flag.LOCAL);
        return UnfilteredRowIterators.filter(LegacyLayout.toUnfilteredRowIterator(metadata, key, LegacyDeletionInfo.live(), cells, false, helper), nowInSec);
    }

    public static Comparator<LegacyCell> legacyCellComparator(CFMetaData metadata) {
        return LegacyLayout.legacyCellComparator(metadata, false);
    }

    public static Comparator<LegacyCell> legacyCellComparator(CFMetaData metadata, boolean reversed) {
        final Comparator<LegacyCellName> cellNameComparator = LegacyLayout.legacyCellNameComparator(metadata, reversed);
        return new Comparator<LegacyCell>(){

            @Override
            public int compare(LegacyCell cell1, LegacyCell cell2) {
                LegacyCellName c1 = cell1.name;
                LegacyCellName c2 = cell2.name;
                int c = cellNameComparator.compare(c1, c2);
                if (c != 0) {
                    return c;
                }
                if (cell1.timestamp != cell2.timestamp) {
                    return cell1.timestamp < cell2.timestamp ? -1 : 1;
                }
                if (cell1.localDeletionTime != cell2.localDeletionTime) {
                    return cell1.localDeletionTime < cell2.localDeletionTime ? -1 : 1;
                }
                return cell1.value.compareTo(cell2.value);
            }
        };
    }

    public static Comparator<LegacyCellName> legacyCellNameComparator(final CFMetaData metadata, final boolean reversed) {
        return new Comparator<LegacyCellName>(){

            @Override
            public int compare(LegacyCellName c1, LegacyCellName c2) {
                if (c1.clustering == Clustering.STATIC_CLUSTERING) {
                    if (c2.clustering != Clustering.STATIC_CLUSTERING) {
                        return -1;
                    }
                } else {
                    if (c2.clustering == Clustering.STATIC_CLUSTERING) {
                        return 1;
                    }
                    int c = metadata.comparator.compare(c1.clustering, c2.clustering);
                    if (c != 0) {
                        return reversed ? -c : c;
                    }
                }
                if (c1.column != c2.column) {
                    if (c1.column == null) {
                        return -1;
                    }
                    if (c2.column == null) {
                        return 1;
                    }
                    assert (c1.column.isRegular() || c1.column.isStatic());
                    assert (c2.column.isRegular() || c2.column.isStatic());
                    if (c1.column.kind != c2.column.kind) {
                        return c1.column.isStatic() ? -1 : 1;
                    }
                    AbstractType<?> cmp = metadata.getColumnDefinitionNameComparator(c1.column.kind);
                    int c = cmp.compare(c1.column.name.bytes, c2.column.name.bytes);
                    if (c != 0) {
                        return c;
                    }
                }
                assert (c1.collectionElement == null == (c2.collectionElement == null));
                if (c1.collectionElement != null) {
                    AbstractType<?> colCmp = ((CollectionType)c1.column.type).nameComparator();
                    return colCmp.compare(c1.collectionElement, c2.collectionElement);
                }
                return 0;
            }
        };
    }

    private static Comparator<LegacyAtom> legacyAtomComparator(CFMetaData metadata) {
        return (o1, o2) -> {
            int clusteringComparison;
            ClusteringPrefix c1 = o1.clustering();
            ClusteringPrefix c2 = o2.clustering();
            if (c1.size() != c2.size() || o1.isCell() == o2.isCell()) {
                clusteringComparison = cFMetaData.comparator.compare(c1, c2);
            } else {
                LegacyRangeTombstone rt = o1.isCell() ? o2.asRangeTombstone() : o1.asRangeTombstone();
                int n = clusteringComparison = rt.isCollectionTombstone() ? 0 : cFMetaData.comparator.compare(c1, c2);
            }
            if (clusteringComparison != 0) {
                return clusteringComparison;
            }
            if (o1.isCell()) {
                LegacyCell cell1 = o1.asCell();
                if (o2.isCell()) {
                    LegacyCell cell2 = o2.asCell();
                    if (cell1.name.column == null) {
                        return cell2.name.column == null ? 0 : -1;
                    }
                    return cell2.name.column == null ? 1 : cell1.name.column.compareTo(cell2.name.column);
                }
                LegacyRangeTombstone rt2 = o2.asRangeTombstone();
                assert (rt2.isCollectionTombstone());
                if (cell1.name.column == null) {
                    return -1;
                }
                int cmp = cell1.name.column.compareTo(rt2.start.collectionName);
                return cmp == 0 ? 1 : cmp;
            }
            assert (o2.isCell());
            LegacyCell cell2 = o2.asCell();
            LegacyRangeTombstone rt1 = o1.asRangeTombstone();
            assert (rt1.isCollectionTombstone());
            if (cell2.name.column == null) {
                return 1;
            }
            int cmp = rt1.start.collectionName.compareTo(cell2.name.column);
            return cmp == 0 ? -1 : cmp;
        };
    }

    public static LegacyAtom readLegacyAtom(CFMetaData metadata, DataInputPlus in, boolean readAllAsDynamic) throws IOException {
        ByteBuffer cellname;
        while ((cellname = ByteBufferUtil.readWithShortLength(in)).hasRemaining()) {
            try {
                int b = in.readUnsignedByte();
                return (b & 0x10) != 0 ? LegacyLayout.readLegacyRangeTombstoneBody(metadata, in, cellname) : LegacyLayout.readLegacyCellBody(metadata, in, cellname, b, SerializationHelper.Flag.LOCAL, readAllAsDynamic);
            }
            catch (UnknownColumnException e) {
                if ($assertionsDisabled || metadata.ksName.equals("system") || metadata.getDroppedColumnDefinition(cellname) != null) continue;
                throw new AssertionError((Object)e.getMessage());
            }
            break;
        }
        return null;
    }

    public static LegacyCell readLegacyCell(CFMetaData metadata, DataInput in, SerializationHelper.Flag flag) throws IOException, UnknownColumnException {
        ByteBuffer cellname = ByteBufferUtil.readWithShortLength(in);
        int b = in.readUnsignedByte();
        return LegacyLayout.readLegacyCellBody(metadata, in, cellname, b, flag, false);
    }

    public static LegacyCell readLegacyCellBody(CFMetaData metadata, DataInput in, ByteBuffer cellname, int mask, SerializationHelper.Flag flag, boolean readAllAsDynamic) throws IOException, UnknownColumnException {
        if ((mask & 4) != 0) {
            in.readLong();
            long ts = in.readLong();
            ByteBuffer value = ByteBufferUtil.readWithLength(in);
            if (flag == SerializationHelper.Flag.FROM_REMOTE || flag == SerializationHelper.Flag.LOCAL && CounterContext.instance().shouldClearLocal(value)) {
                value = CounterContext.instance().clearAllLocal(value);
            }
            return new LegacyCell(LegacyCell.Kind.COUNTER, LegacyLayout.decodeCellName(metadata, cellname, readAllAsDynamic), value, ts, Integer.MAX_VALUE, 0);
        }
        if ((mask & 2) != 0) {
            int ttl = in.readInt();
            int expiration = in.readInt();
            long ts = in.readLong();
            ByteBuffer value = ByteBufferUtil.readWithLength(in);
            return new LegacyCell(LegacyCell.Kind.EXPIRING, LegacyLayout.decodeCellName(metadata, cellname, readAllAsDynamic), value, ts, expiration, ttl);
        }
        long ts = in.readLong();
        ByteBuffer value = ByteBufferUtil.readWithLength(in);
        LegacyCellName name = LegacyLayout.decodeCellName(metadata, cellname, readAllAsDynamic);
        return (mask & 8) != 0 ? new LegacyCell(LegacyCell.Kind.COUNTER, name, CounterContext.instance().createLocal(ByteBufferUtil.toLong(value)), ts, Integer.MAX_VALUE, 0) : ((mask & 1) == 0 ? new LegacyCell(LegacyCell.Kind.REGULAR, name, value, ts, Integer.MAX_VALUE, 0) : new LegacyCell(LegacyCell.Kind.DELETED, name, ByteBufferUtil.EMPTY_BYTE_BUFFER, ts, ByteBufferUtil.toInt(value), 0));
    }

    public static LegacyRangeTombstone readLegacyRangeTombstone(CFMetaData metadata, DataInputPlus in) throws IOException {
        ByteBuffer boundname = ByteBufferUtil.readWithShortLength(in);
        in.readUnsignedByte();
        return LegacyLayout.readLegacyRangeTombstoneBody(metadata, in, boundname);
    }

    public static LegacyRangeTombstone readLegacyRangeTombstoneBody(CFMetaData metadata, DataInputPlus in, ByteBuffer boundname) throws IOException {
        LegacyBound min = LegacyLayout.decodeBound(metadata, boundname, true);
        LegacyBound max = LegacyLayout.decodeBound(metadata, ByteBufferUtil.readWithShortLength(in), false);
        DeletionTime dt = DeletionTime.serializer.deserialize(in);
        return new LegacyRangeTombstone(min, max, dt);
    }

    public static Iterator<LegacyCell> deserializeCells(final CFMetaData metadata, final DataInput in, final SerializationHelper.Flag flag, final int size) {
        return new AbstractIterator<LegacyCell>(){
            private int i = 0;

            protected LegacyCell computeNext() {
                if (this.i >= size) {
                    return (LegacyCell)this.endOfData();
                }
                ++this.i;
                try {
                    return LegacyLayout.readLegacyCell(metadata, in, flag);
                }
                catch (UnknownColumnException e) {
                    if (metadata.ksName.equals("system") || metadata.getDroppedColumnDefinition(e.columnName) != null) {
                        return this.computeNext();
                    }
                    throw new IOError(e);
                }
                catch (IOException e) {
                    throw new IOError(e);
                }
            }
        };
    }

    public static class TombstoneTracker {
        private final CFMetaData metadata;
        private final DeletionTime partitionDeletion;
        private final List<LegacyRangeTombstone> openTombstones = new ArrayList<LegacyRangeTombstone>();

        public TombstoneTracker(CFMetaData metadata, DeletionTime partitionDeletion) {
            this.metadata = metadata;
            this.partitionDeletion = partitionDeletion;
        }

        public void update(LegacyAtom atom) {
            if (atom.isCell()) {
                if (this.openTombstones.isEmpty()) {
                    return;
                }
                Iterator<LegacyRangeTombstone> iter = this.openTombstones.iterator();
                while (iter.hasNext()) {
                    LegacyRangeTombstone tombstone = iter.next();
                    if (this.metadata.comparator.compare(atom.clustering(), tombstone.stop.bound) < 0) continue;
                    iter.remove();
                }
            }
            LegacyRangeTombstone tombstone = atom.asRangeTombstone();
            if (tombstone.deletionTime.supersedes(this.partitionDeletion) && !tombstone.isRowDeletion(this.metadata) && !tombstone.isCollectionTombstone()) {
                this.openTombstones.add(tombstone);
            }
        }

        public boolean isShadowed(LegacyAtom atom) {
            long timestamp;
            long l = timestamp = atom.isCell() ? atom.asCell().timestamp : atom.asRangeTombstone().deletionTime.markedForDeleteAt();
            if (this.partitionDeletion.deletes(timestamp)) {
                return true;
            }
            for (LegacyRangeTombstone tombstone : this.openTombstones) {
                if (!tombstone.deletionTime.deletes(timestamp)) continue;
                return true;
            }
            return false;
        }
    }

    public static class LegacyDeletionInfo {
        public static final Serializer serializer = new Serializer();
        public final DeletionInfo deletionInfo;
        private final List<LegacyRangeTombstone> inRowTombstones;

        private LegacyDeletionInfo(DeletionInfo deletionInfo, List<LegacyRangeTombstone> inRowTombstones) {
            this.deletionInfo = deletionInfo;
            this.inRowTombstones = inRowTombstones;
        }

        public static LegacyDeletionInfo from(DeletionInfo info) {
            return new LegacyDeletionInfo(info, Collections.emptyList());
        }

        public static LegacyDeletionInfo live() {
            return LegacyDeletionInfo.from(DeletionInfo.LIVE);
        }

        public Iterator<LegacyRangeTombstone> inRowRangeTombstones() {
            return this.inRowTombstones.iterator();
        }

        public static class Serializer {
            public void serialize(CFMetaData metadata, LegacyDeletionInfo info, DataOutputPlus out, int version) throws IOException {
                throw new UnsupportedOperationException();
            }

            public LegacyDeletionInfo deserialize(CFMetaData metadata, DataInputPlus in, int version) throws IOException {
                DeletionTime topLevel = DeletionTime.serializer.deserialize(in);
                int rangeCount = in.readInt();
                if (rangeCount == 0) {
                    return LegacyDeletionInfo.from(new MutableDeletionInfo(topLevel));
                }
                RangeTombstoneList ranges = new RangeTombstoneList(metadata.comparator, rangeCount);
                ArrayList<LegacyRangeTombstone> inRowTombsones = new ArrayList<LegacyRangeTombstone>();
                for (int i = 0; i < rangeCount; ++i) {
                    LegacyBound start = LegacyLayout.decodeBound(metadata, ByteBufferUtil.readWithShortLength(in), true);
                    LegacyBound end = LegacyLayout.decodeBound(metadata, ByteBufferUtil.readWithShortLength(in), false);
                    int delTime = in.readInt();
                    long markedAt = in.readLong();
                    LegacyRangeTombstone tombstone = new LegacyRangeTombstone(start, end, new DeletionTime(markedAt, delTime));
                    if (tombstone.isCollectionTombstone() || tombstone.isRowDeletion(metadata)) {
                        inRowTombsones.add(tombstone);
                        continue;
                    }
                    ranges.add(start.bound, end.bound, markedAt, delTime);
                }
                return new LegacyDeletionInfo(new MutableDeletionInfo(topLevel, ranges), inRowTombsones);
            }

            public long serializedSize(CFMetaData metadata, LegacyDeletionInfo info, TypeSizes typeSizes, int version) {
                throw new UnsupportedOperationException();
            }
        }
    }

    public static class LegacyRangeTombstone
    implements LegacyAtom {
        public final LegacyBound start;
        public final LegacyBound stop;
        public final DeletionTime deletionTime;

        private LegacyRangeTombstone(LegacyBound start, LegacyBound stop, DeletionTime deletionTime) {
            if (start.collectionName == null != (stop.collectionName == null)) {
                if (start.collectionName == null) {
                    stop = new LegacyBound(stop.bound, stop.isStatic, null);
                } else {
                    start = new LegacyBound(start.bound, start.isStatic, null);
                }
            } else if (!Objects.equals(start.collectionName, stop.collectionName)) {
                start = new LegacyBound(start.bound, start.isStatic, null);
                stop = new LegacyBound(stop.bound, stop.isStatic, null);
            }
            this.start = start;
            this.stop = stop;
            this.deletionTime = deletionTime;
        }

        @Override
        public ClusteringPrefix clustering() {
            return this.start.bound;
        }

        @Override
        public boolean isCell() {
            return false;
        }

        @Override
        public boolean isStatic() {
            return this.start.isStatic;
        }

        @Override
        public LegacyCell asCell() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LegacyRangeTombstone asRangeTombstone() {
            return this;
        }

        public boolean isCollectionTombstone() {
            return this.start.collectionName != null;
        }

        public boolean isRowDeletion(CFMetaData metadata) {
            if (this.start.collectionName != null || this.stop.collectionName != null || this.start.bound.size() != metadata.comparator.size() || this.stop.bound.size() != metadata.comparator.size()) {
                return false;
            }
            for (int i = 0; i < this.start.bound.size(); ++i) {
                if (Objects.equals(this.start.bound.get(i), this.stop.bound.get(i))) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return String.format("RT(%s-%s, %s)", this.start, this.stop, this.deletionTime);
        }
    }

    public static class LegacyCell
    implements LegacyAtom {
        public final Kind kind;
        public final LegacyCellName name;
        public final ByteBuffer value;
        public final long timestamp;
        public final int localDeletionTime;
        public final int ttl;

        private LegacyCell(Kind kind, LegacyCellName name, ByteBuffer value, long timestamp, int localDeletionTime, int ttl) {
            this.kind = kind;
            this.name = name;
            this.value = value;
            this.timestamp = timestamp;
            this.localDeletionTime = localDeletionTime;
            this.ttl = ttl;
        }

        public static LegacyCell regular(CFMetaData metadata, ByteBuffer superColumnName, ByteBuffer name, ByteBuffer value, long timestamp) throws UnknownColumnException {
            return new LegacyCell(Kind.REGULAR, LegacyLayout.decodeCellName(metadata, superColumnName, name), value, timestamp, Integer.MAX_VALUE, 0);
        }

        public static LegacyCell expiring(CFMetaData metadata, ByteBuffer superColumnName, ByteBuffer name, ByteBuffer value, long timestamp, int ttl, int nowInSec) throws UnknownColumnException {
            return new LegacyCell(Kind.EXPIRING, LegacyLayout.decodeCellName(metadata, superColumnName, name), value, timestamp, nowInSec + ttl, ttl);
        }

        public static LegacyCell tombstone(CFMetaData metadata, ByteBuffer superColumnName, ByteBuffer name, long timestamp, int nowInSec) throws UnknownColumnException {
            return new LegacyCell(Kind.DELETED, LegacyLayout.decodeCellName(metadata, superColumnName, name), ByteBufferUtil.EMPTY_BYTE_BUFFER, timestamp, nowInSec, 0);
        }

        public static LegacyCell counter(CFMetaData metadata, ByteBuffer superColumnName, ByteBuffer name, long value) throws UnknownColumnException {
            ByteBuffer counterValue = CounterContext.instance().createLocal(value);
            return LegacyCell.counter(LegacyLayout.decodeCellName(metadata, superColumnName, name), counterValue);
        }

        public static LegacyCell counter(LegacyCellName name, ByteBuffer value) {
            return new LegacyCell(Kind.COUNTER, name, value, FBUtilities.timestampMicros(), Integer.MAX_VALUE, 0);
        }

        @Override
        public ClusteringPrefix clustering() {
            return this.name.clustering;
        }

        @Override
        public boolean isStatic() {
            return this.name.clustering == Clustering.STATIC_CLUSTERING;
        }

        @Override
        public boolean isCell() {
            return true;
        }

        @Override
        public LegacyCell asCell() {
            return this;
        }

        @Override
        public LegacyRangeTombstone asRangeTombstone() {
            throw new UnsupportedOperationException();
        }

        public boolean isCounter() {
            return this.kind == Kind.COUNTER;
        }

        public boolean isExpiring() {
            return this.kind == Kind.EXPIRING;
        }

        public boolean isTombstone() {
            return this.kind == Kind.DELETED;
        }

        public boolean isLive(int nowInSec) {
            if (this.isTombstone()) {
                return false;
            }
            if (this.isExpiring()) {
                return nowInSec < this.localDeletionTime;
            }
            return true;
        }

        public String toString() {
            return String.format("LegacyCell(%s, name=%s, v=%s, ts=%s, ldt=%s, ttl=%s)", new Object[]{this.kind, this.name, ByteBufferUtil.bytesToHex(this.value), this.timestamp, this.localDeletionTime, this.ttl});
        }

        public static enum Kind {
            REGULAR,
            EXPIRING,
            DELETED,
            COUNTER;

        }
    }

    public static interface LegacyAtom {
        public boolean isCell();

        public ClusteringPrefix clustering();

        public boolean isStatic();

        public LegacyCell asCell();

        public LegacyRangeTombstone asRangeTombstone();
    }

    public static class LegacyBound {
        public static final LegacyBound BOTTOM = new LegacyBound(Slice.Bound.BOTTOM, false, null);
        public static final LegacyBound TOP = new LegacyBound(Slice.Bound.TOP, false, null);
        public final Slice.Bound bound;
        public final boolean isStatic;
        public final ColumnDefinition collectionName;

        private LegacyBound(Slice.Bound bound, boolean isStatic, ColumnDefinition collectionName) {
            this.bound = bound;
            this.isStatic = isStatic;
            this.collectionName = collectionName;
        }

        public Clustering getAsClustering(CFMetaData metadata) {
            assert (this.bound.size() == metadata.comparator.size());
            ByteBuffer[] values = new ByteBuffer[this.bound.size()];
            for (int i = 0; i < this.bound.size(); ++i) {
                values[i] = this.bound.get(i);
            }
            return new Clustering(values);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append((Object)this.bound.kind()).append('(');
            for (int i = 0; i < this.bound.size(); ++i) {
                sb.append(i > 0 ? ":" : "").append(this.bound.get(i) == null ? "null" : ByteBufferUtil.bytesToHex(this.bound.get(i)));
            }
            sb.append(')');
            return String.format("Bound(%s, collection=%s)", sb.toString(), this.collectionName == null ? "null" : this.collectionName.name);
        }
    }

    public static class LegacyCellName {
        public final Clustering clustering;
        public final ColumnDefinition column;
        public final ByteBuffer collectionElement;

        private LegacyCellName(Clustering clustering, ColumnDefinition column, ByteBuffer collectionElement) {
            this.clustering = clustering;
            this.column = column;
            this.collectionElement = collectionElement;
        }

        public ByteBuffer encode(CFMetaData metadata) {
            return LegacyLayout.encodeCellName(metadata, this.clustering, this.column == null ? ByteBufferUtil.EMPTY_BYTE_BUFFER : this.column.name.bytes, this.collectionElement);
        }

        public ByteBuffer superColumnSubName() {
            assert (this.collectionElement != null);
            return this.collectionElement;
        }

        public ByteBuffer superColumnName() {
            return this.clustering.get(0);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.clustering.size(); ++i) {
                sb.append(i > 0 ? ":" : "").append(this.clustering.get(i) == null ? "null" : ByteBufferUtil.bytesToHex(this.clustering.get(i)));
            }
            return String.format("Cellname(clustering=%s, column=%s, collElt=%s)", sb.toString(), this.column == null ? "null" : this.column.name, this.collectionElement == null ? "null" : ByteBufferUtil.bytesToHex(this.collectionElement));
        }
    }

    public static class CellGrouper {
        public final CFMetaData metadata;
        private final boolean isStatic;
        private final SerializationHelper helper;
        private Row.Builder builder;
        private Clustering clustering;
        private LegacyRangeTombstone rowDeletion;
        private LegacyRangeTombstone collectionDeletion;

        public CellGrouper(CFMetaData metadata, SerializationHelper helper) {
            this(metadata, helper, false);
        }

        private CellGrouper(CFMetaData metadata, SerializationHelper helper, boolean isStatic) {
            this.metadata = metadata;
            this.isStatic = isStatic;
            this.helper = helper;
            this.builder = BTreeBackedRow.sortedBuilder(isStatic ? metadata.partitionColumns().statics : metadata.partitionColumns().regulars);
        }

        public static CellGrouper staticGrouper(CFMetaData metadata, SerializationHelper helper) {
            return new CellGrouper(metadata, helper, true);
        }

        public void reset() {
            this.clustering = null;
            this.rowDeletion = null;
            this.collectionDeletion = null;
        }

        public boolean addAtom(LegacyAtom atom) {
            return atom.isCell() ? this.addCell(atom.asCell()) : this.addRangeTombstone(atom.asRangeTombstone());
        }

        public boolean addCell(LegacyCell cell) {
            if (this.clustering == null) {
                this.clustering = cell.name.clustering;
                assert (!this.isStatic || this.clustering == Clustering.STATIC_CLUSTERING);
                this.builder.newRow(this.clustering);
            } else if (!this.clustering.equals(cell.name.clustering)) {
                return false;
            }
            if (this.rowDeletion != null && this.rowDeletion.deletionTime.deletes(cell.timestamp)) {
                return true;
            }
            ColumnDefinition column = cell.name.column;
            if (column == null) {
                assert (!cell.value.hasRemaining());
                this.builder.addPrimaryKeyLivenessInfo(LivenessInfo.create(cell.timestamp, cell.ttl, cell.localDeletionTime));
            } else {
                if (this.collectionDeletion != null && this.collectionDeletion.start.collectionName.name.equals(column.name) && this.collectionDeletion.deletionTime.deletes(cell.timestamp)) {
                    return true;
                }
                if (this.helper.includes(column)) {
                    BufferCell c;
                    CellPath path = null;
                    if (column.isComplex()) {
                        this.helper.startOfComplexColumn(column);
                        CellPath cellPath = path = cell.name.collectionElement == null ? null : CellPath.create(cell.name.collectionElement);
                        if (!this.helper.includes(path)) {
                            return true;
                        }
                    }
                    if (!this.helper.isDropped(c = new BufferCell(column, cell.timestamp, cell.ttl, cell.localDeletionTime, cell.value, path), column.isComplex())) {
                        this.builder.addCell(c);
                    }
                    if (column.isComplex()) {
                        this.helper.endOfComplexColumn();
                    }
                }
            }
            return true;
        }

        public boolean addRangeTombstone(LegacyRangeTombstone tombstone) {
            if (tombstone.isRowDeletion(this.metadata)) {
                if (this.clustering != null) {
                    return false;
                }
                this.clustering = tombstone.start.getAsClustering(this.metadata);
                this.builder.newRow(this.clustering);
                this.builder.addRowDeletion(tombstone.deletionTime);
                this.rowDeletion = tombstone;
                return true;
            }
            if (tombstone.isCollectionTombstone()) {
                if (this.clustering == null) {
                    this.clustering = tombstone.start.getAsClustering(this.metadata);
                    this.builder.newRow(this.clustering);
                } else if (!this.clustering.equals(tombstone.start.getAsClustering(this.metadata))) {
                    return false;
                }
                this.builder.addComplexDeletion(tombstone.start.collectionName, tombstone.deletionTime);
                if (this.rowDeletion == null || tombstone.deletionTime.supersedes(this.rowDeletion.deletionTime)) {
                    this.collectionDeletion = tombstone;
                }
                return true;
            }
            return false;
        }

        public Row getRow() {
            return this.builder.build();
        }
    }
}

