/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.ByteBufferUtil;

public class Columns
implements Iterable<ColumnDefinition> {
    public static final Serializer serializer = new Serializer();
    public static final Columns NONE = new Columns(new ColumnDefinition[0], 0);
    public final ColumnDefinition[] columns;
    public final int complexIdx;

    private Columns(ColumnDefinition[] columns, int complexIdx) {
        assert (complexIdx <= columns.length);
        this.columns = columns;
        this.complexIdx = complexIdx;
    }

    private Columns(ColumnDefinition[] columns) {
        this(columns, Columns.findFirstComplexIdx(columns));
    }

    public static Columns of(ColumnDefinition c) {
        ColumnDefinition[] columns = new ColumnDefinition[]{c};
        return new Columns(columns, c.isComplex() ? 0 : 1);
    }

    public static Columns from(Set<ColumnDefinition> s) {
        Object[] columns = s.toArray(new ColumnDefinition[s.size()]);
        Arrays.sort(columns);
        return new Columns((ColumnDefinition[])columns, Columns.findFirstComplexIdx((ColumnDefinition[])columns));
    }

    private static int findFirstComplexIdx(ColumnDefinition[] columns) {
        for (int i = 0; i < columns.length; ++i) {
            if (!columns[i].isComplex()) continue;
            return i;
        }
        return columns.length;
    }

    public boolean isEmpty() {
        return this.columns.length == 0;
    }

    public int simpleColumnCount() {
        return this.complexIdx;
    }

    public int complexColumnCount() {
        return this.columns.length - this.complexIdx;
    }

    public int columnCount() {
        return this.columns.length;
    }

    public boolean hasSimple() {
        return this.complexIdx > 0;
    }

    public boolean hasComplex() {
        return this.complexIdx < this.columns.length;
    }

    public ColumnDefinition getSimple(int i) {
        return this.columns[i];
    }

    public ColumnDefinition getComplex(int i) {
        return this.columns[this.complexIdx + i];
    }

    public int simpleIdx(ColumnDefinition c, int from) {
        assert (!c.isComplex());
        for (int i = from; i < this.complexIdx; ++i) {
            if (this.columns[i].name != c.name) continue;
            return i;
        }
        return -1;
    }

    public int complexIdx(ColumnDefinition c, int from) {
        assert (c.isComplex());
        for (int i = this.complexIdx + from; i < this.columns.length; ++i) {
            if (this.columns[i].name != c.name) continue;
            return i - this.complexIdx;
        }
        return -1;
    }

    public boolean contains(ColumnDefinition c) {
        return c.isComplex() ? this.complexIdx(c, 0) >= 0 : this.simpleIdx(c, 0) >= 0;
    }

    public boolean hasCounters() {
        int i;
        for (i = 0; i < this.complexIdx; ++i) {
            if (!this.columns[i].type.isCounter()) continue;
            return true;
        }
        for (i = this.complexIdx; i < this.columns.length; ++i) {
            if (!(this.columns[i].type instanceof MapType) || !((MapType)this.columns[i].type).valueComparator().isCounter()) continue;
            return true;
        }
        return false;
    }

    public Columns mergeTo(Columns other) {
        if (this == other || other == NONE) {
            return this;
        }
        if (this == NONE) {
            return other;
        }
        int i = 0;
        int j = 0;
        int size = 0;
        while (i < this.columns.length && j < other.columns.length) {
            ++size;
            int cmp = this.columns[i].compareTo(other.columns[j]);
            if (cmp == 0) {
                ++i;
                ++j;
                continue;
            }
            if (cmp < 0) {
                ++i;
                continue;
            }
            ++j;
        }
        if (i == size && j == size) {
            return i == this.columns.length ? other : this;
        }
        ColumnDefinition[] result = new ColumnDefinition[size += i == this.columns.length ? other.columns.length - j : this.columns.length - i];
        i = 0;
        j = 0;
        for (int k = 0; k < size; ++k) {
            int cmp;
            int n = i >= this.columns.length ? 1 : (cmp = j >= other.columns.length ? -1 : this.columns[i].compareTo(other.columns[j]));
            if (cmp == 0) {
                result[k] = this.columns[i];
                ++i;
                ++j;
                continue;
            }
            result[k] = cmp < 0 ? this.columns[i++] : other.columns[j++];
        }
        return new Columns(result, Columns.findFirstComplexIdx(result));
    }

    public boolean contains(Columns other) {
        if (other.columns.length > this.columns.length) {
            return false;
        }
        int j = 0;
        int cmp = 0;
        for (ColumnDefinition def : other.columns) {
            while (j < this.columns.length && (cmp = this.columns[j].compareTo(def)) < 0) {
                ++j;
            }
            if (j >= this.columns.length || cmp > 0) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public Iterator<ColumnDefinition> simpleColumns() {
        return new ColumnIterator(0, this.complexIdx);
    }

    public Iterator<ColumnDefinition> complexColumns() {
        return new ColumnIterator(this.complexIdx, this.columns.length);
    }

    @Override
    public Iterator<ColumnDefinition> iterator() {
        return Iterators.forArray((Object[])this.columns);
    }

    public Iterator<ColumnDefinition> selectOrderIterator() {
        return new AbstractIterator<ColumnDefinition>(){
            private int regular;
            private int complex;
            {
                this.complex = Columns.this.complexIdx;
            }

            protected ColumnDefinition computeNext() {
                if (this.complex >= Columns.this.columns.length) {
                    return this.regular >= Columns.this.complexIdx ? (ColumnDefinition)this.endOfData() : Columns.this.columns[this.regular++];
                }
                if (this.regular >= Columns.this.complexIdx) {
                    return Columns.this.columns[this.complex++];
                }
                return Columns.this.columns[this.regular].name.compareTo(Columns.this.columns[this.complex].name) < 0 ? Columns.this.columns[this.regular++] : Columns.this.columns[this.complex++];
            }
        };
    }

    public Columns without(ColumnDefinition column) {
        int idx;
        int n = idx = column.isComplex() ? this.complexIdx(column, 0) : this.simpleIdx(column, 0);
        if (idx < 0) {
            return this;
        }
        int realIdx = column.isComplex() ? this.complexIdx + idx : idx;
        ColumnDefinition[] newColumns = new ColumnDefinition[this.columns.length - 1];
        System.arraycopy(this.columns, 0, newColumns, 0, realIdx);
        System.arraycopy(this.columns, realIdx + 1, newColumns, realIdx, newColumns.length - realIdx);
        return new Columns(newColumns);
    }

    public Predicate<ColumnDefinition> inOrderInclusionTester() {
        return new Predicate<ColumnDefinition>(){
            private int i = 0;

            @Override
            public boolean test(ColumnDefinition column) {
                while (this.i < Columns.this.columns.length) {
                    int cmp = column.compareTo(Columns.this.columns[this.i]);
                    if (cmp < 0) {
                        return false;
                    }
                    ++this.i;
                    if (cmp != 0) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public void digest(MessageDigest digest) {
        for (ColumnDefinition c : this) {
            digest.update(c.name.bytes.duplicate());
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof Columns)) {
            return false;
        }
        Columns that = (Columns)other;
        return this.complexIdx == that.complexIdx && Arrays.equals(this.columns, that.columns);
    }

    public int hashCode() {
        return Objects.hash(this.complexIdx, Arrays.hashCode(this.columns));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (ColumnDefinition def : this) {
            if (first) {
                first = false;
            } else {
                sb.append(" ");
            }
            sb.append(def.name);
        }
        return sb.toString();
    }

    public static class Serializer {
        public void serialize(Columns columns, DataOutputPlus out) throws IOException {
            out.writeVInt(columns.columnCount());
            for (ColumnDefinition column : columns) {
                ByteBufferUtil.writeWithVIntLength(column.name.bytes, out);
            }
        }

        public long serializedSize(Columns columns) {
            long size = TypeSizes.sizeofVInt(columns.columnCount());
            for (ColumnDefinition column : columns) {
                size += (long)ByteBufferUtil.serializedSizeWithVIntLength(column.name.bytes);
            }
            return size;
        }

        public Columns deserialize(DataInputPlus in, CFMetaData metadata) throws IOException {
            int length = (int)in.readVInt();
            ColumnDefinition[] columns = new ColumnDefinition[length];
            for (int i = 0; i < length; ++i) {
                ByteBuffer name = ByteBufferUtil.readWithVIntLength(in);
                ColumnDefinition column = metadata.getColumnDefinition(name);
                if (column == null && (column = metadata.getDroppedColumnDefinition(name)) == null) {
                    throw new RuntimeException("Unknown column " + UTF8Type.instance.getString(name) + " during deserialization");
                }
                columns[i] = column;
            }
            return new Columns(columns);
        }
    }

    private class ColumnIterator
    extends AbstractIterator<ColumnDefinition> {
        private final int to;
        private int idx;

        private ColumnIterator(int from, int to) {
            this.idx = from;
            this.to = to;
        }

        protected ColumnDefinition computeNext() {
            if (this.idx >= this.to) {
                return (ColumnDefinition)this.endOfData();
            }
            return Columns.this.columns[this.idx++];
        }
    }
}

