/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.AbstractClusteringPrefix;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.memory.AbstractAllocator;

public class Clustering
extends AbstractClusteringPrefix {
    public static final Serializer serializer = new Serializer();
    public static final Clustering STATIC_CLUSTERING = new Clustering(EMPTY_VALUES_ARRAY){

        @Override
        public ClusteringPrefix.Kind kind() {
            return ClusteringPrefix.Kind.STATIC_CLUSTERING;
        }

        @Override
        public String toString(CFMetaData metadata) {
            return "STATIC";
        }
    };
    public static final Clustering EMPTY = new Clustering(EMPTY_VALUES_ARRAY){

        @Override
        public String toString(CFMetaData metadata) {
            return "EMPTY";
        }
    };

    public Clustering(ByteBuffer ... values) {
        super(ClusteringPrefix.Kind.CLUSTERING, values);
    }

    @Override
    public ClusteringPrefix.Kind kind() {
        return ClusteringPrefix.Kind.CLUSTERING;
    }

    public Clustering copy(AbstractAllocator allocator) {
        if (this.size() == 0) {
            return this;
        }
        ByteBuffer[] newValues = new ByteBuffer[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            newValues[i] = this.values[i] == null ? null : allocator.clone(this.values[i]);
        }
        return new Clustering(newValues);
    }

    @Override
    public String toString(CFMetaData metadata) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            ColumnDefinition c = metadata.clusteringColumns().get(i);
            sb.append(i == 0 ? "" : ", ").append(c.name).append('=').append(this.get(i) == null ? "null" : c.type.getString(this.get(i)));
        }
        return sb.toString();
    }

    public String toCQLString(CFMetaData metadata) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            ColumnDefinition c = metadata.clusteringColumns().get(i);
            sb.append(i == 0 ? "" : ", ").append(c.type.getString(this.get(i)));
        }
        return sb.toString();
    }

    public static class Serializer {
        public void serialize(Clustering clustering, DataOutputPlus out, int version, List<AbstractType<?>> types) throws IOException {
            assert (clustering != STATIC_CLUSTERING) : "We should never serialize a static clustering";
            ClusteringPrefix.serializer.serializeValuesWithoutSize(clustering, out, version, types);
        }

        public long serializedSize(Clustering clustering, int version, List<AbstractType<?>> types) {
            return ClusteringPrefix.serializer.valuesWithoutSizeSerializedSize(clustering, version, types);
        }

        public Clustering deserialize(DataInputPlus in, int version, List<AbstractType<?>> types) throws IOException {
            if (types.isEmpty()) {
                return EMPTY;
            }
            ByteBuffer[] values = ClusteringPrefix.serializer.deserializeValuesWithoutSize(in, types.size(), version, types);
            return new Clustering(values);
        }
    }
}

