/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.cql3.statements.PropertyDefinitions;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.schema.KeyspaceParams;

public class KeyspaceAttributes
extends PropertyDefinitions {
    private static final Set<String> keywords = ImmutableSet.of((Object)KeyspaceParams.Option.DURABLE_WRITES.toString(), (Object)KeyspaceParams.Option.REPLICATION.toString());
    private static final Set<String> obsoleteKeywords = ImmutableSet.of();

    public void validate() throws SyntaxException {
        this.validate(keywords, obsoleteKeywords);
    }

    public String getReplicationStrategyClass() {
        return this.getAllReplicationOptions().get(KeyspaceParams.Replication.CLASS);
    }

    public Map<String, String> getReplicationOptions() throws SyntaxException {
        HashMap<String, String> replication = new HashMap<String, String>(this.getAllReplicationOptions());
        replication.remove(KeyspaceParams.Replication.CLASS);
        return replication;
    }

    public Map<String, String> getAllReplicationOptions() throws SyntaxException {
        Map<String, String> replication = this.getMap(KeyspaceParams.Option.REPLICATION.toString());
        return replication == null ? Collections.emptyMap() : replication;
    }

    public KeyspaceParams asNewKeyspaceParams() {
        boolean durableWrites = this.getBoolean(KeyspaceParams.Option.DURABLE_WRITES.toString(), true);
        return KeyspaceParams.create(durableWrites, this.getAllReplicationOptions());
    }

    public KeyspaceParams asAlteredKeyspaceParams(KeyspaceParams previous) {
        boolean durableWrites = this.getBoolean(KeyspaceParams.Option.DURABLE_WRITES.toString(), previous.durableWrites);
        KeyspaceParams.Replication replication = this.getReplicationStrategyClass() == null ? previous.replication : KeyspaceParams.Replication.fromMap(this.getAllReplicationOptions());
        return new KeyspaceParams(durableWrites, replication);
    }
}

