/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.statements.CFPropDefs;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.transport.Event;

public class AlterMaterializedViewStatement
extends SchemaAlteringStatement {
    private final CFPropDefs cfProps;

    public AlterMaterializedViewStatement(CFName name, CFPropDefs cfProps) {
        super(name);
        this.cfProps = cfProps;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        state.hasColumnFamilyAccess(this.keyspace(), this.columnFamily(), Permission.ALTER);
    }

    @Override
    public void validate(ClientState state) {
    }

    @Override
    public boolean announceMigration(boolean isLocalOnly) throws RequestValidationException {
        CFMetaData meta = ThriftValidation.validateColumnFamily(this.keyspace(), this.columnFamily());
        if (!meta.isMaterializedView()) {
            throw new InvalidRequestException("Cannot use ALTER MATERIALIZED VIEW on Table");
        }
        CFMetaData cfm = meta.copy();
        if (this.cfProps == null) {
            throw new InvalidRequestException("ALTER MATERIALIZED VIEW WITH invoked, but no parameters found");
        }
        this.cfProps.validate();
        this.cfProps.applyToCFMetadata(cfm);
        MigrationManager.announceColumnFamilyUpdate(cfm, false, isLocalOnly);
        return true;
    }

    public String toString() {
        return String.format("AlterMaterializedViewStatement(name=%s)", this.cfName);
    }

    @Override
    public Event.SchemaChange changeEvent() {
        return new Event.SchemaChange(Event.SchemaChange.Change.UPDATED, Event.SchemaChange.Target.TABLE, this.keyspace(), this.columnFamily());
    }
}

