/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.restrictions;

import com.google.common.collect.BoundType;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableSet;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.restrictions.ForwardingPrimaryKeyRestrictions;
import org.apache.cassandra.cql3.restrictions.PrimaryKeyRestrictions;
import org.apache.cassandra.cql3.restrictions.Restriction;
import org.apache.cassandra.cql3.restrictions.TokenRestriction;
import org.apache.cassandra.cql3.statements.Bound;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.service.StorageService;

final class TokenFilter
extends ForwardingPrimaryKeyRestrictions {
    private PrimaryKeyRestrictions restrictions;
    private TokenRestriction tokenRestriction;
    private static final IPartitioner partitioner = StorageService.getPartitioner();

    @Override
    protected PrimaryKeyRestrictions getDelegate() {
        return this.restrictions;
    }

    @Override
    public boolean isOnToken() {
        return this.restrictions.size() < this.tokenRestriction.size();
    }

    public TokenFilter(PrimaryKeyRestrictions restrictions, TokenRestriction tokenRestriction) {
        this.restrictions = restrictions;
        this.tokenRestriction = tokenRestriction;
    }

    @Override
    public List<ByteBuffer> values(QueryOptions options) throws InvalidRequestException {
        return this.filter(this.restrictions.values(options), options);
    }

    @Override
    public NavigableSet<Clustering> valuesAsClustering(QueryOptions options) throws InvalidRequestException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PrimaryKeyRestrictions mergeWith(Restriction restriction) throws InvalidRequestException {
        if (restriction.isOnToken()) {
            return new TokenFilter(this.restrictions, (TokenRestriction)this.tokenRestriction.mergeWith(restriction));
        }
        return new TokenFilter(super.mergeWith(restriction), this.tokenRestriction);
    }

    @Override
    public boolean isInclusive(Bound bound) {
        return this.tokenRestriction.isInclusive(bound);
    }

    @Override
    public boolean hasBound(Bound b) {
        return this.tokenRestriction.hasBound(b);
    }

    @Override
    public List<ByteBuffer> bounds(Bound bound, QueryOptions options) throws InvalidRequestException {
        return this.tokenRestriction.bounds(bound, options);
    }

    @Override
    public NavigableSet<Slice.Bound> boundsAsClustering(Bound bound, QueryOptions options) throws InvalidRequestException {
        return this.tokenRestriction.boundsAsClustering(bound, options);
    }

    private List<ByteBuffer> filter(List<ByteBuffer> values, QueryOptions options) throws InvalidRequestException {
        RangeSet<Token> rangeSet = this.tokenRestriction.isSlice() ? TokenFilter.toRangeSet(this.tokenRestriction, options) : TokenFilter.toRangeSet(this.tokenRestriction.values(options));
        return TokenFilter.filterWithRangeSet(rangeSet, values);
    }

    private static List<ByteBuffer> filterWithRangeSet(RangeSet<Token> tokens, List<ByteBuffer> values) {
        ArrayList<ByteBuffer> remaining = new ArrayList<ByteBuffer>();
        for (ByteBuffer value : values) {
            Token token = partitioner.getToken(value);
            if (!tokens.contains((Comparable)token)) continue;
            remaining.add(value);
        }
        return remaining;
    }

    private static RangeSet<Token> toRangeSet(List<ByteBuffer> buffers) {
        ImmutableRangeSet.Builder builder = ImmutableRangeSet.builder();
        for (ByteBuffer buffer : buffers) {
            builder.add(Range.singleton((Comparable)TokenFilter.deserializeToken(buffer)));
        }
        return builder.build();
    }

    private static RangeSet<Token> toRangeSet(TokenRestriction slice, QueryOptions options) throws InvalidRequestException {
        if (slice.hasBound(Bound.START)) {
            Token start = TokenFilter.deserializeToken((ByteBuffer)slice.bounds(Bound.START, options).get(0));
            BoundType startBoundType = TokenFilter.toBoundType(slice.isInclusive(Bound.START));
            if (slice.hasBound(Bound.END)) {
                BoundType endBoundType = TokenFilter.toBoundType(slice.isInclusive(Bound.END));
                Token end = TokenFilter.deserializeToken((ByteBuffer)slice.bounds(Bound.END, options).get(0));
                if (start.equals(end) && (BoundType.OPEN == startBoundType || BoundType.OPEN == endBoundType)) {
                    return ImmutableRangeSet.of();
                }
                if (start.compareTo(end) <= 0) {
                    return ImmutableRangeSet.of((Range)Range.range((Comparable)start, (BoundType)startBoundType, (Comparable)end, (BoundType)endBoundType));
                }
                return ImmutableRangeSet.builder().add(Range.upTo((Comparable)end, (BoundType)endBoundType)).add(Range.downTo((Comparable)start, (BoundType)startBoundType)).build();
            }
            return ImmutableRangeSet.of((Range)Range.downTo((Comparable)start, (BoundType)startBoundType));
        }
        Token end = TokenFilter.deserializeToken((ByteBuffer)slice.bounds(Bound.END, options).get(0));
        return ImmutableRangeSet.of((Range)Range.upTo((Comparable)end, (BoundType)TokenFilter.toBoundType(slice.isInclusive(Bound.END))));
    }

    private static Token deserializeToken(ByteBuffer buffer) {
        return partitioner.getTokenFactory().fromByteArray(buffer);
    }

    private static BoundType toBoundType(boolean inclusive) {
        return inclusive ? BoundType.CLOSED : BoundType.OPEN;
    }
}

