/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ProtocolVersion;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.cql3.functions.UDFunction;

public abstract class JavaUDF {
    private final DataType returnDataType;
    private final DataType[] argDataTypes;

    protected JavaUDF(DataType returnDataType, DataType[] argDataTypes) {
        this.returnDataType = returnDataType;
        this.argDataTypes = argDataTypes;
    }

    protected abstract ByteBuffer executeImpl(int var1, List<ByteBuffer> var2);

    protected Object compose(int protocolVersion, int argIndex, ByteBuffer value) {
        return UDFunction.compose(this.argDataTypes, protocolVersion, argIndex, value);
    }

    protected ByteBuffer decompose(int protocolVersion, Object value) {
        return UDFunction.decompose(this.returnDataType, protocolVersion, value);
    }

    protected float compose_float(int protocolVersion, int argIndex, ByteBuffer value) {
        assert (value != null && value.remaining() > 0);
        return ((Float)DataType.cfloat().deserialize(value, ProtocolVersion.fromInt((int)protocolVersion))).floatValue();
    }

    protected double compose_double(int protocolVersion, int argIndex, ByteBuffer value) {
        assert (value != null && value.remaining() > 0);
        return (Double)DataType.cdouble().deserialize(value, ProtocolVersion.fromInt((int)protocolVersion));
    }

    protected byte compose_byte(int protocolVersion, int argIndex, ByteBuffer value) {
        assert (value != null && value.remaining() > 0);
        return (Byte)DataType.tinyint().deserialize(value, ProtocolVersion.fromInt((int)protocolVersion));
    }

    protected short compose_short(int protocolVersion, int argIndex, ByteBuffer value) {
        assert (value != null && value.remaining() > 0);
        return (Short)DataType.smallint().deserialize(value, ProtocolVersion.fromInt((int)protocolVersion));
    }

    protected int compose_int(int protocolVersion, int argIndex, ByteBuffer value) {
        assert (value != null && value.remaining() > 0);
        return (Integer)DataType.cint().deserialize(value, ProtocolVersion.fromInt((int)protocolVersion));
    }

    protected long compose_long(int protocolVersion, int argIndex, ByteBuffer value) {
        assert (value != null && value.remaining() > 0);
        return (Long)DataType.bigint().deserialize(value, ProtocolVersion.fromInt((int)protocolVersion));
    }

    protected boolean compose_boolean(int protocolVersion, int argIndex, ByteBuffer value) {
        assert (value != null && value.remaining() > 0);
        return (Boolean)DataType.cboolean().deserialize(value, ProtocolVersion.fromInt((int)protocolVersion));
    }
}

