/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Lists;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.restrictions.Restriction;
import org.apache.cassandra.cql3.restrictions.SingleColumnRestriction;
import org.apache.cassandra.cql3.statements.Bound;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.exceptions.InvalidRequestException;

public final class SingleColumnRelation
extends Relation {
    private final ColumnIdentifier.Raw entity;
    private final Term.Raw mapKey;
    private final Term.Raw value;
    private final List<Term.Raw> inValues;

    private SingleColumnRelation(ColumnIdentifier.Raw entity, Term.Raw mapKey, Operator type, Term.Raw value, List<Term.Raw> inValues) {
        this.entity = entity;
        this.mapKey = mapKey;
        this.relationType = type;
        this.value = value;
        this.inValues = inValues;
    }

    public SingleColumnRelation(ColumnIdentifier.Raw entity, Term.Raw mapKey, Operator type, Term.Raw value) {
        this(entity, mapKey, type, value, null);
    }

    public SingleColumnRelation(ColumnIdentifier.Raw entity, Operator type, Term.Raw value) {
        this(entity, null, type, value);
    }

    public static SingleColumnRelation createInRelation(ColumnIdentifier.Raw entity, List<Term.Raw> inValues) {
        return new SingleColumnRelation(entity, null, Operator.IN, null, inValues);
    }

    public ColumnIdentifier.Raw getEntity() {
        return this.entity;
    }

    public Term.Raw getMapKey() {
        return this.mapKey;
    }

    @Override
    protected Term toTerm(List<? extends ColumnSpecification> receivers, Term.Raw raw, String keyspace, VariableSpecifications boundNames) throws InvalidRequestException {
        assert (receivers.size() == 1);
        Term term = raw.prepare(keyspace, receivers.get(0));
        term.collectMarkerSpecification(boundNames);
        return term;
    }

    public SingleColumnRelation withNonStrictOperator() {
        switch (this.relationType) {
            case GT: {
                return new SingleColumnRelation(this.entity, Operator.GTE, this.value);
            }
            case LT: {
                return new SingleColumnRelation(this.entity, Operator.LTE, this.value);
            }
        }
        return this;
    }

    public String toString() {
        String entityAsString = this.entity.toString();
        if (this.mapKey != null) {
            entityAsString = String.format("%s[%s]", entityAsString, this.mapKey);
        }
        if (this.isIN()) {
            return String.format("%s IN %s", entityAsString, this.inValues);
        }
        return String.format("%s %s %s", new Object[]{entityAsString, this.relationType, this.value});
    }

    @Override
    protected Restriction newEQRestriction(CFMetaData cfm, VariableSpecifications boundNames) throws InvalidRequestException {
        ColumnDefinition columnDef = this.toColumnDefinition(cfm, this.entity);
        if (this.mapKey == null) {
            Term term = this.toTerm(this.toReceivers(columnDef, cfm.isDense()), this.value, cfm.ksName, boundNames);
            return new SingleColumnRestriction.EQRestriction(columnDef, term);
        }
        List<? extends ColumnSpecification> receivers = this.toReceivers(columnDef, cfm.isDense());
        Term entryKey = this.toTerm(Collections.singletonList(receivers.get(0)), this.mapKey, cfm.ksName, boundNames);
        Term entryValue = this.toTerm(Collections.singletonList(receivers.get(1)), this.value, cfm.ksName, boundNames);
        return new SingleColumnRestriction.ContainsRestriction(columnDef, entryKey, entryValue);
    }

    @Override
    protected Restriction newINRestriction(CFMetaData cfm, VariableSpecifications boundNames) throws InvalidRequestException {
        ColumnDefinition columnDef = cfm.getColumnDefinition(this.getEntity().prepare(cfm));
        List<? extends ColumnSpecification> receivers = this.toReceivers(columnDef, cfm.isDense());
        List<Term> terms = this.toTerms(receivers, this.inValues, cfm.ksName, boundNames);
        if (terms == null) {
            Term term = this.toTerm(receivers, this.value, cfm.ksName, boundNames);
            return new SingleColumnRestriction.InRestrictionWithMarker(columnDef, (Lists.Marker)term);
        }
        return new SingleColumnRestriction.InRestrictionWithValues(columnDef, terms);
    }

    @Override
    protected Restriction newSliceRestriction(CFMetaData cfm, VariableSpecifications boundNames, Bound bound, boolean inclusive) throws InvalidRequestException {
        ColumnDefinition columnDef = this.toColumnDefinition(cfm, this.entity);
        Term term = this.toTerm(this.toReceivers(columnDef, cfm.isDense()), this.value, cfm.ksName, boundNames);
        return new SingleColumnRestriction.SliceRestriction(columnDef, bound, inclusive, term);
    }

    @Override
    protected Restriction newContainsRestriction(CFMetaData cfm, VariableSpecifications boundNames, boolean isKey) throws InvalidRequestException {
        ColumnDefinition columnDef = this.toColumnDefinition(cfm, this.entity);
        Term term = this.toTerm(this.toReceivers(columnDef, cfm.isDense()), this.value, cfm.ksName, boundNames);
        return new SingleColumnRestriction.ContainsRestriction(columnDef, term, isKey);
    }

    private List<? extends ColumnSpecification> toReceivers(ColumnDefinition columnDef, boolean isDense) throws InvalidRequestException {
        ColumnSpecification receiver = columnDef;
        RequestValidations.checkFalse(!columnDef.isPrimaryKeyColumn() && isDense, "Predicates on the non-primary-key column (%s) of a COMPACT table are not yet supported", columnDef.name);
        if (this.isIN()) {
            RequestValidations.checkFalse(!columnDef.isPrimaryKeyColumn() && !this.canHaveOnlyOneValue(), "IN predicates on non-primary-key columns (%s) is not yet supported", columnDef.name);
        } else if (this.isSlice()) {
            RequestValidations.checkFalse(columnDef.isPartitionKey(), "Only EQ and IN relation are supported on the partition key (unless you use the token() function)");
        }
        RequestValidations.checkFalse(this.isContainsKey() && !(receiver.type instanceof MapType), "Cannot use CONTAINS KEY on non-map column %s", receiver.name);
        if (this.mapKey != null) {
            RequestValidations.checkFalse(receiver.type instanceof ListType, "Indexes on list entries (%s[index] = value) are not currently supported.", receiver.name);
            RequestValidations.checkTrue(receiver.type instanceof MapType, "Column %s cannot be used as a map", receiver.name);
            RequestValidations.checkTrue(receiver.type.isMultiCell(), "Map-entry equality predicates on frozen map column %s are not supported", receiver.name);
            RequestValidations.checkTrue(this.isEQ(), "Only EQ relations are supported on map entries");
        }
        if (receiver.type.isCollection()) {
            RequestValidations.checkFalse(receiver.type.isMultiCell() && !this.isLegalRelationForNonFrozenCollection(), "Collection column '%s' (%s) cannot be restricted by a '%s' relation", new Object[]{receiver.name, receiver.type.asCQL3Type(), this.operator()});
            if (this.isContainsKey() || this.isContains()) {
                receiver = SingleColumnRelation.makeCollectionReceiver(receiver, this.isContainsKey());
            } else if (receiver.type.isMultiCell() && this.mapKey != null && this.isEQ()) {
                ArrayList<ColumnSpecification> receivers = new ArrayList<ColumnSpecification>(2);
                receivers.add(SingleColumnRelation.makeCollectionReceiver(receiver, true));
                receivers.add(SingleColumnRelation.makeCollectionReceiver(receiver, false));
                return receivers;
            }
        }
        return Collections.singletonList(receiver);
    }

    private static ColumnSpecification makeCollectionReceiver(ColumnSpecification receiver, boolean forKey) {
        return ((CollectionType)receiver.type).makeCollectionReceiver(receiver, forKey);
    }

    private boolean isLegalRelationForNonFrozenCollection() {
        return this.isContainsKey() || this.isContains() || this.isMapEntryEquality();
    }

    private boolean isMapEntryEquality() {
        return this.mapKey != null && this.isEQ();
    }

    private boolean canHaveOnlyOneValue() {
        return this.isEQ() || this.isIN() && this.inValues != null && this.inValues.size() == 1;
    }
}

