/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.selection;

import java.nio.ByteBuffer;
import java.util.Collections;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.AssignmentTestable;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.selection.Selection;
import org.apache.cassandra.cql3.selection.SelectionColumnMapping;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ReversedType;
import org.apache.cassandra.exceptions.InvalidRequestException;

public abstract class Selector
implements AssignmentTestable {
    public abstract void addInput(int var1, Selection.ResultSetBuilder var2) throws InvalidRequestException;

    public abstract ByteBuffer getOutput(int var1) throws InvalidRequestException;

    public abstract AbstractType<?> getType();

    public boolean isAggregate() {
        return false;
    }

    public abstract void reset();

    @Override
    public final AssignmentTestable.TestResult testAssignment(String keyspace, ColumnSpecification receiver) {
        AbstractType<?> receiverType = receiver.type;
        if (this.getType().isFrozenCollection()) {
            receiverType = receiverType.freeze();
        }
        if (this.getType().isReversed()) {
            receiverType = ReversedType.getInstance(receiverType);
        }
        if (receiverType.equals(this.getType())) {
            return AssignmentTestable.TestResult.EXACT_MATCH;
        }
        if (receiverType.isValueCompatibleWith(this.getType())) {
            return AssignmentTestable.TestResult.WEAKLY_ASSIGNABLE;
        }
        return AssignmentTestable.TestResult.NOT_ASSIGNABLE;
    }

    public static abstract class Factory {
        public Iterable<Function> getFunctions() {
            return Collections.emptySet();
        }

        public final ColumnSpecification getColumnSpecification(CFMetaData cfm) {
            return new ColumnSpecification(cfm.ksName, cfm.cfName, new ColumnIdentifier(this.getColumnName(), true), this.getReturnType());
        }

        public abstract Selector newInstance() throws InvalidRequestException;

        public boolean isAggregateSelectorFactory() {
            return false;
        }

        public boolean isWritetimeSelectorFactory() {
            return false;
        }

        public boolean isTTLSelectorFactory() {
            return false;
        }

        public boolean isSimpleSelectorFactory(int index) {
            return false;
        }

        protected abstract String getColumnName();

        protected abstract AbstractType<?> getReturnType();

        protected abstract void addColumnMapping(SelectionColumnMapping var1, ColumnSpecification var2);
    }
}

