/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import com.google.common.annotations.VisibleForTesting;
import java.io.EOFException;
import java.io.File;
import java.nio.ByteBuffer;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.compress.BufferType;
import org.apache.cassandra.io.util.AbstractDataInput;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.FileMark;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.PoolingSegmentedFile;
import org.apache.cassandra.io.util.SequentialWriter;
import org.apache.cassandra.utils.ByteBufferUtil;

public class RandomAccessReader
extends AbstractDataInput
implements FileDataInput {
    public static final int DEFAULT_BUFFER_SIZE = 65536;
    public static final int BUFFER_SIZE = Integer.getInteger("cassandra.rar_buffer_size", 65536);
    protected ByteBuffer buffer;
    protected long bufferOffset;
    protected long markedPointer;
    protected final ChannelProxy channel;
    private final long fileLength;
    protected final PoolingSegmentedFile owner;

    protected RandomAccessReader(ChannelProxy channel, int bufferSize, long overrideLength, BufferType bufferType, PoolingSegmentedFile owner) {
        this.channel = channel.sharedCopy();
        this.owner = owner;
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("bufferSize must be positive");
        }
        this.fileLength = overrideLength <= 0L ? channel.size() : overrideLength;
        this.buffer = this.allocateBuffer(bufferSize, bufferType);
        this.buffer.limit(0);
    }

    protected ByteBuffer allocateBuffer(int bufferSize, BufferType bufferType) {
        int size = (int)Math.min(this.fileLength, (long)bufferSize);
        return bufferType.allocate(size);
    }

    public static RandomAccessReader open(ChannelProxy channel, long overrideSize, PoolingSegmentedFile owner) {
        return RandomAccessReader.open(channel, BUFFER_SIZE, overrideSize, owner);
    }

    public static RandomAccessReader open(File file) {
        try (ChannelProxy channel = new ChannelProxy(file);){
            RandomAccessReader randomAccessReader = RandomAccessReader.open(channel);
            return randomAccessReader;
        }
    }

    public static RandomAccessReader open(ChannelProxy channel) {
        return RandomAccessReader.open(channel, -1L);
    }

    public static RandomAccessReader open(ChannelProxy channel, long overrideSize) {
        return RandomAccessReader.open(channel, BUFFER_SIZE, overrideSize, null);
    }

    @VisibleForTesting
    static RandomAccessReader open(ChannelProxy channel, int bufferSize, PoolingSegmentedFile owner) {
        return RandomAccessReader.open(channel, bufferSize, -1L, owner);
    }

    private static RandomAccessReader open(ChannelProxy channel, int bufferSize, long overrideSize, PoolingSegmentedFile owner) {
        return new RandomAccessReader(channel, bufferSize, overrideSize, BufferType.ON_HEAP, owner);
    }

    @VisibleForTesting
    static RandomAccessReader open(SequentialWriter writer) {
        try (ChannelProxy channel = new ChannelProxy(writer.getPath());){
            RandomAccessReader randomAccessReader = RandomAccessReader.open(channel, BUFFER_SIZE, null);
            return randomAccessReader;
        }
    }

    public ChannelProxy getChannel() {
        return this.channel;
    }

    protected void reBuffer() {
        int n;
        this.bufferOffset += (long)this.buffer.position();
        this.buffer.clear();
        assert (this.bufferOffset < this.fileLength);
        long position = this.bufferOffset;
        long limit = this.bufferOffset;
        while (this.buffer.hasRemaining() && limit < this.fileLength && (n = this.channel.read(this.buffer, position)) >= 0) {
            position += (long)n;
            limit = this.bufferOffset + (long)this.buffer.position();
        }
        if (limit > this.fileLength) {
            this.buffer.position((int)(this.fileLength - this.bufferOffset));
        }
        this.buffer.flip();
    }

    @Override
    public long getFilePointer() {
        return this.current();
    }

    protected long current() {
        return this.bufferOffset + (long)(this.buffer == null ? 0 : this.buffer.position());
    }

    @Override
    public String getPath() {
        return this.channel.filePath();
    }

    public int getTotalBufferSize() {
        ByteBuffer ref = this.buffer;
        return ref != null ? ref.capacity() : 0;
    }

    @Override
    public void reset() {
        this.seek(this.markedPointer);
    }

    public long bytesPastMark() {
        long bytes = this.current() - this.markedPointer;
        assert (bytes >= 0L);
        return bytes;
    }

    @Override
    public FileMark mark() {
        this.markedPointer = this.current();
        return new BufferedRandomAccessFileMark(this.markedPointer);
    }

    @Override
    public void reset(FileMark mark) {
        assert (mark instanceof BufferedRandomAccessFileMark);
        this.seek(((BufferedRandomAccessFileMark)mark).pointer);
    }

    @Override
    public long bytesPastMark(FileMark mark) {
        assert (mark instanceof BufferedRandomAccessFileMark);
        long bytes = this.current() - ((BufferedRandomAccessFileMark)mark).pointer;
        assert (bytes >= 0L);
        return bytes;
    }

    @Override
    public boolean isEOF() {
        return this.getFilePointer() == this.length();
    }

    @Override
    public long bytesRemaining() {
        return this.length() - this.getFilePointer();
    }

    @Override
    public void close() {
        if (this.owner == null || this.buffer == null) {
            this.deallocate();
        } else {
            this.owner.recycle(this);
        }
    }

    public void deallocate() {
        if (this.buffer == null) {
            return;
        }
        this.bufferOffset += (long)this.buffer.position();
        FileUtils.clean(this.buffer);
        this.buffer = null;
        this.channel.close();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(filePath='" + this.channel + "')";
    }

    @Override
    public void seek(long newPosition) {
        if (newPosition < 0L) {
            throw new IllegalArgumentException("new position should not be negative");
        }
        if (newPosition >= this.length()) {
            if (newPosition > this.length()) {
                throw new IllegalArgumentException(String.format("Unable to seek to position %d in %s (%d bytes) in read-only mode", newPosition, this.getPath(), this.length()));
            }
            this.buffer.limit(0);
            this.bufferOffset = newPosition;
            return;
        }
        if (newPosition >= this.bufferOffset && newPosition < this.bufferOffset + (long)this.buffer.limit()) {
            this.buffer.position((int)(newPosition - this.bufferOffset));
            return;
        }
        this.bufferOffset = newPosition;
        this.buffer.clear();
        this.reBuffer();
        assert (this.current() == newPosition);
    }

    @Override
    public int read() {
        if (this.buffer == null) {
            throw new AssertionError((Object)"Attempted to read from closed RAR");
        }
        if (!this.buffer.hasRemaining()) {
            if (this.isEOF()) {
                return -1;
            }
            this.reBuffer();
        }
        return this.buffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] buffer) {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(byte[] buff, int offset, int length) {
        if (this.buffer == null) {
            throw new AssertionError((Object)"Attempted to read from closed RAR");
        }
        if (length == 0) {
            return 0;
        }
        if (!this.buffer.hasRemaining()) {
            if (this.isEOF()) {
                return -1;
            }
            this.reBuffer();
        }
        int toCopy = Math.min(length, this.buffer.remaining());
        this.buffer.get(buff, offset, toCopy);
        return toCopy;
    }

    @Override
    public ByteBuffer readBytes(int length) throws EOFException {
        assert (length >= 0) : "buffer length should not be negative: " + length;
        try {
            ByteBuffer result = ByteBuffer.allocate(length);
            while (result.hasRemaining()) {
                if (!this.buffer.hasRemaining()) {
                    if (this.isEOF()) {
                        throw new EOFException();
                    }
                    this.reBuffer();
                }
                ByteBufferUtil.put(this.buffer, result);
            }
            result.flip();
            return result;
        }
        catch (EOFException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FSReadError((Throwable)e, this.channel.toString());
        }
    }

    public long length() {
        return this.fileLength;
    }

    @Override
    public long getPosition() {
        return this.bufferOffset + (long)this.buffer.position();
    }

    @Override
    public long getPositionLimit() {
        return this.length();
    }

    protected static class BufferedRandomAccessFileMark
    implements FileMark {
        final long pointer;

        public BufferedRandomAccessFileMark(long pointer) {
            this.pointer = pointer;
        }
    }
}

