/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.cql3.Json;
import org.apache.cassandra.cql3.Maps;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.FrozenType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.serializers.CollectionSerializer;
import org.apache.cassandra.serializers.MapSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.utils.Pair;

public class MapType<K, V>
extends CollectionType<Map<K, V>> {
    private static final Map<Pair<AbstractType<?>, AbstractType<?>>, MapType> instances = new HashMap();
    private static final Map<Pair<AbstractType<?>, AbstractType<?>>, MapType> frozenInstances = new HashMap();
    private final AbstractType<K> keys;
    private final AbstractType<V> values;
    private final MapSerializer<K, V> serializer;
    private final boolean isMultiCell;

    public static MapType<?, ?> getInstance(TypeParser parser) throws ConfigurationException, SyntaxException {
        List<AbstractType<?>> l = parser.getTypeParameters();
        if (l.size() != 2) {
            throw new ConfigurationException("MapType takes exactly 2 type parameters");
        }
        return MapType.getInstance(l.get(0), l.get(1), true);
    }

    public static synchronized <K, V> MapType<K, V> getInstance(AbstractType<K> keys, AbstractType<V> values, boolean isMultiCell) {
        Pair<AbstractType<K>, AbstractType<V>> p;
        Map<Pair<AbstractType<?>, AbstractType<?>>, MapType> internMap = isMultiCell ? instances : frozenInstances;
        MapType<K, V> t = internMap.get(p = Pair.create(keys, values));
        if (t == null) {
            t = new MapType<K, V>(keys, values, isMultiCell);
            internMap.put(p, t);
        }
        return t;
    }

    private MapType(AbstractType<K> keys, AbstractType<V> values, boolean isMultiCell) {
        super(CollectionType.Kind.MAP);
        this.keys = keys;
        this.values = values;
        this.serializer = MapSerializer.getInstance(keys.getSerializer(), values.getSerializer());
        this.isMultiCell = isMultiCell;
    }

    @Override
    public boolean references(AbstractType<?> check) {
        return super.references(check) || this.keys.references(check) || this.values.references(check);
    }

    public AbstractType<K> getKeysType() {
        return this.keys;
    }

    public AbstractType<V> getValuesType() {
        return this.values;
    }

    @Override
    public AbstractType<K> nameComparator() {
        return this.keys;
    }

    @Override
    public AbstractType<V> valueComparator() {
        return this.values;
    }

    @Override
    public boolean isMultiCell() {
        return this.isMultiCell;
    }

    @Override
    public AbstractType<?> freeze() {
        if (this.isMultiCell) {
            return MapType.getInstance(this.keys, this.values, false);
        }
        return this;
    }

    @Override
    public boolean isCompatibleWithFrozen(CollectionType<?> previous) {
        assert (!this.isMultiCell);
        MapType tprev = (MapType)previous;
        return this.keys.isCompatibleWith(tprev.keys) && this.values.isCompatibleWith(tprev.values);
    }

    @Override
    public boolean isValueCompatibleWithFrozen(CollectionType<?> previous) {
        assert (!this.isMultiCell);
        MapType tprev = (MapType)previous;
        return this.keys.isCompatibleWith(tprev.keys) && this.values.isValueCompatibleWith(tprev.values);
    }

    @Override
    public int compare(ByteBuffer o1, ByteBuffer o2) {
        return MapType.compareMaps(this.keys, this.values, o1, o2);
    }

    public static int compareMaps(AbstractType<?> keysComparator, AbstractType<?> valuesComparator, ByteBuffer o1, ByteBuffer o2) {
        if (!o1.hasRemaining() || !o2.hasRemaining()) {
            return o1.hasRemaining() ? 1 : (o2.hasRemaining() ? -1 : 0);
        }
        ByteBuffer bb1 = o1.duplicate();
        ByteBuffer bb2 = o2.duplicate();
        int protocolVersion = 3;
        int size1 = CollectionSerializer.readCollectionSize(bb1, protocolVersion);
        int size2 = CollectionSerializer.readCollectionSize(bb2, protocolVersion);
        for (int i = 0; i < Math.min(size1, size2); ++i) {
            ByteBuffer v2;
            ByteBuffer k2;
            ByteBuffer k1 = CollectionSerializer.readValue(bb1, protocolVersion);
            int cmp = keysComparator.compare(k1, k2 = CollectionSerializer.readValue(bb2, protocolVersion));
            if (cmp != 0) {
                return cmp;
            }
            ByteBuffer v1 = CollectionSerializer.readValue(bb1, protocolVersion);
            cmp = valuesComparator.compare(v1, v2 = CollectionSerializer.readValue(bb2, protocolVersion));
            if (cmp == 0) continue;
            return cmp;
        }
        return size1 == size2 ? 0 : (size1 < size2 ? -1 : 1);
    }

    @Override
    public MapSerializer<K, V> getSerializer() {
        return this.serializer;
    }

    @Override
    public boolean isByteOrderComparable() {
        return this.keys.isByteOrderComparable();
    }

    @Override
    public String toString(boolean ignoreFreezing) {
        boolean includeFrozenType = !ignoreFreezing && !this.isMultiCell();
        StringBuilder sb = new StringBuilder();
        if (includeFrozenType) {
            sb.append(FrozenType.class.getName()).append("(");
        }
        sb.append(this.getClass().getName()).append(TypeParser.stringifyTypeParameters(Arrays.asList(this.keys, this.values), ignoreFreezing || !this.isMultiCell));
        if (includeFrozenType) {
            sb.append(")");
        }
        return sb.toString();
    }

    @Override
    public List<ByteBuffer> serializedValues(List<Cell> cells) {
        assert (this.isMultiCell);
        ArrayList<ByteBuffer> bbs = new ArrayList<ByteBuffer>(cells.size() * 2);
        for (Cell c : cells) {
            bbs.add(c.name().collectionElement());
            bbs.add(c.value());
        }
        return bbs;
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        if (parsed instanceof String) {
            parsed = Json.decodeJson((String)parsed);
        }
        if (!(parsed instanceof Map)) {
            throw new MarshalException(String.format("Expected a map, but got a %s: %s", parsed.getClass().getSimpleName(), parsed));
        }
        Map map = (Map)parsed;
        HashMap<Term, Term> terms = new HashMap<Term, Term>(map.size());
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getKey() == null) {
                throw new MarshalException("Invalid null key in map");
            }
            if (entry.getValue() == null) {
                throw new MarshalException("Invalid null value in map");
            }
            terms.put(this.keys.fromJSONObject(entry.getKey()), this.values.fromJSONObject(entry.getValue()));
        }
        return new Maps.DelayedValue(this.keys, terms);
    }

    @Override
    public String toJSONString(ByteBuffer buffer, int protocolVersion) {
        StringBuilder sb = new StringBuilder("{");
        int size = CollectionSerializer.readCollectionSize(buffer, protocolVersion);
        for (int i = 0; i < size; ++i) {
            String key;
            if (i > 0) {
                sb.append(", ");
            }
            if ((key = this.keys.toJSONString(CollectionSerializer.readValue(buffer, protocolVersion), protocolVersion)).startsWith("\"")) {
                sb.append(key);
            } else {
                sb.append('\"').append(Json.quoteAsJsonString(key)).append('\"');
            }
            sb.append(": ");
            sb.append(this.values.toJSONString(CollectionSerializer.readValue(buffer, protocolVersion), protocolVersion));
        }
        return sb.append("}").toString();
    }
}

