/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.AssignmentTestable;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.functions.AbstractFunction;
import org.apache.cassandra.cql3.functions.AggregateFcts;
import org.apache.cassandra.cql3.functions.BytesConversionFcts;
import org.apache.cassandra.cql3.functions.FromJsonFct;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.functions.TimeFcts;
import org.apache.cassandra.cql3.functions.ToJsonFct;
import org.apache.cassandra.cql3.functions.TokenFct;
import org.apache.cassandra.cql3.functions.UDFunction;
import org.apache.cassandra.cql3.functions.UuidFcts;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.service.MigrationListener;
import org.apache.cassandra.service.MigrationManager;

public abstract class Functions {
    private static final FunctionName TOKEN_FUNCTION_NAME = FunctionName.nativeFunction("token");
    private static final ConcurrentMap<FunctionName, List<Function>> declared = new ConcurrentHashMap<FunctionName, List<Function>>();

    private Functions() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void declare(Function fun) {
        ConcurrentMap<FunctionName, List<Function>> concurrentMap = declared;
        synchronized (concurrentMap) {
            List<Function> functions = (CopyOnWriteArrayList<Function>)declared.get(fun.name());
            if (functions == null) {
                functions = new CopyOnWriteArrayList<Function>();
                List existing = declared.putIfAbsent(fun.name(), functions);
                if (existing != null) {
                    functions = existing;
                }
            }
            functions.add(fun);
        }
    }

    public static ColumnSpecification makeArgSpec(String receiverKs, String receiverCf, Function fun, int i) {
        return new ColumnSpecification(receiverKs, receiverCf, new ColumnIdentifier("arg" + i + '(' + fun.name().toString().toLowerCase() + ')', true), fun.argTypes().get(i));
    }

    public static int getOverloadCount(FunctionName name) {
        return Functions.find(name).size();
    }

    public static Function get(String keyspace, FunctionName name, List<? extends AssignmentTestable> providedArgs, String receiverKs, String receiverCf, AbstractType<?> receiverType) throws InvalidRequestException {
        List<Function> candidates;
        if (name.equalsNativeFunction(TOKEN_FUNCTION_NAME)) {
            return new TokenFct(Schema.instance.getCFMetaData(receiverKs, receiverCf));
        }
        if (name.equalsNativeFunction(ToJsonFct.NAME)) {
            throw new InvalidRequestException("toJson() may only be used within the selection clause of SELECT statements");
        }
        if (name.equalsNativeFunction(FromJsonFct.NAME)) {
            if (receiverType == null) {
                throw new InvalidRequestException("fromJson() cannot be used in the selection clause of a SELECT statement");
            }
            return FromJsonFct.getInstance(receiverType);
        }
        if (!name.hasKeyspace()) {
            candidates = new ArrayList<Function>();
            candidates.addAll(Functions.find(name.asNativeFunction()));
            candidates.addAll(Functions.find(new FunctionName(keyspace, name.name)));
        } else {
            candidates = Functions.find(name);
        }
        if (candidates.isEmpty()) {
            return null;
        }
        if (candidates.size() == 1) {
            Function fun = candidates.get(0);
            Functions.validateTypes(keyspace, fun, providedArgs, receiverKs, receiverCf);
            return fun;
        }
        ArrayList<Function> compatibles = null;
        for (Function toTest : candidates) {
            AssignmentTestable.TestResult r = Functions.matchAguments(keyspace, toTest, providedArgs, receiverKs, receiverCf);
            switch (r) {
                case EXACT_MATCH: {
                    return toTest;
                }
                case WEAKLY_ASSIGNABLE: {
                    if (compatibles == null) {
                        compatibles = new ArrayList<Function>();
                    }
                    compatibles.add(toTest);
                }
            }
        }
        if (compatibles == null || compatibles.isEmpty()) {
            throw new InvalidRequestException(String.format("Invalid call to function %s, none of its type signatures match (known type signatures: %s)", name, Functions.toString(candidates)));
        }
        if (compatibles.size() > 1) {
            throw new InvalidRequestException(String.format("Ambiguous call to function %s (can be matched by following signatures: %s): use type casts to disambiguate", name, Functions.toString(compatibles)));
        }
        return (Function)compatibles.get(0);
    }

    public static List<Function> find(FunctionName name) {
        List<Function> functions = (List<Function>)declared.get(name);
        return functions != null ? functions : Collections.emptyList();
    }

    public static Function find(FunctionName name, List<AbstractType<?>> argTypes) {
        assert (name.hasKeyspace()) : "function name not fully qualified";
        for (Function f : Functions.find(name)) {
            if (!Functions.typeEquals(f.argTypes(), argTypes)) continue;
            return f;
        }
        return null;
    }

    private static void validateTypes(String keyspace, Function fun, List<? extends AssignmentTestable> providedArgs, String receiverKs, String receiverCf) throws InvalidRequestException {
        if (providedArgs.size() != fun.argTypes().size()) {
            throw new InvalidRequestException(String.format("Invalid number of arguments in call to function %s: %d required but %d provided", fun.name(), fun.argTypes().size(), providedArgs.size()));
        }
        for (int i = 0; i < providedArgs.size(); ++i) {
            ColumnSpecification expected;
            AssignmentTestable provided = providedArgs.get(i);
            if (provided == null || provided.testAssignment(keyspace, expected = Functions.makeArgSpec(receiverKs, receiverCf, fun, i)).isAssignable()) continue;
            throw new InvalidRequestException(String.format("Type error: %s cannot be passed as argument %d of function %s of type %s", provided, i, fun.name(), expected.type.asCQL3Type()));
        }
    }

    private static AssignmentTestable.TestResult matchAguments(String keyspace, Function fun, List<? extends AssignmentTestable> providedArgs, String receiverKs, String receiverCf) {
        if (providedArgs.size() != fun.argTypes().size()) {
            return AssignmentTestable.TestResult.NOT_ASSIGNABLE;
        }
        AssignmentTestable.TestResult res = AssignmentTestable.TestResult.EXACT_MATCH;
        for (int i = 0; i < providedArgs.size(); ++i) {
            AssignmentTestable provided = providedArgs.get(i);
            if (provided == null) {
                res = AssignmentTestable.TestResult.WEAKLY_ASSIGNABLE;
                continue;
            }
            ColumnSpecification expected = Functions.makeArgSpec(receiverKs, receiverCf, fun, i);
            AssignmentTestable.TestResult argRes = provided.testAssignment(keyspace, expected);
            if (argRes == AssignmentTestable.TestResult.NOT_ASSIGNABLE) {
                return AssignmentTestable.TestResult.NOT_ASSIGNABLE;
            }
            if (argRes != AssignmentTestable.TestResult.WEAKLY_ASSIGNABLE) continue;
            res = AssignmentTestable.TestResult.WEAKLY_ASSIGNABLE;
        }
        return res;
    }

    private static String toString(List<Function> funs) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < funs.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(funs.get(i));
        }
        return sb.toString();
    }

    public static void addOrReplaceFunction(AbstractFunction fun) {
        Functions.removeFunction(fun.name(), fun.argTypes());
        Functions.declare(fun);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFunction(FunctionName name, List<AbstractType<?>> argTypes) {
        assert (name.hasKeyspace()) : "function name " + name + " not fully qualified";
        ConcurrentMap<FunctionName, List<Function>> concurrentMap = declared;
        synchronized (concurrentMap) {
            List<Function> functions = Functions.find(name);
            for (int i = 0; i < functions.size(); ++i) {
                Function f = functions.get(i);
                if (!Functions.typeEquals(f.argTypes(), argTypes)) continue;
                assert (!f.isNative());
                functions.remove(i);
                if (functions.isEmpty()) {
                    declared.remove(name);
                }
                return;
            }
        }
    }

    public static List<Function> getReferencesTo(Function old) {
        ArrayList<Function> references = new ArrayList<Function>();
        for (List functions : declared.values()) {
            for (Function function : functions) {
                if (!function.hasReferenceTo(old)) continue;
                references.add(function);
            }
        }
        return references;
    }

    public static Collection<Function> all() {
        ArrayList<Function> all = new ArrayList<Function>();
        for (List functions : declared.values()) {
            all.addAll(functions);
        }
        return all;
    }

    public static boolean typeEquals(AbstractType<?> t1, AbstractType<?> t2) {
        return t1.asCQL3Type().toString().equals(t2.asCQL3Type().toString());
    }

    public static boolean typeEquals(List<AbstractType<?>> t1, List<AbstractType<?>> t2) {
        if (t1.size() != t2.size()) {
            return false;
        }
        for (int i = 0; i < t1.size(); ++i) {
            if (Functions.typeEquals(t1.get(i), t2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static int typeHashCode(AbstractType<?> t) {
        return t.asCQL3Type().toString().hashCode();
    }

    public static int typeHashCode(List<AbstractType<?>> types) {
        int h = 0;
        for (AbstractType<?> type : types) {
            h = h * 31 + Functions.typeHashCode(type);
        }
        return h;
    }

    static {
        Functions.declare(AggregateFcts.countRowsFunction);
        Functions.declare(TimeFcts.nowFct);
        Functions.declare(TimeFcts.minTimeuuidFct);
        Functions.declare(TimeFcts.maxTimeuuidFct);
        Functions.declare(TimeFcts.dateOfFct);
        Functions.declare(TimeFcts.unixTimestampOfFct);
        Functions.declare(TimeFcts.timeUuidtoDate);
        Functions.declare(TimeFcts.timeUuidToTimestamp);
        Functions.declare(TimeFcts.timeUuidToUnixTimestamp);
        Functions.declare(TimeFcts.timestampToDate);
        Functions.declare(TimeFcts.timestampToUnixTimestamp);
        Functions.declare(TimeFcts.dateToTimestamp);
        Functions.declare(TimeFcts.dateToUnixTimestamp);
        Functions.declare(UuidFcts.uuidFct);
        for (CQL3Type.Native type : CQL3Type.Native.values()) {
            if (type == CQL3Type.Native.VARCHAR || type == CQL3Type.Native.BLOB) continue;
            Functions.declare(BytesConversionFcts.makeToBlobFunction(type.getType()));
            Functions.declare(BytesConversionFcts.makeFromBlobFunction(type.getType()));
        }
        Functions.declare(BytesConversionFcts.VarcharAsBlobFct);
        Functions.declare(BytesConversionFcts.BlobAsVarcharFact);
        for (CQL3Type.Native type : CQL3Type.Native.values()) {
            if (type == CQL3Type.Native.VARCHAR) continue;
            Functions.declare(AggregateFcts.makeCountFunction(type.getType()));
            Functions.declare(AggregateFcts.makeMaxFunction(type.getType()));
            Functions.declare(AggregateFcts.makeMinFunction(type.getType()));
        }
        Functions.declare(AggregateFcts.sumFunctionForByte);
        Functions.declare(AggregateFcts.sumFunctionForShort);
        Functions.declare(AggregateFcts.sumFunctionForInt32);
        Functions.declare(AggregateFcts.sumFunctionForLong);
        Functions.declare(AggregateFcts.sumFunctionForFloat);
        Functions.declare(AggregateFcts.sumFunctionForDouble);
        Functions.declare(AggregateFcts.sumFunctionForDecimal);
        Functions.declare(AggregateFcts.sumFunctionForVarint);
        Functions.declare(AggregateFcts.avgFunctionForByte);
        Functions.declare(AggregateFcts.avgFunctionForShort);
        Functions.declare(AggregateFcts.avgFunctionForInt32);
        Functions.declare(AggregateFcts.avgFunctionForLong);
        Functions.declare(AggregateFcts.avgFunctionForFloat);
        Functions.declare(AggregateFcts.avgFunctionForDouble);
        Functions.declare(AggregateFcts.avgFunctionForVarint);
        Functions.declare(AggregateFcts.avgFunctionForDecimal);
        MigrationManager.instance.register(new FunctionsMigrationListener());
    }

    private static class FunctionsMigrationListener
    extends MigrationListener {
        private FunctionsMigrationListener() {
        }

        @Override
        public void onUpdateUserType(String ksName, String typeName) {
            for (Function function : Functions.all()) {
                if (!(function instanceof UDFunction)) continue;
                ((UDFunction)function).userTypeUpdated(ksName, typeName);
            }
        }
    }
}

