/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.Attributes;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.CQL3Row;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.ColumnCondition;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Operation;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.cql3.SingleColumnRelation;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.UpdateParameters;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.restrictions.Restriction;
import org.apache.cassandra.cql3.restrictions.SingleColumnRestriction;
import org.apache.cassandra.cql3.selection.Selection;
import org.apache.cassandra.cql3.statements.CFStatement;
import org.apache.cassandra.cql3.statements.CQL3CasRequest;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.cql3.statements.SelectStatement;
import org.apache.cassandra.db.ArrayBackedSortedColumns;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.CounterMutation;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.SliceFromReadCommand;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.composites.CompositesBuilder;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.paxos.Commit;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.triggers.TriggerExecutor;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.UUIDGen;

public abstract class ModificationStatement
implements CQLStatement {
    private static final ColumnIdentifier CAS_RESULT_COLUMN = new ColumnIdentifier("[applied]", false);
    public final StatementType type;
    private final int boundTerms;
    public final CFMetaData cfm;
    public final Attributes attrs;
    protected final Map<ColumnIdentifier, Restriction> processedKeys = new HashMap<ColumnIdentifier, Restriction>();
    private final List<Operation> columnOperations = new ArrayList<Operation>();
    private List<ColumnCondition> columnConditions;
    private List<ColumnCondition> staticConditions;
    private boolean ifNotExists;
    private boolean ifExists;
    private boolean hasNoClusteringColumns = true;
    private boolean setsStaticColumns;
    private boolean setsRegularColumns;
    private final Function<ColumnCondition, ColumnDefinition> getColumnForCondition = new Function<ColumnCondition, ColumnDefinition>(){

        public ColumnDefinition apply(ColumnCondition cond) {
            return cond.column;
        }
    };

    public ModificationStatement(StatementType type, int boundTerms, CFMetaData cfm, Attributes attrs) {
        this.type = type;
        this.boundTerms = boundTerms;
        this.cfm = cfm;
        this.attrs = attrs;
    }

    @Override
    public Iterable<org.apache.cassandra.cql3.functions.Function> getFunctions() {
        Iterable functions = this.attrs.getFunctions();
        for (Restriction restriction : this.processedKeys.values()) {
            functions = Iterables.concat(functions, restriction.getFunctions());
        }
        if (this.columnOperations != null) {
            for (Operation operation : this.columnOperations) {
                functions = Iterables.concat((Iterable)functions, operation.getFunctions());
            }
        }
        if (this.columnConditions != null) {
            for (ColumnCondition condition : this.columnConditions) {
                functions = Iterables.concat((Iterable)functions, condition.getFunctions());
            }
        }
        if (this.staticConditions != null) {
            for (ColumnCondition condition : this.staticConditions) {
                functions = Iterables.concat((Iterable)functions, condition.getFunctions());
            }
        }
        return functions;
    }

    public abstract boolean requireFullClusteringKey();

    public abstract void addUpdateForKey(ColumnFamily var1, ByteBuffer var2, Composite var3, UpdateParameters var4) throws InvalidRequestException;

    @Override
    public int getBoundTerms() {
        return this.boundTerms;
    }

    public String keyspace() {
        return this.cfm.ksName;
    }

    public String columnFamily() {
        return this.cfm.cfName;
    }

    public boolean isCounter() {
        return this.cfm.isCounter();
    }

    public long getTimestamp(long now, QueryOptions options) throws InvalidRequestException {
        return this.attrs.getTimestamp(now, options);
    }

    public boolean isTimestampSet() {
        return this.attrs.isTimestampSet();
    }

    public int getTimeToLive(QueryOptions options) throws InvalidRequestException {
        return this.attrs.getTimeToLive(options);
    }

    @Override
    public void checkAccess(ClientState state) throws InvalidRequestException, UnauthorizedException {
        state.hasColumnFamilyAccess(this.keyspace(), this.columnFamily(), Permission.MODIFY);
        if (this.hasConditions()) {
            state.hasColumnFamilyAccess(this.keyspace(), this.columnFamily(), Permission.SELECT);
        }
        for (org.apache.cassandra.cql3.functions.Function function : this.getFunctions()) {
            state.ensureHasPermission(Permission.EXECUTE, function);
        }
    }

    @Override
    public void validate(ClientState state) throws InvalidRequestException {
        if (this.hasConditions() && this.attrs.isTimestampSet()) {
            throw new InvalidRequestException("Cannot provide custom timestamp for conditional updates");
        }
        if (this.isCounter() && this.attrs.isTimestampSet()) {
            throw new InvalidRequestException("Cannot provide custom timestamp for counter updates");
        }
        if (this.isCounter() && this.attrs.isTimeToLiveSet()) {
            throw new InvalidRequestException("Cannot provide custom TTL for counter updates");
        }
    }

    public void addOperation(Operation op) {
        if (op.column.isStatic()) {
            this.setsStaticColumns = true;
        } else {
            this.setsRegularColumns = true;
        }
        this.columnOperations.add(op);
    }

    public List<Operation> getOperations() {
        return this.columnOperations;
    }

    public Iterable<ColumnDefinition> getColumnsWithConditions() {
        if (this.ifNotExists || this.ifExists) {
            return null;
        }
        return Iterables.concat(this.columnConditions == null ? Collections.emptyList() : Iterables.transform(this.columnConditions, this.getColumnForCondition), this.staticConditions == null ? Collections.emptyList() : Iterables.transform(this.staticConditions, this.getColumnForCondition));
    }

    public void addCondition(ColumnCondition cond) {
        List<ColumnCondition> conds = null;
        if (cond.column.isStatic()) {
            this.setsStaticColumns = true;
            if (this.staticConditions == null) {
                this.staticConditions = new ArrayList<ColumnCondition>();
            }
            conds = this.staticConditions;
        } else {
            this.setsRegularColumns = true;
            if (this.columnConditions == null) {
                this.columnConditions = new ArrayList<ColumnCondition>();
            }
            conds = this.columnConditions;
        }
        conds.add(cond);
    }

    public void setIfNotExistCondition() {
        this.ifNotExists = true;
    }

    public boolean hasIfNotExistCondition() {
        return this.ifNotExists;
    }

    public void setIfExistCondition() {
        this.ifExists = true;
    }

    public boolean hasIfExistCondition() {
        return this.ifExists;
    }

    private void addKeyValues(ColumnDefinition def, Restriction values) throws InvalidRequestException {
        if (def.kind == ColumnDefinition.Kind.CLUSTERING_COLUMN) {
            this.hasNoClusteringColumns = false;
        }
        if (this.processedKeys.put(def.name, values) != null) {
            throw new InvalidRequestException(String.format("Multiple definitions found for PRIMARY KEY part %s", def.name));
        }
    }

    public void addKeyValue(ColumnDefinition def, Term value) throws InvalidRequestException {
        this.addKeyValues(def, new SingleColumnRestriction.EQ(def, value));
    }

    public void processWhereClause(List<Relation> whereClause, VariableSpecifications names) throws InvalidRequestException {
        block3: for (Relation relation : whereClause) {
            if (relation.isMultiColumn()) {
                throw new InvalidRequestException(String.format("Multi-column relations cannot be used in WHERE clauses for UPDATE and DELETE statements: %s", relation));
            }
            SingleColumnRelation rel = (SingleColumnRelation)relation;
            if (rel.onToken()) {
                throw new InvalidRequestException(String.format("The token function cannot be used in WHERE clauses for UPDATE and DELETE statements: %s", relation));
            }
            ColumnIdentifier id = rel.getEntity().prepare(this.cfm);
            ColumnDefinition def = this.cfm.getColumnDefinition(id);
            if (def == null) {
                throw new InvalidRequestException(String.format("Unknown key identifier %s", id));
            }
            switch (def.kind) {
                case PARTITION_KEY: 
                case CLUSTERING_COLUMN: {
                    if (!(rel.isEQ() || def.isPartitionKey() && rel.isIN())) {
                        throw new InvalidRequestException(String.format("Invalid operator %s for PRIMARY KEY part %s", new Object[]{rel.operator(), def.name}));
                    }
                    Restriction restriction = rel.toRestriction(this.cfm, names);
                    this.addKeyValues(def, restriction);
                    continue block3;
                }
            }
            throw new InvalidRequestException(String.format("Non PRIMARY KEY %s found in where clause", def.name));
        }
    }

    public List<ByteBuffer> buildPartitionKeyNames(QueryOptions options) throws InvalidRequestException {
        CompositesBuilder keyBuilder = new CompositesBuilder(this.cfm.getKeyValidatorAsCType());
        for (ColumnDefinition def : this.cfm.partitionKeyColumns()) {
            Restriction r = RequestValidations.checkNotNull(this.processedKeys.get(def.name), "Missing mandatory PRIMARY KEY part %s", def.name);
            r.appendTo(keyBuilder, options);
        }
        return Lists.transform(keyBuilder.build(), (Function)new Function<Composite, ByteBuffer>(){

            public ByteBuffer apply(Composite composite) {
                ByteBuffer byteBuffer = composite.toByteBuffer();
                ThriftValidation.validateKey(ModificationStatement.this.cfm, byteBuffer);
                return byteBuffer;
            }
        });
    }

    public Composite createClusteringPrefix(QueryOptions options) throws InvalidRequestException {
        if (this.setsStaticColumns && !this.setsRegularColumns) {
            if (this.hasNoClusteringColumns) {
                return this.cfm.comparator.staticPrefix();
            }
            if (this.type != StatementType.INSERT) {
                for (ColumnDefinition def : this.cfm.clusteringColumns()) {
                    if (this.processedKeys.get(def.name) == null) continue;
                    throw new InvalidRequestException(String.format("Invalid restriction on clustering column %s since the %s statement modifies only static columns", new Object[]{def.name, this.type}));
                }
                throw new AssertionError();
            }
        }
        return this.createClusteringPrefixBuilderInternal(options);
    }

    private Composite createClusteringPrefixBuilderInternal(QueryOptions options) throws InvalidRequestException {
        CompositesBuilder builder = new CompositesBuilder(this.cfm.comparator);
        ColumnDefinition firstEmptyKey = null;
        for (ColumnDefinition def : this.cfm.clusteringColumns()) {
            Restriction r = this.processedKeys.get(def.name);
            if (r == null) {
                firstEmptyKey = def;
                RequestValidations.checkFalse(this.requireFullClusteringKey() && !this.cfm.comparator.isDense() && this.cfm.comparator.isCompound(), "Missing mandatory PRIMARY KEY part %s", def.name);
                continue;
            }
            if (firstEmptyKey != null) {
                throw RequestValidations.invalidRequest("Missing PRIMARY KEY part %s since %s is set", firstEmptyKey.name, def.name);
            }
            r.appendTo(builder, options);
        }
        return builder.build().get(0);
    }

    protected ColumnDefinition getFirstEmptyKey() {
        for (ColumnDefinition def : this.cfm.clusteringColumns()) {
            if (this.processedKeys.get(def.name) != null) continue;
            return def;
        }
        return null;
    }

    public boolean requiresRead() {
        for (Operation op : this.columnOperations) {
            if (!op.requiresRead()) continue;
            return true;
        }
        return false;
    }

    protected Map<ByteBuffer, CQL3Row> readRequiredRows(Collection<ByteBuffer> partitionKeys, Composite clusteringPrefix, boolean local, ConsistencyLevel cl) throws RequestExecutionException, RequestValidationException {
        if (!this.requiresRead()) {
            return null;
        }
        try {
            cl.validateForRead(this.keyspace());
        }
        catch (InvalidRequestException e) {
            throw new InvalidRequestException(String.format("Write operation require a read but consistency %s is not supported on reads", new Object[]{cl}));
        }
        ColumnSlice[] slices = new ColumnSlice[]{clusteringPrefix.slice()};
        ArrayList<ReadCommand> commands = new ArrayList<ReadCommand>(partitionKeys.size());
        long now = System.currentTimeMillis();
        for (ByteBuffer key : partitionKeys) {
            commands.add(new SliceFromReadCommand(this.keyspace(), key, this.columnFamily(), now, new SliceQueryFilter(slices, false, Integer.MAX_VALUE)));
        }
        List<Row> rows = local ? SelectStatement.readLocally(this.keyspace(), commands) : StorageProxy.read(commands, cl);
        HashMap<ByteBuffer, CQL3Row> map = new HashMap<ByteBuffer, CQL3Row>();
        for (Row row : rows) {
            if (row.cf == null || row.cf.isEmpty()) continue;
            CQL3Row.RowIterator iter = this.cfm.comparator.CQL3RowBuilder(this.cfm, now).group(row.cf.getSortedColumns().iterator());
            if (iter.getStaticRow() != null) {
                map.put(row.key.getKey(), iter.getStaticRow());
            }
            if (!iter.hasNext()) continue;
            map.put(row.key.getKey(), (CQL3Row)iter.next());
            assert (!iter.hasNext());
        }
        return map;
    }

    public boolean hasConditions() {
        return this.ifNotExists || this.ifExists || this.columnConditions != null && !this.columnConditions.isEmpty() || this.staticConditions != null && !this.staticConditions.isEmpty();
    }

    @Override
    public ResultMessage execute(QueryState queryState, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        if (options.getConsistency() == null) {
            throw new InvalidRequestException("Invalid empty consistency level");
        }
        if (this.hasConditions() && options.getProtocolVersion() == 1) {
            throw new InvalidRequestException("Conditional updates are not supported by the protocol version in use. You need to upgrade to a driver using the native protocol v2.");
        }
        return this.hasConditions() ? this.executeWithCondition(queryState, options) : this.executeWithoutCondition(queryState, options);
    }

    private ResultMessage executeWithoutCondition(QueryState queryState, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        ConsistencyLevel cl = options.getConsistency();
        if (this.isCounter()) {
            cl.validateCounterForWrite(this.cfm);
        } else {
            cl.validateForWrite(this.cfm.ksName);
        }
        Collection<? extends IMutation> mutations = this.getMutations(options, false, options.getTimestamp(queryState));
        if (!mutations.isEmpty()) {
            StorageProxy.mutateWithTriggers(mutations, cl, false);
        }
        return null;
    }

    public ResultMessage executeWithCondition(QueryState queryState, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        CQL3CasRequest request = this.makeCasRequest(queryState, options);
        ColumnFamily result = StorageProxy.cas(this.keyspace(), this.columnFamily(), request.key, request, options.getSerialConsistency(), options.getConsistency(), queryState.getClientState());
        return new ResultMessage.Rows(this.buildCasResultSet(request.key, result, options));
    }

    private CQL3CasRequest makeCasRequest(QueryState queryState, QueryOptions options) {
        List<ByteBuffer> keys = this.buildPartitionKeyNames(options);
        if (keys.size() > 1) {
            throw new InvalidRequestException("IN on the partition key is not supported with conditional updates");
        }
        ByteBuffer key = keys.get(0);
        long now = options.getTimestamp(queryState);
        Composite prefix = this.createClusteringPrefix(options);
        CQL3CasRequest request = new CQL3CasRequest(this.cfm, key, false);
        this.addConditions(prefix, request, options);
        request.addRowUpdate(prefix, this, options, now);
        return request;
    }

    public void addConditions(Composite clusteringPrefix, CQL3CasRequest request, QueryOptions options) throws InvalidRequestException {
        if (this.ifNotExists) {
            request.addNotExist(clusteringPrefix);
        } else if (this.ifExists) {
            request.addExist(clusteringPrefix);
        } else {
            if (this.columnConditions != null) {
                request.addConditions(clusteringPrefix, this.columnConditions, options);
            }
            if (this.staticConditions != null) {
                request.addConditions(this.cfm.comparator.staticPrefix(), this.staticConditions, options);
            }
        }
    }

    private ResultSet buildCasResultSet(ByteBuffer key, ColumnFamily cf, QueryOptions options) throws InvalidRequestException {
        return ModificationStatement.buildCasResultSet(this.keyspace(), key, this.columnFamily(), cf, this.getColumnsWithConditions(), false, options);
    }

    public static ResultSet buildCasResultSet(String ksName, ByteBuffer key, String cfName, ColumnFamily cf, Iterable<ColumnDefinition> columnsWithConditions, boolean isBatch, QueryOptions options) throws InvalidRequestException {
        boolean success = cf == null;
        ColumnSpecification spec = new ColumnSpecification(ksName, cfName, CAS_RESULT_COLUMN, BooleanType.instance);
        ResultSet.ResultMetadata metadata = new ResultSet.ResultMetadata(Collections.singletonList(spec));
        List<List<ByteBuffer>> rows = Collections.singletonList(Collections.singletonList(BooleanType.instance.decompose(success)));
        ResultSet rs = new ResultSet(metadata, rows);
        return success ? rs : ModificationStatement.merge(rs, ModificationStatement.buildCasFailureResultSet(key, cf, columnsWithConditions, isBatch, options));
    }

    private static ResultSet merge(ResultSet left, ResultSet right) {
        if (left.size() == 0) {
            return right;
        }
        if (right.size() == 0) {
            return left;
        }
        assert (left.size() == 1);
        int size = left.metadata.names.size() + right.metadata.names.size();
        ArrayList<ColumnSpecification> specs = new ArrayList<ColumnSpecification>(size);
        specs.addAll(left.metadata.names);
        specs.addAll(right.metadata.names);
        ArrayList<List<ByteBuffer>> rows = new ArrayList<List<ByteBuffer>>(right.size());
        for (int i = 0; i < right.size(); ++i) {
            ArrayList row = new ArrayList(size);
            row.addAll(left.rows.get(0));
            row.addAll(right.rows.get(i));
            rows.add(row);
        }
        return new ResultSet(new ResultSet.ResultMetadata(specs), rows);
    }

    private static ResultSet buildCasFailureResultSet(ByteBuffer key, ColumnFamily cf, Iterable<ColumnDefinition> columnsWithConditions, boolean isBatch, QueryOptions options) throws InvalidRequestException {
        Selection selection;
        CFMetaData cfm = cf.metadata();
        if (columnsWithConditions == null) {
            selection = Selection.wildcard(cfm);
        } else {
            LinkedHashSet<ColumnDefinition> defs = new LinkedHashSet<ColumnDefinition>();
            if (isBatch) {
                defs.addAll(cfm.partitionKeyColumns());
                defs.addAll(cfm.clusteringColumns());
            }
            for (ColumnDefinition def : columnsWithConditions) {
                defs.add(def);
            }
            selection = Selection.forColumns(cfm, new ArrayList<ColumnDefinition>(defs));
        }
        long now = System.currentTimeMillis();
        Selection.ResultSetBuilder builder = selection.resultSetBuilder(now, false);
        SelectStatement.forSelection(cfm, selection).processColumnFamily(key, cf, options, now, builder);
        return builder.build(options.getProtocolVersion());
    }

    @Override
    public ResultMessage executeInternal(QueryState queryState, QueryOptions options) throws RequestValidationException, RequestExecutionException {
        return this.hasConditions() ? this.executeInternalWithCondition(queryState, options) : this.executeInternalWithoutCondition(queryState, options);
    }

    public ResultMessage executeInternalWithoutCondition(QueryState queryState, QueryOptions options) throws RequestValidationException, RequestExecutionException {
        for (IMutation iMutation : this.getMutations(options, true, queryState.getTimestamp())) {
            assert (iMutation instanceof Mutation || iMutation instanceof CounterMutation);
            if (iMutation instanceof Mutation) {
                ((Mutation)iMutation).apply();
                continue;
            }
            if (!(iMutation instanceof CounterMutation)) continue;
            ((CounterMutation)iMutation).apply();
        }
        return null;
    }

    public ResultMessage executeInternalWithCondition(QueryState state, QueryOptions options) throws RequestValidationException, RequestExecutionException {
        CQL3CasRequest request = this.makeCasRequest(state, options);
        ColumnFamily result = ModificationStatement.casInternal(request, state);
        return new ResultMessage.Rows(this.buildCasResultSet(request.key, result, options));
    }

    static ColumnFamily casInternal(CQL3CasRequest request, QueryState state) {
        UUID ballot = UUIDGen.getTimeUUIDFromMicros(state.getTimestamp());
        CFMetaData metadata = Schema.instance.getCFMetaData(request.cfm.ksName, request.cfm.cfName);
        ReadCommand readCommand = ReadCommand.create(request.cfm.ksName, request.key, request.cfm.cfName, request.now, request.readFilter());
        Keyspace keyspace = Keyspace.open(request.cfm.ksName);
        Row row = readCommand.getRow(keyspace);
        ColumnFamily current = row.cf;
        if (!request.appliesTo(current)) {
            if (current == null) {
                current = ArrayBackedSortedColumns.factory.create(metadata);
            }
            return current;
        }
        ColumnFamily updates = request.makeUpdates(current);
        updates = TriggerExecutor.instance.execute(request.key, updates);
        Commit proposal = Commit.newProposal(request.key, ballot, updates);
        proposal.makeMutation().apply();
        return null;
    }

    private Collection<? extends IMutation> getMutations(QueryOptions options, boolean local, long now) throws RequestExecutionException, RequestValidationException {
        List<ByteBuffer> keys = this.buildPartitionKeyNames(options);
        Composite clusteringPrefix = this.createClusteringPrefix(options);
        UpdateParameters params = this.makeUpdateParameters(keys, clusteringPrefix, options, local, now);
        ArrayList<Mutation> mutations = new ArrayList<Mutation>(keys.size());
        for (ByteBuffer key : keys) {
            ThriftValidation.validateKey(this.cfm, key);
            ArrayBackedSortedColumns cf = ArrayBackedSortedColumns.factory.create(this.cfm);
            this.addUpdateForKey(cf, key, clusteringPrefix, params);
            Mutation mut = new Mutation(this.cfm.ksName, key, cf);
            mutations.add((Mutation)(this.isCounter() ? new CounterMutation(mut, options.getConsistency()) : mut));
        }
        return mutations;
    }

    public UpdateParameters makeUpdateParameters(Collection<ByteBuffer> keys, Composite prefix, QueryOptions options, boolean local, long now) throws RequestExecutionException, RequestValidationException {
        Map<ByteBuffer, CQL3Row> rows = this.readRequiredRows(keys, prefix, local, options.getConsistency());
        return new UpdateParameters(this.cfm, options, this.getTimestamp(now, options), this.getTimeToLive(options), rows);
    }

    protected void validateWhereClauseForConditions() throws InvalidRequestException {
    }

    public static abstract class Parsed
    extends CFStatement {
        protected final Attributes.Raw attrs;
        protected final List<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>> conditions;
        private final boolean ifNotExists;
        private final boolean ifExists;

        protected Parsed(CFName name, Attributes.Raw attrs, List<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>> conditions, boolean ifNotExists, boolean ifExists) {
            super(name);
            this.attrs = attrs;
            this.conditions = conditions == null ? Collections.emptyList() : conditions;
            this.ifNotExists = ifNotExists;
            this.ifExists = ifExists;
        }

        @Override
        public ParsedStatement.Prepared prepare() throws InvalidRequestException {
            VariableSpecifications boundNames = this.getBoundVariables();
            ModificationStatement statement = this.prepare(boundNames);
            CFMetaData cfm = ThriftValidation.validateColumnFamily(this.keyspace(), this.columnFamily());
            return new ParsedStatement.Prepared((CQLStatement)statement, boundNames, boundNames.getPartitionKeyBindIndexes(cfm));
        }

        public ModificationStatement prepare(VariableSpecifications boundNames) throws InvalidRequestException {
            CFMetaData metadata = ThriftValidation.validateColumnFamily(this.keyspace(), this.columnFamily());
            Attributes preparedAttributes = this.attrs.prepare(this.keyspace(), this.columnFamily());
            preparedAttributes.collectMarkerSpecification(boundNames);
            ModificationStatement stmt = this.prepareInternal(metadata, boundNames, preparedAttributes);
            if (this.ifNotExists || this.ifExists || !this.conditions.isEmpty()) {
                if (stmt.isCounter()) {
                    throw new InvalidRequestException("Conditional updates are not supported on counter tables");
                }
                if (this.attrs.timestamp != null) {
                    throw new InvalidRequestException("Cannot provide custom timestamp for conditional updates");
                }
                if (this.ifNotExists) {
                    assert (this.conditions.isEmpty());
                    assert (!this.ifExists);
                    stmt.setIfNotExistCondition();
                } else if (this.ifExists) {
                    assert (this.conditions.isEmpty());
                    assert (!this.ifNotExists);
                    stmt.setIfExistCondition();
                } else {
                    for (Pair<ColumnIdentifier.Raw, ColumnCondition.Raw> entry : this.conditions) {
                        ColumnIdentifier id = ((ColumnIdentifier.Raw)entry.left).prepare(metadata);
                        ColumnDefinition def = metadata.getColumnDefinition(id);
                        if (def == null) {
                            throw new InvalidRequestException(String.format("Unknown identifier %s", id));
                        }
                        ColumnCondition condition = ((ColumnCondition.Raw)entry.right).prepare(this.keyspace(), def);
                        condition.collectMarkerSpecification(boundNames);
                        switch (def.kind) {
                            case PARTITION_KEY: 
                            case CLUSTERING_COLUMN: {
                                throw new InvalidRequestException(String.format("PRIMARY KEY column '%s' cannot have IF conditions", id));
                            }
                        }
                        stmt.addCondition(condition);
                    }
                }
                stmt.validateWhereClauseForConditions();
            }
            return stmt;
        }

        protected abstract ModificationStatement prepareInternal(CFMetaData var1, VariableSpecifications var2, Attributes var3) throws InvalidRequestException;
    }

    public static enum StatementType {
        INSERT,
        UPDATE,
        DELETE;

    }
}

